/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.actors;

import java.text.MessageFormat;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractManagementActor;

public class ManagementActor
extends AbstractManagementActor {
    private String _lastThreadName = null;
    private String _logStringContainingPrincipal;

    public ManagementActor(RootMessageLogger rootLogger) {
        super(rootLogger, "N/A");
    }

    public ManagementActor(RootMessageLogger rootLogger, String principalName) {
        super(rootLogger, principalName);
    }

    private synchronized String getAndCacheLogString() {
        String currentName = Thread.currentThread().getName();
        String logString = this._logStringContainingPrincipal;
        if (this._logStringContainingPrincipal == null || !currentName.equals(this._lastThreadName)) {
            String actor;
            this._lastThreadName = currentName;
            String principalName = this.getPrincipalName();
            String[] split = currentName.split("\\(");
            if (split.length == 2) {
                String ip = currentName.split("-")[1];
                actor = MessageFormat.format("mng:{0}({1})", principalName, ip);
            } else {
                actor = currentName;
            }
            logString = "[" + actor + "] ";
            if (principalName != "N/A") {
                this._logStringContainingPrincipal = logString;
            }
        }
        return logString;
    }

    public String getLogMessage() {
        return this.getAndCacheLogString();
    }
}

