/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Broker
extends ConfiguredObject {
    public static final String BUILD_VERSION = "buildVersion";
    public static final String BYTES_RETAINED = "bytesRetained";
    public static final String OPERATING_SYSTEM = "operatingSystem";
    public static final String PLATFORM = "platform";
    public static final String PROCESS_PID = "processPid";
    public static final String PRODUCT_VERSION = "productVersion";
    public static final String SUPPORTED_BROKER_STORE_TYPES = "supportedBrokerStoreTypes";
    public static final String SUPPORTED_VIRTUALHOST_STORE_TYPES = "supportedVirtualHostStoreTypes";
    public static final String SUPPORTED_AUTHENTICATION_PROVIDERS = "supportedAuthenticationProviders";
    public static final String CREATED = "created";
    public static final String DURABLE = "durable";
    public static final String ID = "id";
    public static final String LIFETIME_POLICY = "lifetimePolicy";
    public static final String NAME = "name";
    public static final String STATE = "state";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String UPDATED = "updated";
    public static final String DEFAULT_VIRTUAL_HOST = "defaultVirtualHost";
    public static final String STATISTICS_REPORTING_PERIOD = "statisticsReportingPeriod";
    public static final String STATISTICS_REPORTING_RESET_ENABLED = "statisticsReportingResetEnabled";
    public static final String STORE_TYPE = "storeType";
    public static final String STORE_VERSION = "storeVersion";
    public static final String STORE_PATH = "storePath";
    public static final String MODEL_VERSION = "modelVersion";
    public static final String QUEUE_ALERT_THRESHOLD_MESSAGE_AGE = "queue.alertThresholdMessageAge";
    public static final String QUEUE_ALERT_THRESHOLD_QUEUE_DEPTH_MESSAGES = "queue.alertThresholdQueueDepthMessages";
    public static final String QUEUE_ALERT_THRESHOLD_QUEUE_DEPTH_BYTES = "queue.alertThresholdQueueDepthBytes";
    public static final String QUEUE_ALERT_THRESHOLD_MESSAGE_SIZE = "queue.alertThresholdMessageSize";
    public static final String QUEUE_ALERT_REPEAT_GAP = "queue.alertRepeatGap";
    public static final String QUEUE_FLOW_CONTROL_SIZE_BYTES = "queue.flowControlSizeBytes";
    public static final String QUEUE_FLOW_CONTROL_RESUME_SIZE_BYTES = "queue.flowResumeSizeBytes";
    public static final String QUEUE_MAXIMUM_DELIVERY_ATTEMPTS = "queue.maximumDeliveryAttempts";
    public static final String QUEUE_DEAD_LETTER_QUEUE_ENABLED = "queue.deadLetterQueueEnabled";
    public static final String CONNECTION_SESSION_COUNT_LIMIT = "connection.sessionCountLimit";
    public static final String CONNECTION_HEART_BEAT_DELAY = "connection.heartBeatDelay";
    public static final String VIRTUALHOST_HOUSEKEEPING_CHECK_PERIOD = "virtualhost.housekeepingCheckPeriod";
    public static final String VIRTUALHOST_STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = "virtualhost.storeTransactionIdleTimeoutClose";
    public static final String VIRTUALHOST_STORE_TRANSACTION_IDLE_TIMEOUT_WARN = "virtualhost.storeTransactionIdleTimeoutWarn";
    public static final String VIRTUALHOST_STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = "virtualhost.storeTransactionOpenTimeoutClose";
    public static final String VIRTUALHOST_STORE_TRANSACTION_OPEN_TIMEOUT_WARN = "virtualhost.storeTransactionOpenTimeoutWarn";
    public static final Collection<String> AVAILABLE_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("buildVersion", "bytesRetained", "operatingSystem", "platform", "processPid", "productVersion", "supportedBrokerStoreTypes", "supportedVirtualHostStoreTypes", "supportedAuthenticationProviders", "created", "durable", "id", "lifetimePolicy", "name", "state", "timeToLive", "updated", "defaultVirtualHost", "queue.alertThresholdMessageAge", "queue.alertThresholdQueueDepthMessages", "queue.alertThresholdQueueDepthBytes", "queue.alertThresholdMessageSize", "queue.alertRepeatGap", "queue.flowControlSizeBytes", "queue.flowResumeSizeBytes", "queue.maximumDeliveryAttempts", "queue.deadLetterQueueEnabled", "virtualhost.housekeepingCheckPeriod", "connection.sessionCountLimit", "connection.heartBeatDelay", "statisticsReportingPeriod", "statisticsReportingResetEnabled", "storeType", "storeVersion", "storePath", "modelVersion", "virtualhost.storeTransactionIdleTimeoutClose", "virtualhost.storeTransactionIdleTimeoutWarn", "virtualhost.storeTransactionOpenTimeoutClose", "virtualhost.storeTransactionOpenTimeoutWarn"));

    public Collection<VirtualHost> getVirtualHosts();

    public Collection<Port> getPorts();

    public Collection<AuthenticationProvider> getAuthenticationProviders();

    public Collection<AccessControlProvider> getAccessControlProviders();

    public Collection<GroupProvider> getGroupProviders();

    public RootMessageLogger getRootMessageLogger();

    public SecurityManager getSecurityManager();

    public LogRecorder getLogRecorder();

    public AuthenticationProvider findAuthenticationProviderByName(String var1);

    public VirtualHost findVirtualHostByName(String var1);

    public KeyStore findKeyStoreByName(String var1);

    public TrustStore findTrustStoreByName(String var1);

    public SubjectCreator getSubjectCreator(SocketAddress var1);

    public Collection<KeyStore> getKeyStores();

    public Collection<TrustStore> getTrustStores();

    public VirtualHostRegistry getVirtualHostRegistry();

    public TaskExecutor getTaskExecutor();

    public boolean isManagementMode();
}

