/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    public static final int MODEL_MAJOR_VERSION = 1;
    public static final int MODEL_MINOR_VERSION = 0;
    public static final String MODEL_VERSION = "1.0";
    private static final Model MODEL_INSTANCE = new Model();
    private final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> _parents = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();
    private final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> _children = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();

    public static Model getInstance() {
        return MODEL_INSTANCE;
    }

    private Model() {
        this.addRelationship(Broker.class, VirtualHost.class);
        this.addRelationship(Broker.class, Port.class);
        this.addRelationship(Broker.class, AccessControlProvider.class);
        this.addRelationship(Broker.class, AuthenticationProvider.class);
        this.addRelationship(Broker.class, GroupProvider.class);
        this.addRelationship(Broker.class, TrustStore.class);
        this.addRelationship(Broker.class, KeyStore.class);
        this.addRelationship(Broker.class, Plugin.class);
        this.addRelationship(VirtualHost.class, Exchange.class);
        this.addRelationship(VirtualHost.class, Queue.class);
        this.addRelationship(VirtualHost.class, Connection.class);
        this.addRelationship(VirtualHost.class, VirtualHostAlias.class);
        this.addRelationship(AuthenticationProvider.class, User.class);
        this.addRelationship(User.class, GroupMember.class);
        this.addRelationship(GroupProvider.class, Group.class);
        this.addRelationship(Group.class, GroupMember.class);
        this.addRelationship(Connection.class, Session.class);
        this.addRelationship(Exchange.class, Binding.class);
        this.addRelationship(Exchange.class, Publisher.class);
        this.addRelationship(Queue.class, Binding.class);
        this.addRelationship(Queue.class, Consumer.class);
        this.addRelationship(Session.class, Consumer.class);
        this.addRelationship(Session.class, Publisher.class);
    }

    public Collection<Class<? extends ConfiguredObject>> getParentTypes(Class<? extends ConfiguredObject> child) {
        Collection<Class<? extends ConfiguredObject>> parentTypes = this._parents.get(child);
        return parentTypes == null ? Collections.emptyList() : Collections.unmodifiableCollection(parentTypes);
    }

    public Collection<Class<? extends ConfiguredObject>> getChildTypes(Class<? extends ConfiguredObject> parent) {
        Collection<Class<? extends ConfiguredObject>> childTypes = this._children.get(parent);
        return childTypes == null ? Collections.emptyList() : Collections.unmodifiableCollection(childTypes);
    }

    private void addRelationship(Class<? extends ConfiguredObject> parent, Class<? extends ConfiguredObject> child) {
        Collection<Class<? extends ConfiguredObject>> parents = this._parents.get(child);
        if (parents == null) {
            parents = new ArrayList<Class<? extends ConfiguredObject>>();
            this._parents.put(child, parents);
        }
        parents.add(parent);
        Collection<Class<? extends ConfiguredObject>> children = this._children.get(parent);
        if (children == null) {
            children = new ArrayList<Class<? extends ConfiguredObject>>();
            this._children.put(parent, children);
        }
        children.add(child);
    }
}

