/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.ChangeAttributesTask;
import org.apache.qpid.server.configuration.updater.ChangeStateTask;
import org.apache.qpid.server.configuration.updater.CreateChildTask;
import org.apache.qpid.server.configuration.updater.SetAttributeTask;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAdapter
implements ConfiguredObject {
    private static final Object ID = "id";
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private final Map<Class<? extends ConfiguredObject>, ConfiguredObject> _parents = new HashMap<Class<? extends ConfiguredObject>, ConfiguredObject>();
    private final Collection<ConfigurationChangeListener> _changeListeners = new ArrayList<ConfigurationChangeListener>();
    private final UUID _id;
    private final Map<String, Object> _defaultAttributes = new HashMap<String, Object>();
    private final TaskExecutor _taskExecutor;

    protected AbstractAdapter(UUID id, Map<String, Object> defaults, Map<String, Object> attributes, TaskExecutor taskExecutor) {
        this._taskExecutor = taskExecutor;
        this._id = id;
        if (attributes != null) {
            Collection<String> names = this.getAttributeNames();
            for (String name : names) {
                if (!attributes.containsKey(name)) continue;
                this._attributes.put(name, attributes.get(name));
            }
        }
        if (defaults != null) {
            this._defaultAttributes.putAll(defaults);
        }
    }

    protected AbstractAdapter(UUID id, TaskExecutor taskExecutor) {
        this(id, null, null, taskExecutor);
    }

    @Override
    public final UUID getId() {
        return this._id;
    }

    @Override
    public State getDesiredState() {
        return null;
    }

    @Override
    public final State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
        if (this._taskExecutor.isTaskExecutorThread()) {
            this.authoriseSetDesiredState(currentState, desiredState);
            if (this.setState(currentState, desiredState)) {
                this.notifyStateChanged(currentState, desiredState);
                return desiredState;
            }
            return this.getActualState();
        }
        return (State)((Object)this._taskExecutor.submitAndWait(new ChangeStateTask(this, currentState, desiredState)));
    }

    protected abstract boolean setState(State var1, State var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged(State currentState, State desiredState) {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.stateChanged(this, currentState, desiredState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            if (!this._changeListeners.contains(listener)) {
                this._changeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            return this._changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void childAdded(ConfiguredObject child) {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.childAdded(this, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void childRemoved(ConfiguredObject child) {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.childRemoved(this, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attributeSet(String attrinuteName, Object oldAttributeValue, Object newAttributeValue) {
        Collection<ConfigurationChangeListener> collection = this._changeListeners;
        synchronized (collection) {
            ArrayList<ConfigurationChangeListener> copy = new ArrayList<ConfigurationChangeListener>(this._changeListeners);
            for (ConfigurationChangeListener listener : copy) {
                listener.attributeSet(this, attrinuteName, oldAttributeValue, newAttributeValue);
            }
        }
    }

    private final Object getDefaultAttribute(String name) {
        return this._defaultAttributes.get(name);
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.getActualAttribute(name);
        if (value == null) {
            value = this.getDefaultAttribute(name);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Object> getActualAttributes() {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            return new HashMap<String, Object>(this._attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getActualAttribute(String name) {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            return this._attributes.get(name);
        }
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        if (this._taskExecutor.isTaskExecutorThread()) {
            this.authoriseSetAttribute(name, expected, desired);
            if (this.changeAttribute(name, expected, desired)) {
                this.attributeSet(name, expected, desired);
                return desired;
            }
            return this.getAttribute(name);
        }
        return this._taskExecutor.submitAndWait(new SetAttributeTask(this, name, expected, desired));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean changeAttribute(String name, Object expected, Object desired) {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            Object currentValue = this.getAttribute(name);
            if (currentValue == null && expected == null || currentValue != null && currentValue.equals(expected)) {
                this._attributes.put(name, desired);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ConfiguredObject> T getParent(Class<T> clazz) {
        Map<Class<? extends ConfiguredObject>, ConfiguredObject> map = this._parents;
        synchronized (map) {
            return (T)this._parents.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ConfiguredObject> void addParent(Class<T> clazz, T parent) {
        Map<Class<? extends ConfiguredObject>, ConfiguredObject> map = this._parents;
        synchronized (map) {
            this._parents.put(clazz, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ConfiguredObject> void removeParent(Class<T> clazz) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            this._parents.remove(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAttributeNames() {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            return new ArrayList<String>(this._attributes.keySet());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this._id + ", name=" + this.getName() + "]";
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (this._taskExecutor.isTaskExecutorThread()) {
            this.authoriseCreateChild(childClass, attributes, otherParents);
            C child = this.addChild(childClass, attributes, otherParents);
            if (child != null) {
                this.childAdded((ConfiguredObject)child);
            }
            return child;
        }
        return (C)((ConfiguredObject)this._taskExecutor.submitAndWait(new CreateChildTask(this, childClass, attributes, otherParents)));
    }

    protected <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }

    protected TaskExecutor getTaskExecutor() {
        return this._taskExecutor;
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        if (this.getTaskExecutor().isTaskExecutorThread()) {
            this.authoriseSetAttributes(attributes);
            this.changeAttributes(attributes);
        } else {
            this.getTaskExecutor().submitAndWait(new ChangeAttributesTask(this, attributes));
        }
    }

    protected void changeAttributes(Map<String, Object> attributes) {
        this.validateChangeAttributes(attributes);
        Collection<String> names = this.getAttributeNames();
        for (String name : names) {
            if (!attributes.containsKey(name)) continue;
            Object desired = attributes.get(name);
            Object expected = this.getAttribute(name);
            if (!this.changeAttribute(name, expected, desired)) continue;
            this.attributeSet(name, expected, desired);
        }
    }

    protected void validateChangeAttributes(Map<String, Object> attributes) {
        if (attributes.containsKey(ID)) {
            UUID id = this.getId();
            Object idAttributeValue = attributes.get(ID);
            if (idAttributeValue != null && !idAttributeValue.equals(id.toString())) {
                throw new IllegalConfigurationException("Cannot change existing configured object id");
            }
        }
    }

    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
    }

    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
    }

    protected <C extends ConfiguredObject> void authoriseCreateChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) throws AccessControlException {
    }

    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
    }

    protected Map<String, Object> getDefaultAttributes() {
        return this._defaultAttributes;
    }

    protected Map<String, Object> generateEffectiveAttributes(Map<String, Object> changedValues) {
        Map<String, Object> defaultValues = this.getDefaultAttributes();
        Map<String, Object> existingActualValues = this.getActualAttributes();
        HashMap<String, Object> merged = new HashMap<String, Object>(defaultValues);
        for (String name : this.getAttributeNames()) {
            if (changedValues.containsKey(name)) {
                Object changedValue = changedValues.get(name);
                if (changedValue == null) continue;
                merged.put(name, changedValue);
                continue;
            }
            if (existingActualValues.get(name) == null) continue;
            merged.put(name, existingActualValues.get(name));
        }
        return merged;
    }
}

