/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.security.access.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPluginAdapter
extends AbstractAdapter
implements Plugin {
    private Broker _broker;

    protected AbstractPluginAdapter(UUID id, Map<String, Object> defaults, Map<String, Object> attributes, Broker broker) {
        super(id, defaults, attributes, broker.getTaskExecutor());
        this._broker = broker;
        this.addParent(Broker.class, broker);
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new UnsupportedOperationException();
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statistics getStatistics() {
        return null;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("state".equals(name)) {
            return this.getActualState();
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return this.getLifetimePolicy();
        }
        if ("timeToLive".equals(name)) {
            return this.getTimeToLive();
        }
        if ("created".equals(name) || "updated".equals(name)) {
            // empty if block
        }
        return super.getAttribute(name);
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), Plugin.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of plugin is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), Plugin.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of plugin attribute is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), Plugin.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of plugin attributes is denied");
        }
    }

    protected Broker getBroker() {
        return this._broker;
    }
}

