/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.adapter.AccessControlProviderAdapter;
import org.apache.qpid.server.plugin.AccessControlFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.AccessControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlProviderFactory {
    private final Iterable<AccessControlFactory> _factories;
    private Collection<String> _supportedAcessControlProviders;

    public AccessControlProviderFactory(QpidServiceLoader<AccessControlFactory> accessControlFactoryServiceLoader) {
        this._factories = accessControlFactoryServiceLoader.instancesOf(AccessControlFactory.class);
        ArrayList<String> supportedAccessControlProviders = new ArrayList<String>();
        for (AccessControlFactory factory : this._factories) {
            supportedAccessControlProviders.add(factory.getType());
        }
        this._supportedAcessControlProviders = Collections.unmodifiableCollection(supportedAccessControlProviders);
    }

    public AccessControlProvider create(UUID id, Broker broker, Map<String, Object> attributes) {
        AccessControlProvider ac = this.createAccessControlProvider(id, broker, attributes);
        ac.getAccessControl().onCreate();
        return ac;
    }

    public AccessControlProvider recover(UUID id, Broker broker, Map<String, Object> attributes) {
        return this.createAccessControlProvider(id, broker, attributes);
    }

    private AccessControlProvider createAccessControlProvider(UUID id, Broker broker, Map<String, Object> attributes) {
        for (AccessControlFactory factory : this._factories) {
            AccessControl accessControl = factory.createInstance(attributes);
            if (accessControl == null) continue;
            return new AccessControlProviderAdapter(id, broker, accessControl, attributes, factory.getAttributeNames());
        }
        throw new IllegalArgumentException("No access control provider factory found for configuration attributes " + attributes);
    }

    public Collection<String> getSupportedAuthenticationProviders() {
        return this._supportedAcessControlProviders;
    }
}

