/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.BrokerConfigurationStoreCreator;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.AccessControlProviderFactory;
import org.apache.qpid.server.model.adapter.AmqpPortAdapter;
import org.apache.qpid.server.model.adapter.AuthenticationProviderAdapter;
import org.apache.qpid.server.model.adapter.AuthenticationProviderFactory;
import org.apache.qpid.server.model.adapter.GroupProviderFactory;
import org.apache.qpid.server.model.adapter.KeyStoreAdapter;
import org.apache.qpid.server.model.adapter.PortFactory;
import org.apache.qpid.server.model.adapter.StatisticsAdapter;
import org.apache.qpid.server.model.adapter.TrustStoreAdapter;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.manager.SimpleAuthenticationManager;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.MessageStoreCreator;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerAdapter
extends AbstractAdapter
implements Broker,
ConfigurationChangeListener {
    private static final Logger LOGGER = Logger.getLogger(BrokerAdapter.class);
    public static final Map<String, Type> ATTRIBUTE_TYPES = Collections.unmodifiableMap(new HashMap<String, Type>(){
        {
            this.put("queue.alertThresholdMessageAge", Long.class);
            this.put("queue.alertThresholdQueueDepthMessages", Long.class);
            this.put("queue.alertThresholdQueueDepthBytes", Long.class);
            this.put("queue.alertThresholdMessageSize", Long.class);
            this.put("queue.alertRepeatGap", Long.class);
            this.put("queue.flowControlSizeBytes", Long.class);
            this.put("queue.flowResumeSizeBytes", Long.class);
            this.put("virtualhost.housekeepingCheckPeriod", Long.class);
            this.put("queue.deadLetterQueueEnabled", Boolean.class);
            this.put("statisticsReportingResetEnabled", Boolean.class);
            this.put("queue.maximumDeliveryAttempts", Integer.class);
            this.put("connection.sessionCountLimit", Integer.class);
            this.put("connection.heartBeatDelay", Integer.class);
            this.put("statisticsReportingPeriod", Integer.class);
            this.put("name", String.class);
            this.put("defaultVirtualHost", String.class);
            this.put("virtualhost.storeTransactionIdleTimeoutClose", Long.class);
            this.put("virtualhost.storeTransactionIdleTimeoutWarn", Long.class);
            this.put("virtualhost.storeTransactionOpenTimeoutClose", Long.class);
            this.put("virtualhost.storeTransactionOpenTimeoutWarn", Long.class);
            this.put("modelVersion", String.class);
            this.put("storeVersion", String.class);
        }
    });
    public static final int DEFAULT_STATISTICS_REPORTING_PERIOD = 0;
    public static final boolean DEFAULT_STATISTICS_REPORTING_RESET_ENABLED = false;
    public static final long DEFAULT_ALERT_REPEAT_GAP = 30000L;
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_AGE = 0L;
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_COUNT = 0L;
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_SIZE = 0L;
    public static final long DEFAULT_ALERT_THRESHOLD_QUEUE_DEPTH = 0L;
    public static final boolean DEFAULT_DEAD_LETTER_QUEUE_ENABLED = false;
    public static final int DEFAULT_MAXIMUM_DELIVERY_ATTEMPTS = 0;
    public static final long DEFAULT_FLOW_CONTROL_RESUME_SIZE_BYTES = 0L;
    public static final long DEFAULT_FLOW_CONTROL_SIZE_BYTES = 0L;
    public static final long DEFAULT_HOUSEKEEPING_CHECK_PERIOD = 30000L;
    public static final int DEFAULT_HEART_BEAT_DELAY = 0;
    public static final int DEFAULT_SESSION_COUNT_LIMIT = 256;
    public static final String DEFAULT_NAME = "QpidBroker";
    public static final long DEFAULT_STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = 0L;
    public static final long DEFAULT_STORE_TRANSACTION_IDLE_TIMEOUT_WARN = 0L;
    public static final long DEFAULT_STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = 0L;
    public static final long DEFAULT_STORE_TRANSACTION_OPEN_TIMEOUT_WARN = 0L;
    private static final Map<String, Object> DEFAULTS = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put("statisticsReportingPeriod", 0);
            this.put("statisticsReportingResetEnabled", false);
            this.put("queue.alertRepeatGap", 30000L);
            this.put("queue.alertThresholdMessageAge", 0L);
            this.put("queue.alertThresholdQueueDepthMessages", 0L);
            this.put("queue.alertThresholdMessageSize", 0L);
            this.put("queue.alertThresholdQueueDepthBytes", 0L);
            this.put("queue.deadLetterQueueEnabled", false);
            this.put("queue.maximumDeliveryAttempts", 0);
            this.put("queue.flowResumeSizeBytes", 0L);
            this.put("queue.flowControlSizeBytes", 0L);
            this.put("virtualhost.housekeepingCheckPeriod", 30000L);
            this.put("connection.heartBeatDelay", 0);
            this.put("connection.sessionCountLimit", 256);
            this.put("name", BrokerAdapter.DEFAULT_NAME);
            this.put("virtualhost.storeTransactionIdleTimeoutClose", 0L);
            this.put("virtualhost.storeTransactionIdleTimeoutWarn", 0L);
            this.put("virtualhost.storeTransactionOpenTimeoutClose", 0L);
            this.put("virtualhost.storeTransactionOpenTimeoutWarn", 0L);
        }
    });
    private String[] POSITIVE_NUMERIC_ATTRIBUTES = new String[]{"queue.alertThresholdMessageAge", "queue.alertThresholdQueueDepthMessages", "queue.alertThresholdQueueDepthBytes", "queue.alertThresholdMessageSize", "queue.alertRepeatGap", "queue.flowControlSizeBytes", "queue.flowResumeSizeBytes", "queue.maximumDeliveryAttempts", "virtualhost.housekeepingCheckPeriod", "connection.sessionCountLimit", "connection.heartBeatDelay", "statisticsReportingPeriod", "virtualhost.storeTransactionIdleTimeoutClose", "virtualhost.storeTransactionIdleTimeoutWarn", "virtualhost.storeTransactionOpenTimeoutClose", "virtualhost.storeTransactionOpenTimeoutWarn"};
    private final StatisticsGatherer _statisticsGatherer;
    private final VirtualHostRegistry _virtualHostRegistry;
    private final LogRecorder _logRecorder;
    private final RootMessageLogger _rootMessageLogger;
    private StatisticsAdapter _statistics;
    private final Map<String, VirtualHost> _vhostAdapters = new HashMap<String, VirtualHost>();
    private final Map<UUID, Port> _portAdapters = new HashMap<UUID, Port>();
    private final Map<Port, Integer> _stillInUsePortNumbers = new HashMap<Port, Integer>();
    private final Map<UUID, AuthenticationProvider> _authenticationProviders = new HashMap<UUID, AuthenticationProvider>();
    private final Map<String, GroupProvider> _groupProviders = new HashMap<String, GroupProvider>();
    private final Map<UUID, ConfiguredObject> _plugins = new HashMap<UUID, ConfiguredObject>();
    private final Map<String, KeyStore> _keyStores = new HashMap<String, KeyStore>();
    private final Map<String, TrustStore> _trustStores = new HashMap<String, TrustStore>();
    private final Map<UUID, AccessControlProvider> _accessControlProviders = new HashMap<UUID, AccessControlProvider>();
    private final GroupProviderFactory _groupProviderFactory;
    private final AuthenticationProviderFactory _authenticationProviderFactory;
    private final AccessControlProviderFactory _accessControlProviderFactory;
    private final PortFactory _portFactory;
    private final SecurityManager _securityManager;
    private final Collection<String> _supportedVirtualHostStoreTypes;
    private Collection<String> _supportedBrokerStoreTypes;
    private final ConfigurationEntryStore _brokerStore;
    private AuthenticationProvider _managementAuthenticationProvider;
    private BrokerOptions _brokerOptions;

    public BrokerAdapter(UUID id, Map<String, Object> attributes, StatisticsGatherer statisticsGatherer, VirtualHostRegistry virtualHostRegistry, LogRecorder logRecorder, RootMessageLogger rootMessageLogger, AuthenticationProviderFactory authenticationProviderFactory, GroupProviderFactory groupProviderFactory, AccessControlProviderFactory accessControlProviderFactory, PortFactory portFactory, TaskExecutor taskExecutor, ConfigurationEntryStore brokerStore, BrokerOptions brokerOptions) {
        super(id, DEFAULTS, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES), taskExecutor);
        this._statisticsGatherer = statisticsGatherer;
        this._virtualHostRegistry = virtualHostRegistry;
        this._logRecorder = logRecorder;
        this._rootMessageLogger = rootMessageLogger;
        this._statistics = new StatisticsAdapter(statisticsGatherer);
        this._authenticationProviderFactory = authenticationProviderFactory;
        this._groupProviderFactory = groupProviderFactory;
        this._accessControlProviderFactory = accessControlProviderFactory;
        this._portFactory = portFactory;
        this._brokerOptions = brokerOptions;
        this._securityManager = new SecurityManager(this, this._brokerOptions.isManagementMode());
        this._supportedVirtualHostStoreTypes = new MessageStoreCreator().getStoreTypes();
        this._supportedBrokerStoreTypes = new BrokerConfigurationStoreCreator().getStoreTypes();
        this._brokerStore = brokerStore;
        if (this._brokerOptions.isManagementMode()) {
            SimpleAuthenticationManager authManager = new SimpleAuthenticationManager("mm_admin", this._brokerOptions.getManagementModePassword());
            AuthenticationProviderAdapter.SimpleAuthenticationProviderAdapter authenticationProvider = new AuthenticationProviderAdapter.SimpleAuthenticationProviderAdapter(UUID.randomUUID(), (Broker)this, authManager, Collections.<String, Object>emptyMap(), (Collection<String>)Collections.<String>emptySet());
            this._managementAuthenticationProvider = authenticationProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VirtualHost> getVirtualHosts() {
        Map<String, VirtualHost> map = this._vhostAdapters;
        synchronized (map) {
            return new ArrayList<VirtualHost>(this._vhostAdapters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Port> getPorts() {
        Map<UUID, Port> map = this._portAdapters;
        synchronized (map) {
            ArrayList<Port> ports = new ArrayList<Port>(this._portAdapters.values());
            return ports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AuthenticationProvider> getAuthenticationProviders() {
        Map<UUID, AuthenticationProvider> map = this._authenticationProviders;
        synchronized (map) {
            return new ArrayList<AuthenticationProvider>(this._authenticationProviders.values());
        }
    }

    @Override
    public AuthenticationProvider findAuthenticationProviderByName(String authenticationProviderName) {
        if (this.isManagementMode()) {
            return this._managementAuthenticationProvider;
        }
        Collection<AuthenticationProvider> providers = this.getAuthenticationProviders();
        for (AuthenticationProvider authenticationProvider : providers) {
            if (!authenticationProvider.getName().equals(authenticationProviderName)) continue;
            return authenticationProvider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore findKeyStoreByName(String keyStoreName) {
        Map<String, KeyStore> map = this._keyStores;
        synchronized (map) {
            return this._keyStores.get(keyStoreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrustStore findTrustStoreByName(String trustStoreName) {
        Map<String, TrustStore> map = this._trustStores;
        synchronized (map) {
            return this._trustStores.get(trustStoreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GroupProvider> getGroupProviders() {
        Map<String, GroupProvider> map = this._groupProviders;
        synchronized (map) {
            ArrayList<GroupProvider> groupManagers = new ArrayList<GroupProvider>(this._groupProviders.values());
            return groupManagers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualHost createVirtualHost(Map<String, Object> attributes) throws AccessControlException, IllegalArgumentException {
        VirtualHostAdapter virtualHostAdapter = new VirtualHostAdapter(UUID.randomUUID(), attributes, this, this._statisticsGatherer, this.getTaskExecutor());
        this.addVirtualHost(virtualHostAdapter);
        SecurityManager.setAccessChecksDisabled(true);
        try {
            virtualHostAdapter.setDesiredState(State.INITIALISING, State.ACTIVE);
        }
        finally {
            SecurityManager.setAccessChecksDisabled(false);
        }
        return virtualHostAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteVirtualHost(VirtualHost vhost) throws AccessControlException, IllegalStateException {
        Map<String, VirtualHost> map = this._vhostAdapters;
        synchronized (map) {
            this._vhostAdapters.remove(vhost.getName());
        }
        vhost.removeChangeListener(this);
        return true;
    }

    @Override
    public String getName() {
        return (String)this.getAttribute("name");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == VirtualHost.class) {
            return this.getVirtualHosts();
        }
        if (clazz == Port.class) {
            return this.getPorts();
        }
        if (clazz == AccessControlProvider.class) {
            return this.getAccessControlProviders();
        }
        if (clazz == AuthenticationProvider.class) {
            return this.getAuthenticationProviders();
        }
        if (clazz == GroupProvider.class) {
            return this.getGroupProviders();
        }
        if (clazz == KeyStore.class) {
            return this.getKeyStores();
        }
        if (clazz == TrustStore.class) {
            return this.getTrustStores();
        }
        if (clazz == Plugin.class) {
            return this.getPlugins();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == VirtualHost.class) {
            return (C)this.createVirtualHost(attributes);
        }
        if (childClass == Port.class) {
            return (C)this.createPort(attributes);
        }
        if (childClass == AccessControlProvider.class) {
            return (C)this.createAccessControlProvider(attributes);
        }
        if (childClass == AuthenticationProvider.class) {
            return (C)this.createAuthenticationProvider(attributes);
        }
        if (childClass == KeyStore.class) {
            return (C)this.createKeyStore(attributes);
        }
        if (childClass == TrustStore.class) {
            return (C)this.createTrustStore(attributes);
        }
        if (childClass == GroupProvider.class) {
            return (C)this.createGroupProvider(attributes);
        }
        throw new IllegalArgumentException("Cannot create child of class " + childClass.getSimpleName());
    }

    private Port createPort(Map<String, Object> attributes) {
        Port port = this._portFactory.createPort(UUID.randomUUID(), this, attributes);
        this.addPort(port);
        boolean quiesce = this.isManagementMode() || !(port instanceof AmqpPortAdapter) || this.isPreviouslyUsedPortNumber(port);
        port.setDesiredState(State.INITIALISING, quiesce ? State.QUIESCED : State.ACTIVE);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPort(Port port) {
        Map<UUID, Port> map = this._portAdapters;
        synchronized (map) {
            int portNumber = port.getPort();
            String portName = port.getName();
            UUID portId = port.getId();
            for (Port p : this._portAdapters.values()) {
                if (portNumber == p.getPort()) {
                    throw new IllegalConfigurationException("Can't add port " + portName + " because port number " + portNumber + " is already configured for port " + p.getName());
                }
                if (portName == p.getName()) {
                    throw new IllegalConfigurationException("Can't add Port because one with name " + portName + " already exists");
                }
                if (portId != p.getId()) continue;
                throw new IllegalConfigurationException("Can't add Port because one with id " + portId + " already exists");
            }
            this._portAdapters.put(port.getId(), port);
        }
        port.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessControlProvider createAccessControlProvider(Map<String, Object> attributes) {
        AccessControlProvider accessControlProvider = null;
        Map<UUID, AccessControlProvider> map = this._accessControlProviders;
        synchronized (map) {
            accessControlProvider = this._accessControlProviderFactory.create(UUID.randomUUID(), this, attributes);
            this.addAccessControlProvider(accessControlProvider);
        }
        boolean quiesce = this.isManagementMode();
        accessControlProvider.setDesiredState(State.INITIALISING, quiesce ? State.QUIESCED : State.ACTIVE);
        return accessControlProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccessControlProvider(AccessControlProvider accessControlProvider) {
        String name = accessControlProvider.getName();
        Map<UUID, AuthenticationProvider> map = this._authenticationProviders;
        synchronized (map) {
            if (this._accessControlProviders.containsKey(accessControlProvider.getId())) {
                throw new IllegalConfigurationException("Can't add AccessControlProvider because one with id " + accessControlProvider.getId() + " already exists");
            }
            for (AccessControlProvider provider : this._accessControlProviders.values()) {
                if (!provider.getName().equals(name)) continue;
                throw new IllegalConfigurationException("Can't add AccessControlProvider because one with name " + name + " already exists");
            }
            this._accessControlProviders.put(accessControlProvider.getId(), accessControlProvider);
        }
        accessControlProvider.addChangeListener(this);
        accessControlProvider.addChangeListener(this._securityManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteAccessControlProvider(AccessControlProvider accessControlProvider) {
        AccessControlProvider removedAccessControlProvider = null;
        Map<UUID, AccessControlProvider> map = this._accessControlProviders;
        synchronized (map) {
            removedAccessControlProvider = this._accessControlProviders.remove(accessControlProvider.getId());
        }
        if (removedAccessControlProvider != null) {
            removedAccessControlProvider.removeChangeListener(this);
            removedAccessControlProvider.removeChangeListener(this._securityManager);
        }
        return removedAccessControlProvider != null;
    }

    private AuthenticationProvider createAuthenticationProvider(Map<String, Object> attributes) {
        AuthenticationProvider authenticationProvider = this._authenticationProviderFactory.create(UUID.randomUUID(), this, attributes);
        authenticationProvider.setDesiredState(State.INITIALISING, State.ACTIVE);
        this.addAuthenticationProvider(authenticationProvider);
        return authenticationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        String name = authenticationProvider.getName();
        Map<UUID, AuthenticationProvider> map = this._authenticationProviders;
        synchronized (map) {
            if (this._authenticationProviders.containsKey(authenticationProvider.getId())) {
                throw new IllegalConfigurationException("Cannot add AuthenticationProvider because one with id " + authenticationProvider.getId() + " already exists");
            }
            for (AuthenticationProvider provider : this._authenticationProviders.values()) {
                if (!provider.getName().equals(name)) continue;
                throw new IllegalConfigurationException("Cannot add AuthenticationProvider because one with name " + name + " already exists");
            }
            this._authenticationProviders.put(authenticationProvider.getId(), authenticationProvider);
        }
        authenticationProvider.addChangeListener(this);
    }

    private GroupProvider createGroupProvider(Map<String, Object> attributes) {
        GroupProvider groupProvider = this._groupProviderFactory.create(UUID.randomUUID(), this, attributes);
        groupProvider.setDesiredState(State.INITIALISING, State.ACTIVE);
        this.addGroupProvider(groupProvider);
        return groupProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupProvider(GroupProvider groupProvider) {
        Map<String, GroupProvider> map = this._groupProviders;
        synchronized (map) {
            String name = groupProvider.getName();
            if (this._groupProviders.containsKey(name)) {
                throw new IllegalConfigurationException("Cannot add GroupProvider because one with name " + name + " already exists");
            }
            this._groupProviders.put(name, groupProvider);
        }
        groupProvider.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteGroupProvider(GroupProvider groupProvider) {
        GroupProvider removedGroupProvider = null;
        Map<String, GroupProvider> map = this._groupProviders;
        synchronized (map) {
            removedGroupProvider = this._groupProviders.remove(groupProvider.getName());
        }
        if (removedGroupProvider != null) {
            removedGroupProvider.removeChangeListener(this);
        }
        return removedGroupProvider != null;
    }

    private KeyStore createKeyStore(Map<String, Object> attributes) {
        KeyStoreAdapter keyStore = new KeyStoreAdapter(UUIDGenerator.generateRandomUUID(), this, attributes);
        this.addKeyStore(keyStore);
        return keyStore;
    }

    private TrustStore createTrustStore(Map<String, Object> attributes) {
        TrustStoreAdapter trustStore = new TrustStoreAdapter(UUIDGenerator.generateRandomUUID(), this, attributes);
        this.addTrustStore(trustStore);
        return trustStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyStore(KeyStore keyStore) {
        Map<String, KeyStore> map = this._keyStores;
        synchronized (map) {
            if (this._keyStores.containsKey(keyStore.getName())) {
                throw new IllegalConfigurationException("Can't add KeyStore because one with name " + keyStore.getName() + " already exists");
            }
            this._keyStores.put(keyStore.getName(), keyStore);
        }
        keyStore.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteKeyStore(KeyStore object) {
        Map<String, KeyStore> map = this._keyStores;
        synchronized (map) {
            String name = object.getName();
            KeyStore removedKeyStore = this._keyStores.remove(name);
            if (removedKeyStore != null) {
                removedKeyStore.removeChangeListener(this);
            }
            return removedKeyStore != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrustStore(TrustStore trustStore) {
        Map<String, TrustStore> map = this._trustStores;
        synchronized (map) {
            if (this._trustStores.containsKey(trustStore.getName())) {
                throw new IllegalConfigurationException("Can't add TrustStore because one with name " + trustStore.getName() + " already exists");
            }
            this._trustStores.put(trustStore.getName(), trustStore);
        }
        trustStore.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteTrustStore(TrustStore object) {
        Map<String, TrustStore> map = this._trustStores;
        synchronized (map) {
            String name = object.getName();
            TrustStore removedTrustStore = this._trustStores.remove(name);
            if (removedTrustStore != null) {
                removedTrustStore.removeChangeListener(this);
            }
            return removedTrustStore != null;
        }
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("state".equals(name)) {
            return State.ACTIVE;
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return LifetimePolicy.PERMANENT;
        }
        if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name))) {
            if ("buildVersion".equals(name)) {
                return QpidProperties.getBuildVersion();
            }
            if (!"bytesRetained".equals(name)) {
                if ("operatingSystem".equals(name)) {
                    return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
                }
                if ("platform".equals(name)) {
                    return System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"));
                }
                if (!"processPid".equals(name)) {
                    if ("productVersion".equals(name)) {
                        return QpidProperties.getReleaseVersion();
                    }
                    if ("supportedBrokerStoreTypes".equals(name)) {
                        return this._supportedBrokerStoreTypes;
                    }
                    if ("supportedVirtualHostStoreTypes".equals(name)) {
                        return this._supportedVirtualHostStoreTypes;
                    }
                    if ("supportedAuthenticationProviders".equals(name)) {
                        return this._authenticationProviderFactory.getSupportedAuthenticationProviders();
                    }
                    if ("modelVersion".equals(name)) {
                        return "1.0";
                    }
                    if ("storeVersion".equals(name)) {
                        return this._brokerStore.getVersion();
                    }
                    if ("storeType".equals(name)) {
                        return this._brokerStore.getType();
                    }
                    if ("storePath".equals(name)) {
                        return this._brokerStore.getStoreLocation();
                    }
                }
            }
        }
        return super.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePort(State oldState, Port portAdapter) {
        Port removedPort = null;
        Map<UUID, Port> map = this._portAdapters;
        synchronized (map) {
            removedPort = this._portAdapters.remove(portAdapter.getId());
        }
        if (removedPort != null) {
            removedPort.removeChangeListener(this);
            if (oldState == State.ACTIVE) {
                this.recordPreviouslyUsedPortNumberIfNecessary(removedPort, removedPort.getPort());
            }
        }
        return removedPort != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        AuthenticationProvider removedAuthenticationProvider = null;
        Map<UUID, AuthenticationProvider> map = this._authenticationProviders;
        synchronized (map) {
            removedAuthenticationProvider = this._authenticationProviders.remove(authenticationProvider.getId());
        }
        if (removedAuthenticationProvider != null) {
            removedAuthenticationProvider.removeChangeListener(this);
        }
        return removedAuthenticationProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVirtualHost(VirtualHost virtualHost) {
        Map<String, VirtualHost> map = this._vhostAdapters;
        synchronized (map) {
            String name = virtualHost.getName();
            if (this._vhostAdapters.containsKey(name)) {
                throw new IllegalConfigurationException("Virtual host with name " + name + " is already specified!");
            }
            this._vhostAdapters.put(name, virtualHost);
        }
        virtualHost.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setState(State currentState, State desiredState) {
        if (desiredState == State.ACTIVE) {
            this.changeState(this._groupProviders, currentState, State.ACTIVE, false);
            this.changeState(this._authenticationProviders, currentState, State.ACTIVE, false);
            this.changeState(this._accessControlProviders, currentState, State.ACTIVE, false);
            CurrentActor.set(new BrokerActor(this.getRootMessageLogger()));
            try {
                this.changeState(this._vhostAdapters, currentState, State.ACTIVE, false);
            }
            finally {
                CurrentActor.remove();
            }
            this.changeState(this._portAdapters, currentState, State.ACTIVE, false);
            this.changeState(this._plugins, currentState, State.ACTIVE, false);
            if (this.isManagementMode()) {
                CurrentActor.get().message(BrokerMessages.MANAGEMENT_MODE("mm_admin", this._brokerOptions.getManagementModePassword()));
            }
            return true;
        }
        if (desiredState == State.STOPPED) {
            this.changeState(this._plugins, currentState, State.STOPPED, true);
            this.changeState(this._portAdapters, currentState, State.STOPPED, true);
            this.changeState(this._vhostAdapters, currentState, State.STOPPED, true);
            this.changeState(this._authenticationProviders, currentState, State.STOPPED, true);
            this.changeState(this._groupProviders, currentState, State.STOPPED, true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(Map<?, ? extends ConfiguredObject> configuredObjectMap, State currentState, State desiredState, boolean swallowException) {
        Map<?, ConfiguredObject> map = configuredObjectMap;
        synchronized (map) {
            Collection<ConfiguredObject> adapters = configuredObjectMap.values();
            for (ConfiguredObject configuredObject : adapters) {
                if (State.ACTIVE.equals((Object)desiredState) && State.QUIESCED.equals((Object)configuredObject.getActualState())) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)(configuredObject + " cannot be activated as it is " + (Object)((Object)State.QUIESCED)));
                    continue;
                }
                try {
                    configuredObject.setDesiredState(currentState, desiredState);
                }
                catch (RuntimeException e) {
                    if (swallowException) {
                        LOGGER.error((Object)("Failed to stop " + configuredObject), (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    public void stateChanged(ConfiguredObject object, State oldState, State newState) {
        if (newState == State.DELETED) {
            boolean childDeleted = false;
            if (object instanceof AuthenticationProvider) {
                childDeleted = this.deleteAuthenticationProvider((AuthenticationProvider)object);
            } else if (object instanceof AccessControlProvider) {
                childDeleted = this.deleteAccessControlProvider((AccessControlProvider)object);
            } else if (object instanceof Port) {
                childDeleted = this.deletePort(oldState, (Port)object);
            } else if (object instanceof VirtualHost) {
                childDeleted = this.deleteVirtualHost((VirtualHost)object);
            } else if (object instanceof GroupProvider) {
                childDeleted = this.deleteGroupProvider((GroupProvider)object);
            } else if (object instanceof KeyStore) {
                childDeleted = this.deleteKeyStore((KeyStore)object);
            } else if (object instanceof TrustStore) {
                childDeleted = this.deleteTrustStore((TrustStore)object);
            }
            if (childDeleted) {
                this.childRemoved(object);
            }
        }
    }

    @Override
    public void childAdded(ConfiguredObject object, ConfiguredObject child) {
    }

    @Override
    public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
    }

    @Override
    public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        if (object instanceof Port && attributeName == "port" && object.getActualState() == State.ACTIVE) {
            this.recordPreviouslyUsedPortNumberIfNecessary((Port)object, (Integer)oldAttributeValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlugin(ConfiguredObject plugin) {
        Map<UUID, ConfiguredObject> map = this._plugins;
        synchronized (map) {
            if (this._plugins.containsKey(plugin.getId())) {
                throw new IllegalConfigurationException("Plugin with id '" + plugin.getId() + "' is already registered!");
            }
            this._plugins.put(plugin.getId(), plugin);
        }
        plugin.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ConfiguredObject> getPlugins() {
        Map<UUID, ConfiguredObject> map = this._plugins;
        synchronized (map) {
            return Collections.unmodifiableCollection(this._plugins.values());
        }
    }

    public void recoverChild(ConfiguredObject object) {
        if (object instanceof AuthenticationProvider) {
            this.addAuthenticationProvider((AuthenticationProvider)object);
        } else if (object instanceof AccessControlProvider) {
            this.addAccessControlProvider((AccessControlProvider)object);
        } else if (object instanceof Port) {
            this.addPort((Port)object);
        } else if (object instanceof VirtualHost) {
            this.addVirtualHost((VirtualHost)object);
        } else if (object instanceof GroupProvider) {
            this.addGroupProvider((GroupProvider)object);
        } else if (object instanceof KeyStore) {
            this.addKeyStore((KeyStore)object);
        } else if (object instanceof TrustStore) {
            this.addTrustStore((TrustStore)object);
        } else if (object instanceof Plugin) {
            this.addPlugin(object);
        } else {
            throw new IllegalArgumentException("Attempted to recover unexpected type of configured object: " + object.getClass().getName());
        }
    }

    @Override
    public RootMessageLogger getRootMessageLogger() {
        return this._rootMessageLogger;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    @Override
    public LogRecorder getLogRecorder() {
        return this._logRecorder;
    }

    @Override
    public VirtualHost findVirtualHostByName(String name) {
        return this._vhostAdapters.get(name);
    }

    @Override
    public SubjectCreator getSubjectCreator(SocketAddress localAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)localAddress;
        AuthenticationProvider provider = null;
        Collection<Port> ports = this.getPorts();
        for (Port p : ports) {
            if (inetSocketAddress.getPort() != p.getPort()) continue;
            provider = p.getAuthenticationProvider();
            break;
        }
        if (provider == null) {
            throw new IllegalConfigurationException("Unable to determine authentication provider for address: " + localAddress);
        }
        return provider.getSubjectCreator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<KeyStore> getKeyStores() {
        Map<String, KeyStore> map = this._keyStores;
        synchronized (map) {
            return Collections.unmodifiableCollection(this._keyStores.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TrustStore> getTrustStores() {
        Map<String, TrustStore> map = this._trustStores;
        synchronized (map) {
            return Collections.unmodifiableCollection(this._trustStores.values());
        }
    }

    @Override
    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        return super.getTaskExecutor();
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        Map<String, Object> convertedAttributes = MapValueConverter.convert(attributes, ATTRIBUTE_TYPES);
        this.validateAttributes(convertedAttributes);
        super.changeAttributes(convertedAttributes);
    }

    private void validateAttributes(Map<String, Object> convertedAttributes) {
        VirtualHost foundHost;
        if (convertedAttributes.containsKey("modelVersion") && !"1.0".equals(convertedAttributes.get("modelVersion"))) {
            throw new IllegalConfigurationException("Cannot change the model version");
        }
        if (convertedAttributes.containsKey("storeVersion") && !new Integer(this._brokerStore.getVersion()).equals(convertedAttributes.get("storeVersion"))) {
            throw new IllegalConfigurationException("Cannot change the store version");
        }
        String defaultVirtualHost = (String)convertedAttributes.get("defaultVirtualHost");
        if (defaultVirtualHost != null && (foundHost = this.findVirtualHostByName(defaultVirtualHost)) == null) {
            throw new IllegalConfigurationException("Virtual host with name " + defaultVirtualHost + " cannot be set as a default as it does not exist");
        }
        Long queueFlowControlSize = (Long)convertedAttributes.get("queue.flowControlSizeBytes");
        Long queueFlowControlResumeSize = (Long)convertedAttributes.get("queue.flowResumeSizeBytes");
        if (queueFlowControlSize != null || queueFlowControlResumeSize != null) {
            if (queueFlowControlSize == null) {
                queueFlowControlSize = (Long)this.getAttribute("queue.flowControlSizeBytes");
            }
            if (queueFlowControlResumeSize == null) {
                queueFlowControlResumeSize = (Long)this.getAttribute("queue.flowResumeSizeBytes");
            }
            if (queueFlowControlResumeSize > queueFlowControlSize) {
                throw new IllegalConfigurationException("Flow resume size can't be greater than flow control size");
            }
        }
        for (String attributeName : this.POSITIVE_NUMERIC_ATTRIBUTES) {
            Number value = (Number)convertedAttributes.get(attributeName);
            if (value == null || value.longValue() >= 0L) continue;
            throw new IllegalConfigurationException("Only positive integer value can be specified for the attribute " + attributeName);
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._securityManager.authoriseConfiguringBroker(this.getName(), Broker.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of broker attributes is denied");
        }
    }

    @Override
    protected <C extends ConfiguredObject> void authoriseCreateChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) throws AccessControlException {
        if (!this._securityManager.authoriseConfiguringBroker(String.valueOf(attributes.get("name")), childClass, Operation.CREATE)) {
            throw new AccessControlException("Creation of new broker level entity is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._securityManager.authoriseConfiguringBroker(this.getName(), Broker.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of broker attributes is denied");
        }
    }

    @Override
    public boolean isManagementMode() {
        return this._brokerOptions.isManagementMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AccessControlProvider> getAccessControlProviders() {
        Map<UUID, AccessControlProvider> map = this._accessControlProviders;
        synchronized (map) {
            return new ArrayList<AccessControlProvider>(this._accessControlProviders.values());
        }
    }

    private void recordPreviouslyUsedPortNumberIfNecessary(Port port, Integer portNumber) {
        if (!this._stillInUsePortNumbers.containsKey(port)) {
            this._stillInUsePortNumbers.put(port, portNumber);
        }
    }

    private boolean isPreviouslyUsedPortNumber(Port port) {
        return this._stillInUsePortNumbers.containsValue(port.getPort());
    }
}

