/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.BindingAdapter;
import org.apache.qpid.server.model.adapter.QueueAdapter;
import org.apache.qpid.server.model.adapter.VirtualHostAdapter;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExchangeAdapter
extends AbstractAdapter
implements Exchange,
Exchange.BindingListener {
    private final org.apache.qpid.server.exchange.Exchange _exchange;
    private final Map<org.apache.qpid.server.binding.Binding, BindingAdapter> _bindingAdapters = new HashMap<org.apache.qpid.server.binding.Binding, BindingAdapter>();
    private VirtualHostAdapter _vhost;
    private final ExchangeStatistics _statistics = new ExchangeStatistics();

    public ExchangeAdapter(VirtualHostAdapter virtualHostAdapter, org.apache.qpid.server.exchange.Exchange exchange) {
        super(exchange.getId(), virtualHostAdapter.getTaskExecutor());
        this._vhost = virtualHostAdapter;
        this._exchange = exchange;
        this.addParent(VirtualHost.class, virtualHostAdapter);
        exchange.addBindingListener(this);
        this.populateBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateBindings() {
        Collection<org.apache.qpid.server.binding.Binding> actualBindings = this._exchange.getBindings();
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            for (org.apache.qpid.server.binding.Binding binding : actualBindings) {
                if (this._bindingAdapters.containsKey(binding)) continue;
                QueueAdapter queueAdapter = this._vhost.getQueueAdapter(binding.getQueue());
                BindingAdapter adapter = new BindingAdapter(binding, this, queueAdapter);
                this._bindingAdapters.put(binding, adapter);
                queueAdapter.bindingRegistered(binding, adapter);
            }
        }
    }

    @Override
    public String getExchangeType() {
        return this._exchange.getType().getName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Binding> getBindings() {
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            return new ArrayList<Binding>(this._bindingAdapters.values());
        }
    }

    @Override
    public Collection<Publisher> getPublishers() {
        return Collections.emptyList();
    }

    public Binding createBinding(Queue queue, Map<String, Object> attributes) throws AccessControlException, IllegalStateException {
        attributes = new HashMap<String, Object>(attributes);
        String bindingKey = MapValueConverter.getStringAttribute("name", attributes, "");
        Map<String, Object> bindingArgs = MapValueConverter.getMapAttribute("arguments", attributes, Collections.<String, Object>emptyMap());
        attributes.remove("name");
        attributes.remove("arguments");
        return this.createBinding(bindingKey, queue, bindingArgs, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binding createBinding(String bindingKey, Queue queue, Map<String, Object> bindingArguments, Map<String, Object> attributes) throws AccessControlException, IllegalStateException {
        org.apache.qpid.server.virtualhost.VirtualHost virtualHost = this._vhost.getVirtualHost();
        AMQQueue amqQueue = ((QueueAdapter)queue).getAMQQueue();
        try {
            org.apache.qpid.server.binding.Binding oldBinding;
            Map<String, Object> oldArgs;
            if (!virtualHost.getBindingFactory().addBinding(bindingKey, amqQueue, this._exchange, bindingArguments) && ((oldArgs = (oldBinding = virtualHost.getBindingFactory().getBinding(bindingKey, amqQueue, this._exchange, bindingArguments)).getArguments()) == null && !bindingArguments.isEmpty() || oldArgs != null && !((Object)oldArgs).equals(bindingArguments))) {
                virtualHost.getBindingFactory().replaceBinding(oldBinding.getId(), bindingKey, amqQueue, this._exchange, bindingArguments);
            }
            org.apache.qpid.server.binding.Binding binding = virtualHost.getBindingFactory().getBinding(bindingKey, amqQueue, this._exchange, bindingArguments);
            Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
            synchronized (map) {
                return binding == null ? null : this._bindingAdapters.get(binding);
            }
        }
        catch (AMQSecurityException e) {
            throw new AccessControlException(e.toString());
        }
        catch (AMQInternalException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        try {
            ExchangeRegistry exchangeRegistry = this._vhost.getVirtualHost().getExchangeRegistry();
            if (exchangeRegistry.isReservedExchangeName(this.getName())) {
                throw new UnsupportedOperationException("'" + this.getName() + "' is a reserved exchange and can't be deleted");
            }
            if (this._exchange.hasReferrers()) {
                throw new AMQException(AMQConstant.NOT_ALLOWED, "Exchange in use as an alternate exchange", null);
            }
            ExchangeRegistry exchangeRegistry2 = exchangeRegistry;
            synchronized (exchangeRegistry2) {
                exchangeRegistry.unregisterExchange(this.getName(), false);
            }
        }
        catch (AMQException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getName() {
        return this._exchange.getName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return this._exchange.isDurable();
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return this._exchange.isAutoDelete() ? LifetimePolicy.AUTO_DELETE : LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Binding.class) {
            return this.getBindings();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Binding.class) {
            if (otherParents != null && otherParents.length == 1 && otherParents[0] instanceof Queue) {
                Queue queue = (Queue)otherParents[0];
                if (queue.getParent(VirtualHost.class) == this.getParent(VirtualHost.class)) {
                    return (C)this.createBinding(queue, attributes);
                }
                throw new IllegalArgumentException("Queue and Exchange parents of a binding must be on same virtual host");
            }
            throw new IllegalArgumentException("Other parent must be a queue");
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindingAdded(org.apache.qpid.server.exchange.Exchange exchange, org.apache.qpid.server.binding.Binding binding) {
        BindingAdapter adapter = null;
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            if (!this._bindingAdapters.containsKey(binding)) {
                QueueAdapter queueAdapter = this._vhost.getQueueAdapter(binding.getQueue());
                adapter = new BindingAdapter(binding, this, queueAdapter);
                this._bindingAdapters.put(binding, adapter);
                queueAdapter.bindingRegistered(binding, adapter);
            }
        }
        if (adapter != null) {
            this.childAdded(adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindingRemoved(org.apache.qpid.server.exchange.Exchange exchange, org.apache.qpid.server.binding.Binding binding) {
        BindingAdapter adapter = null;
        Map<org.apache.qpid.server.binding.Binding, BindingAdapter> map = this._bindingAdapters;
        synchronized (map) {
            adapter = this._bindingAdapters.remove(binding);
        }
        if (adapter != null) {
            this._vhost.getQueueAdapter(binding.getQueue()).bindingUnregistered(binding);
            this.childRemoved(adapter);
        }
    }

    org.apache.qpid.server.exchange.Exchange getExchange() {
        return this._exchange;
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("state".equals(name)) {
            return State.ACTIVE;
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return this._exchange.isAutoDelete() ? LifetimePolicy.AUTO_DELETE : LifetimePolicy.PERMANENT;
        }
        if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name))) {
            if ("alternateExchange".equals(name)) {
                return this._exchange.getAlternateExchange();
            }
            if ("type".equals(name)) {
                return this._exchange.getType().getName().asString();
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    protected boolean setState(State currentState, State desiredState) {
        if (desiredState == State.DELETED) {
            this.delete();
            return true;
        }
        return false;
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        throw new UnsupportedOperationException("Changing attributes on exchange is not supported.");
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._vhost.getSecurityManager().authoriseUpdate(this._exchange)) {
            throw new AccessControlException("Setting of exchange attribute is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._vhost.getSecurityManager().authoriseUpdate(this._exchange)) {
            throw new AccessControlException("Setting of exchange attributes is denied");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExchangeStatistics
    implements Statistics {
        private ExchangeStatistics() {
        }

        @Override
        public Collection<String> getStatisticNames() {
            return Exchange.AVAILABLE_STATISTICS;
        }

        @Override
        public Object getStatistic(String name) {
            if ("bindingCount".equals(name)) {
                return ExchangeAdapter.this._exchange.getBindingCount();
            }
            if ("bytesDropped".equals(name)) {
                return ExchangeAdapter.this._exchange.getByteDrops();
            }
            if ("bytesIn".equals(name)) {
                return ExchangeAdapter.this._exchange.getByteReceives();
            }
            if ("messagesDropped".equals(name)) {
                return ExchangeAdapter.this._exchange.getMsgDrops();
            }
            if ("messagesIn".equals(name)) {
                return ExchangeAdapter.this._exchange.getMsgReceives();
            }
            if ("producerCount".equals(name) || "stateChanged".equals(name)) {
                // empty if block
            }
            return null;
        }
    }
}

