/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.group.GroupManager;
import org.apache.qpid.server.util.MapValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupProviderAdapter
extends AbstractAdapter
implements GroupProvider {
    private static Logger LOGGER = Logger.getLogger(GroupProviderAdapter.class);
    private final GroupManager _groupManager;
    private final Broker _broker;
    private Collection<String> _supportedAttributes;
    private AtomicReference<State> _state;

    public GroupProviderAdapter(UUID id, Broker broker, GroupManager groupManager, Map<String, Object> attributes, Collection<String> attributeNames) {
        super(id, null, null, broker.getTaskExecutor());
        if (groupManager == null) {
            throw new IllegalArgumentException("GroupManager must not be null");
        }
        this._groupManager = groupManager;
        this._broker = broker;
        this._supportedAttributes = this.createSupportedAttributes(attributeNames);
        State state = MapValueConverter.getEnumAttribute(State.class, "state", attributes, State.INITIALISING);
        this._state = new AtomicReference<State>(state);
        this.addParent(Broker.class, broker);
        if (attributes != null) {
            for (String name : this._supportedAttributes) {
                if (!attributes.containsKey(name)) continue;
                this.changeAttribute(name, null, attributes.get(name));
            }
        }
    }

    protected Collection<String> createSupportedAttributes(Collection<String> factoryAttributes) {
        ArrayList<String> attributesNames = new ArrayList<String>(AVAILABLE_ATTRIBUTES);
        if (factoryAttributes != null) {
            attributesNames.addAll(factoryAttributes);
        }
        return Collections.unmodifiableCollection(attributesNames);
    }

    @Override
    public String getName() {
        return (String)this.getAttribute("name");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return this._state.get();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return this._supportedAttributes;
    }

    @Override
    public Object getAttribute(String name) {
        if (!"created".equals(name)) {
            if ("durable".equals(name)) {
                return true;
            }
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("lifetimePolicy".equals(name)) {
                return LifetimePolicy.PERMANENT;
            }
            if ("state".equals(name)) {
                return this.getActualState();
            }
            if ("timeToLive".equals(name) || "updated".equals(name)) {
                // empty if block
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Group.class) {
            String groupName = (String)attributes.get("name");
            if (this.getSecurityManager().authoriseGroupOperation(Operation.CREATE, groupName)) {
                this._groupManager.createGroup(groupName);
                return (C)new GroupAdapter(groupName, this.getTaskExecutor());
            }
            throw new AccessControlException("Do not have permission to create new group");
        }
        throw new IllegalArgumentException("This group provider does not support creating children of type: " + childClass);
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Group.class) {
            Set<Principal> groups = this._groupManager.getGroupPrincipals();
            ArrayList<GroupAdapter> principals = new ArrayList<GroupAdapter>(groups.size());
            for (Principal group : groups) {
                principals.add(new GroupAdapter(group.getName(), this.getTaskExecutor()));
            }
            return Collections.unmodifiableCollection(principals);
        }
        return null;
    }

    public GroupManager getGroupManager() {
        return this._groupManager;
    }

    private SecurityManager getSecurityManager() {
        return this._broker.getSecurityManager();
    }

    @Override
    protected boolean setState(State currentState, State desiredState) {
        block10: {
            State state = this._state.get();
            if (desiredState == State.ACTIVE) {
                if ((state == State.INITIALISING || state == State.QUIESCED || state == State.STOPPED) && this._state.compareAndSet(state, State.ACTIVE)) {
                    try {
                        this._groupManager.open();
                        return true;
                    }
                    catch (RuntimeException e) {
                        this._state.compareAndSet(State.ACTIVE, State.ERRORED);
                        if (this._broker.isManagementMode()) {
                            LOGGER.warn((Object)("Failed to activate group provider: " + this.getName()), (Throwable)e);
                            break block10;
                        }
                        throw e;
                    }
                }
                throw new IllegalStateException("Cannot activate group provider in state: " + (Object)((Object)state));
            }
            if (desiredState == State.STOPPED) {
                if (this._state.compareAndSet(state, State.STOPPED)) {
                    this._groupManager.close();
                    return true;
                }
                throw new IllegalStateException("Cannot stop group provider in state: " + (Object)((Object)state));
            }
            if (desiredState == State.DELETED) {
                if ((state == State.INITIALISING || state == State.ACTIVE || state == State.STOPPED || state == State.QUIESCED || state == State.ERRORED) && this._state.compareAndSet(state, State.DELETED)) {
                    this._groupManager.close();
                    this._groupManager.onDelete();
                    return true;
                }
                throw new IllegalStateException("Cannot delete group provider in state: " + (Object)((Object)state));
            }
            if (desiredState == State.QUIESCED && state == State.INITIALISING && this._state.compareAndSet(state, State.QUIESCED)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Principal> getGroupPrincipalsForUser(String username) {
        return this._groupManager.getGroupPrincipalsForUser(username);
    }

    @Override
    protected void childAdded(ConfiguredObject child) {
    }

    @Override
    protected void childRemoved(ConfiguredObject child) {
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), GroupProvider.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of groups provider is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), GroupProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of group provider attributes is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), GroupProvider.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of group provider attributes is denied");
        }
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        throw new UnsupportedOperationException("Changing attributes on group providers is not supported.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupAdapter
    extends AbstractAdapter
    implements Group {
        private final String _group;

        public GroupAdapter(String group, TaskExecutor taskExecutor) {
            super(UUIDGenerator.generateGroupUUID(GroupProviderAdapter.this.getName(), group), taskExecutor);
            this._group = group;
        }

        @Override
        public String getName() {
            return this._group;
        }

        @Override
        public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
            throw new IllegalStateException("Names cannot be updated");
        }

        @Override
        public State getActualState() {
            return State.ACTIVE;
        }

        @Override
        public boolean isDurable() {
            return true;
        }

        @Override
        public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new IllegalStateException("Durability cannot be updated");
        }

        @Override
        public LifetimePolicy getLifetimePolicy() {
            return LifetimePolicy.PERMANENT;
        }

        @Override
        public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new IllegalStateException("LifetimePolicy cannot be updated");
        }

        @Override
        public long getTimeToLive() {
            return 0L;
        }

        @Override
        public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new IllegalStateException("ttl cannot be updated");
        }

        @Override
        public Statistics getStatistics() {
            return NoStatistics.getInstance();
        }

        @Override
        public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
            if (clazz == GroupMember.class) {
                Set<Principal> usersInGroup = GroupProviderAdapter.this._groupManager.getUserPrincipalsForGroup(this._group);
                ArrayList<GroupMemberAdapter> members = new ArrayList<GroupMemberAdapter>();
                for (Principal principal : usersInGroup) {
                    members.add(new GroupMemberAdapter(principal.getName(), this.getTaskExecutor()));
                }
                return Collections.unmodifiableCollection(members);
            }
            return null;
        }

        @Override
        public <C extends ConfiguredObject> C addChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
            if (childClass == GroupMember.class) {
                String memberName = (String)attributes.get("name");
                if (GroupProviderAdapter.this.getSecurityManager().authoriseGroupOperation(Operation.UPDATE, this._group)) {
                    GroupProviderAdapter.this._groupManager.addUserToGroup(memberName, this._group);
                    return (C)new GroupMemberAdapter(memberName, this.getTaskExecutor());
                }
                throw new AccessControlException("Do not have permission to add new group member");
            }
            throw new IllegalArgumentException("This group provider does not support creating children of type: " + childClass);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return Group.AVAILABLE_ATTRIBUTES;
        }

        @Override
        public Object getAttribute(String name) {
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("name".equals(name)) {
                return this.getName();
            }
            return super.getAttribute(name);
        }

        @Override
        protected boolean setState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
            if (desiredState == State.DELETED) {
                if (GroupProviderAdapter.this.getSecurityManager().authoriseGroupOperation(Operation.DELETE, this._group)) {
                    GroupProviderAdapter.this._groupManager.removeGroup(this._group);
                    return true;
                }
                throw new AccessControlException("Do not have permission to delete group");
            }
            return false;
        }

        @Override
        public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new UnsupportedOperationException("Changing attributes on group is not supported.");
        }

        @Override
        public void setAttributes(Map<String, Object> attributes) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new UnsupportedOperationException("Changing attributes on group is not supported.");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GroupMemberAdapter
        extends AbstractAdapter
        implements GroupMember {
            private String _memberName;

            public GroupMemberAdapter(String memberName, TaskExecutor taskExecutor) {
                super(UUIDGenerator.generateGroupMemberUUID(GroupProviderAdapter.this.getName(), GroupAdapter.this._group, memberName), taskExecutor);
                this._memberName = memberName;
            }

            @Override
            public Collection<String> getAttributeNames() {
                return GroupMember.AVAILABLE_ATTRIBUTES;
            }

            @Override
            public Object getAttribute(String name) {
                if ("id".equals(name)) {
                    return this.getId();
                }
                if ("name".equals(name)) {
                    return this.getName();
                }
                return super.getAttribute(name);
            }

            @Override
            public String getName() {
                return this._memberName;
            }

            @Override
            public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
                return null;
            }

            @Override
            public State getActualState() {
                return null;
            }

            @Override
            public boolean isDurable() {
                return false;
            }

            @Override
            public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            }

            @Override
            public LifetimePolicy getLifetimePolicy() {
                return null;
            }

            @Override
            public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                return null;
            }

            @Override
            public long getTimeToLive() {
                return 0L;
            }

            @Override
            public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                return 0L;
            }

            @Override
            public Statistics getStatistics() {
                return NoStatistics.getInstance();
            }

            @Override
            public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
                return null;
            }

            @Override
            public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
                return null;
            }

            @Override
            protected boolean setState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
                if (desiredState == State.DELETED) {
                    if (GroupProviderAdapter.this.getSecurityManager().authoriseGroupOperation(Operation.UPDATE, GroupAdapter.this._group)) {
                        GroupProviderAdapter.this._groupManager.removeUserFromGroup(this._memberName, GroupAdapter.this._group);
                        return true;
                    }
                    throw new AccessControlException("Do not have permission to remove group member");
                }
                return false;
            }

            @Override
            public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new UnsupportedOperationException("Changing attributes on group member is not supported.");
            }

            @Override
            public void setAttributes(Map<String, Object> attributes) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                throw new UnsupportedOperationException("Changing attributes on group member is not supported.");
            }
        }
    }
}

