/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.adapter.AbstractKeyStoreAdapter;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreAdapter
extends AbstractKeyStoreAdapter
implements KeyStore {
    public static final Map<String, Type> ATTRIBUTE_TYPES = Collections.unmodifiableMap(new HashMap<String, Type>(){
        {
            this.put("name", String.class);
            this.put("path", String.class);
            this.put("password", String.class);
            this.put("type", String.class);
            this.put("certificateAlias", String.class);
            this.put("keyManagerFactoryAlgorithm", String.class);
        }
    });
    public static final Map<String, Object> DEFAULTS = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put("type", AbstractKeyStoreAdapter.DEFAULT_KEYSTORE_TYPE);
            this.put("keyManagerFactoryAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
        }
    });
    private Broker _broker;

    public KeyStoreAdapter(UUID id, Broker broker, Map<String, Object> attributes) {
        super(id, broker, DEFAULTS, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES));
        this._broker = broker;
        String keyStorePath = (String)this.getAttribute("path");
        String keyStorePassword = this.getPassword();
        String keyStoreType = (String)this.getAttribute("type");
        String keyManagerFactoryAlgorithm = (String)this.getAttribute("keyManagerFactoryAlgorithm");
        String certAlias = (String)this.getAttribute("certificateAlias");
        this.validateKeyStoreAttributes(keyStoreType, keyStorePath, keyStorePassword, certAlias, keyManagerFactoryAlgorithm);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    protected boolean setState(State currentState, State desiredState) {
        if (desiredState == State.DELETED) {
            String storeName = this.getName();
            ArrayList<Port> ports = new ArrayList<Port>(this._broker.getPorts());
            for (Port port : ports) {
                if (!storeName.equals(port.getAttribute("keyStore"))) continue;
                throw new IntegrityViolationException("Key store '" + storeName + "' can't be deleted as it is in use by a port:" + port.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), KeyStore.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of key store is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        this.authoriseSetAttribute();
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        this.authoriseSetAttribute();
    }

    private void authoriseSetAttribute() {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), KeyStore.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting key store attributes is denied");
        }
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        Map<String, Object> changedValues = MapValueConverter.convert(attributes, ATTRIBUTE_TYPES);
        if (changedValues.containsKey("name")) {
            String newName = (String)changedValues.get("name");
            if (!this.getName().equals(newName)) {
                throw new IllegalConfigurationException("Changing the key store name is not allowed");
            }
        }
        Map<String, Object> merged = this.generateEffectiveAttributes(changedValues);
        String keyStorePath = (String)merged.get("path");
        String keyStorePassword = (String)merged.get("password");
        String keyStoreType = (String)merged.get("type");
        String keyManagerFactoryAlgorithm = (String)merged.get("keyManagerFactoryAlgorithm");
        String certAlias = (String)merged.get("certificateAlias");
        this.validateKeyStoreAttributes(keyStoreType, keyStorePath, keyStorePassword, certAlias, keyManagerFactoryAlgorithm);
        super.changeAttributes(changedValues);
    }

    private void validateKeyStoreAttributes(String type, String keyStorePath, String keyStorePassword, String alias, String keyManagerFactoryAlgorithm) {
        java.security.KeyStore keyStore = null;
        try {
            keyStore = SSLUtil.getInitializedKeyStore((String)keyStorePath, (String)keyStorePassword, (String)type);
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Cannot instantiate key store at " + keyStorePath, e);
        }
        if (alias != null) {
            Certificate cert = null;
            try {
                cert = keyStore.getCertificate(alias);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Key store has not been initialized", e);
            }
            if (cert == null) {
                throw new IllegalConfigurationException("Cannot find a certificate with alias " + alias + "in key store : " + keyStorePath);
            }
        }
        try {
            KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Unknown keyManagerFactoryAlgorithm: " + keyManagerFactoryAlgorithm);
        }
    }
}

