/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.util.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortAdapter
extends AbstractAdapter
implements Port {
    public static final Map<String, Type> ATTRIBUTE_TYPES = Collections.unmodifiableMap(new HashMap<String, Type>(){
        {
            this.put("name", String.class);
            this.put("protocols", new ParameterizedTypeImpl(Set.class, Protocol.class));
            this.put("transports", new ParameterizedTypeImpl(Set.class, Transport.class));
            this.put("trustStores", new ParameterizedTypeImpl(Set.class, String.class));
            this.put("keyStore", String.class);
            this.put("port", Integer.class);
            this.put("tcpNoDelay", Boolean.class);
            this.put("receiveBufferSize", Integer.class);
            this.put("sendBufferSize", Integer.class);
            this.put("needClientAuth", Boolean.class);
            this.put("wantClientAuth", Boolean.class);
            this.put("bindingAddress", String.class);
            this.put("state", State.class);
            this.put("authenticationProvider", String.class);
        }
    });
    private final Broker _broker;
    private AuthenticationProvider _authenticationProvider;
    private AtomicReference<State> _state;

    public PortAdapter(UUID id, Broker broker, Map<String, Object> attributes, Map<String, Object> defaults, TaskExecutor taskExecutor) {
        super(id, defaults, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES), taskExecutor);
        boolean rmiRegistry;
        this._broker = broker;
        State state = MapValueConverter.getEnumAttribute(State.class, "state", attributes, State.INITIALISING);
        Collection<Protocol> protocols = this.getProtocols();
        boolean bl = rmiRegistry = protocols != null && protocols.contains((Object)Protocol.RMI);
        if (!rmiRegistry) {
            String authProvider = (String)this.getAttribute("authenticationProvider");
            if (authProvider == null) {
                throw new IllegalConfigurationException("An authentication provider must be specified for port : " + this.getName());
            }
            this._authenticationProvider = broker.findAuthenticationProviderByName(authProvider);
            if (this._authenticationProvider == null) {
                throw new IllegalConfigurationException("The authentication provider '" + authProvider + "' could not be found for port : " + this.getName());
            }
        }
        this._state = new AtomicReference<State>(state);
        this.addParent(Broker.class, broker);
    }

    @Override
    public String getBindingAddress() {
        return (String)this.getAttribute("bindingAddress");
    }

    @Override
    public int getPort() {
        return (Integer)this.getAttribute("port");
    }

    @Override
    public Collection<Transport> getTransports() {
        return (Collection)this.getAttribute("transports");
    }

    @Override
    public void addTransport(Transport transport) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Transport removeTransport(Transport transport) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Collection<Protocol> getProtocols() {
        return (Collection)this.getAttribute("protocols");
    }

    @Override
    public void addProtocol(Protocol protocol) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Protocol removeProtocol(Protocol protocol) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Collection<VirtualHostAlias> getVirtualHostBindings() {
        ArrayList<VirtualHostAlias> aliases = new ArrayList<VirtualHostAlias>();
        for (VirtualHost vh : this._broker.getVirtualHosts()) {
            for (VirtualHostAlias alias : vh.getAliases()) {
                if (!alias.getPort().equals(this)) continue;
                aliases.add(alias);
            }
        }
        return Collections.unmodifiableCollection(aliases);
    }

    @Override
    public Collection<Connection> getConnections() {
        return null;
    }

    @Override
    public String getName() {
        return (String)this.getAttribute("name");
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public State getActualState() {
        return this._state.get();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Connection.class) {
            return this.getConnections();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("state".equals(name)) {
            return this.getActualState();
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return this.getLifetimePolicy();
        }
        if ("timeToLive".equals(name)) {
            return this.getTimeToLive();
        }
        if ("created".equals(name) || "updated".equals(name)) {
            // empty if block
        }
        return super.getAttribute(name);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    public boolean setState(State currentState, State desiredState) {
        State state = this._state.get();
        if (desiredState == State.DELETED) {
            if (state == State.INITIALISING || state == State.ACTIVE || state == State.STOPPED || state == State.QUIESCED || state == State.ERRORED) {
                return this._state.compareAndSet(state, State.DELETED);
            }
            throw new IllegalStateException("Cannot delete port in " + (Object)((Object)state) + " state");
        }
        if (desiredState == State.ACTIVE) {
            if ((state == State.INITIALISING || state == State.QUIESCED) && this._state.compareAndSet(state, State.ACTIVE)) {
                try {
                    this.onActivate();
                }
                catch (RuntimeException e) {
                    this._state.compareAndSet(State.ACTIVE, State.ERRORED);
                    throw e;
                }
                return true;
            }
            throw new IllegalStateException("Cannot activate port in " + (Object)((Object)state) + " state");
        }
        if (desiredState == State.QUIESCED) {
            if (state == State.INITIALISING && this._state.compareAndSet(state, State.QUIESCED)) {
                return true;
            }
        } else if (desiredState == State.STOPPED) {
            if (this._state.compareAndSet(state, State.STOPPED)) {
                this.onStop();
                return true;
            }
            throw new IllegalStateException("Cannot stop port in " + (Object)((Object)state) + " state");
        }
        return false;
    }

    protected void onActivate() {
    }

    protected void onStop() {
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        return this._authenticationProvider;
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        boolean usesSsl;
        boolean hasTrustStore;
        Map<String, Object> converted = MapValueConverter.convert(attributes, ATTRIBUTE_TYPES);
        Map<String, Object> merged = this.generateEffectiveAttributes(converted);
        String newName = (String)merged.get("name");
        if (!this.getName().equals(newName)) {
            throw new IllegalConfigurationException("Changing the port name is not allowed");
        }
        Integer newPort = (Integer)merged.get("port");
        if (this.getPort() != newPort.intValue()) {
            for (Port p : this._broker.getPorts()) {
                if (p.getPort() != newPort.intValue()) continue;
                throw new IllegalConfigurationException("Port number " + newPort + " is already in use by port " + p.getName());
            }
        }
        Collection transports = (Collection)merged.get("transports");
        Collection protocols = (Collection)merged.get("protocols");
        Boolean needClientCertificate = (Boolean)merged.get("needClientAuth");
        Boolean wantClientCertificate = (Boolean)merged.get("wantClientAuth");
        boolean requiresCertificate = needClientCertificate != null && needClientCertificate != false || wantClientCertificate != null && wantClientCertificate != false;
        String keyStoreName = (String)merged.get("keyStore");
        if (keyStoreName != null && this._broker.findKeyStoreByName(keyStoreName) == null) {
            throw new IllegalConfigurationException("Can't find key store with name '" + keyStoreName + "' for port " + this.getName());
        }
        Set trustStoreNames = (Set)merged.get("trustStores");
        boolean bl = hasTrustStore = trustStoreNames != null && !trustStoreNames.isEmpty();
        if (hasTrustStore) {
            for (String trustStoreName : trustStoreNames) {
                if (this._broker.findTrustStoreByName(trustStoreName) != null) continue;
                throw new IllegalConfigurationException("Cannot find trust store with name '" + trustStoreName + "'");
            }
        }
        boolean bl2 = usesSsl = transports != null && transports.contains((Object)Transport.SSL);
        if (usesSsl) {
            if (keyStoreName == null) {
                throw new IllegalConfigurationException("Can't create port which requires SSL but has no key store configured.");
            }
            if (!hasTrustStore && requiresCertificate) {
                throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but has no trust store configured.");
            }
        } else if (requiresCertificate) {
            throw new IllegalConfigurationException("Can't create port which requests SSL client certificates but doesn't use SSL transport.");
        }
        if (protocols != null && protocols.contains((Object)Protocol.RMI) && usesSsl) {
            throw new IllegalConfigurationException("Can't create RMI Registry port which requires SSL.");
        }
        String authenticationProviderName = (String)merged.get("authenticationProvider");
        if (authenticationProviderName != null) {
            Collection<AuthenticationProvider> providers = this._broker.getAuthenticationProviders();
            AuthenticationProvider provider = null;
            for (AuthenticationProvider p : providers) {
                if (!p.getName().equals(authenticationProviderName)) continue;
                provider = p;
                break;
            }
            if (provider == null) {
                throw new IllegalConfigurationException("Cannot find authentication provider with name '" + authenticationProviderName + "'");
            }
        } else if (protocols != null && !protocols.contains((Object)Protocol.RMI)) {
            throw new IllegalConfigurationException("An authentication provider must be specified");
        }
        super.changeAttributes(converted);
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), Port.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of port is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), Port.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of port attributes is denied");
        }
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), Port.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting of port attributes is denied");
        }
    }

    @Override
    public KeyStore getKeyStore() {
        String keyStoreName = (String)this.getAttribute("keyStore");
        KeyStore keyStore = this._broker.findKeyStoreByName(keyStoreName);
        if (keyStoreName != null && keyStore == null) {
            throw new IllegalConfigurationException("Can't find key store with name '" + keyStoreName + "' for port " + this.getName());
        }
        return keyStore;
    }

    @Override
    public Collection<TrustStore> getTrustStores() {
        Set trustStoreNames = (Set)this.getAttribute("trustStores");
        boolean hasTrustStoreName = trustStoreNames != null && !trustStoreNames.isEmpty();
        ArrayList<TrustStore> trustStores = new ArrayList<TrustStore>();
        if (hasTrustStoreName) {
            for (String name : trustStoreNames) {
                TrustStore trustStore = this._broker.findTrustStoreByName(name);
                if (trustStore == null) {
                    throw new IllegalConfigurationException("Can't find trust store with name '" + name + "' for port " + this.getName());
                }
                trustStores.add(trustStore);
            }
        }
        return trustStores;
    }
}

