/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Publisher;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.ConsumerAdapter;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.subscription.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SessionAdapter
extends AbstractAdapter
implements Session {
    private AMQSessionModel _session;
    private SessionStatistics _statistics;
    private Map<Subscription, ConsumerAdapter> _consumerAdapters = new HashMap<Subscription, ConsumerAdapter>();

    public SessionAdapter(AMQSessionModel session, TaskExecutor taskExecutor) {
        super(UUIDGenerator.generateRandomUUID(), taskExecutor);
        this._session = session;
        this._statistics = new SessionStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Consumer> getSubscriptions() {
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            return new ArrayList<Consumer>(this._consumerAdapters.values());
        }
    }

    @Override
    public Collection<Publisher> getPublishers() {
        return null;
    }

    @Override
    public String getName() {
        return String.valueOf(this._session.getChannelId());
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return null;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscriptionRegistered(Subscription subscription, ConsumerAdapter adapter) {
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            this._consumerAdapters.put(subscription, adapter);
        }
        this.childAdded(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscriptionUnregistered(Subscription subscription) {
        ConsumerAdapter adapter = null;
        Map<Subscription, ConsumerAdapter> map = this._consumerAdapters;
        synchronized (map) {
            adapter = this._consumerAdapters.remove(subscription);
        }
        if (adapter != null) {
            this.childRemoved(adapter);
        }
    }

    @Override
    public Collection<String> getAttributeNames() {
        HashSet<String> names = new HashSet<String>(super.getAttributeNames());
        names.addAll(AVAILABLE_ATTRIBUTES);
        return Collections.unmodifiableCollection(names);
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("id")) {
            return this.getId();
        }
        if (name.equals("name")) {
            return this.getName();
        }
        if (name.equals("channelId")) {
            return this._session.getChannelId();
        }
        if (name.equals("producerFlowBlocked")) {
            return this._session.getBlocking();
        }
        return super.getAttribute(name);
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Consumer.class) {
            return this.getSubscriptions();
        }
        if (clazz == Publisher.class) {
            return this.getPublishers();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean setState(State currentState, State desiredState) {
        return false;
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new UnsupportedOperationException("Changing attributes on session is not supported.");
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new UnsupportedOperationException("Changing attributes on session is not supported.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionStatistics
    implements Statistics {
        @Override
        public Collection<String> getStatisticNames() {
            return Session.AVAILABLE_STATISTICS;
        }

        @Override
        public Object getStatistic(String name) {
            if (!name.equals("bytesIn") && !name.equals("bytesOut")) {
                if (name.equals("consumerCount")) {
                    return SessionAdapter.this._session.getConsumerCount();
                }
                if (name.equals("localTransactionBegins")) {
                    return SessionAdapter.this._session.getTxnStart();
                }
                if (name.equals("localTransactionOpen")) {
                    long open = SessionAdapter.this._session.getTxnStart() - (SessionAdapter.this._session.getTxnCommits() + SessionAdapter.this._session.getTxnRejects());
                    return open > 0L;
                }
                if (name.equals("localTransactionRollbacks")) {
                    return SessionAdapter.this._session.getTxnRejects();
                }
                if (!name.equals("stateChanged") && !name.equals("unacknowledgedBytes")) {
                    if (name.equals("unacknowledgedMessages")) {
                        return SessionAdapter.this._session.getUnacknowledgedMessageCount();
                    }
                    if (name.equals("xaTransactionBranchEnds") || name.equals("xaTransactionBranchStarts") || name.equals("xaTransactionBranchSuspends")) {
                        // empty if block
                    }
                }
            }
            return null;
        }
    }
}

