/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.TrustManagerFactory;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.adapter.AbstractKeyStoreAdapter;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustStoreAdapter
extends AbstractKeyStoreAdapter
implements TrustStore {
    public static final Map<String, Type> ATTRIBUTE_TYPES = Collections.unmodifiableMap(new HashMap<String, Type>(){
        {
            this.put("name", String.class);
            this.put("path", String.class);
            this.put("password", String.class);
            this.put("type", String.class);
            this.put("peersOnly", Boolean.class);
            this.put("trustManagerFactoryAlgorithm", String.class);
        }
    });
    public static final Map<String, Object> DEFAULTS = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put("type", AbstractKeyStoreAdapter.DEFAULT_KEYSTORE_TYPE);
            this.put("peersOnly", Boolean.FALSE);
            this.put("trustManagerFactoryAlgorithm", TrustManagerFactory.getDefaultAlgorithm());
        }
    });
    private Broker _broker;

    public TrustStoreAdapter(UUID id, Broker broker, Map<String, Object> attributes) {
        super(id, broker, DEFAULTS, MapValueConverter.convert(attributes, ATTRIBUTE_TYPES));
        this._broker = broker;
        String trustStorePath = (String)this.getAttribute("path");
        String trustStorePassword = this.getPassword();
        String trustStoreType = (String)this.getAttribute("type");
        String trustManagerFactoryAlgorithm = (String)this.getAttribute("trustManagerFactoryAlgorithm");
        this.validateTrustStoreAttributes(trustStoreType, trustStorePath, trustStorePassword, trustManagerFactoryAlgorithm);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    protected boolean setState(State currentState, State desiredState) {
        if (desiredState == State.DELETED) {
            String storeName = this.getName();
            ArrayList<Port> ports = new ArrayList<Port>(this._broker.getPorts());
            for (Port port : ports) {
                Collection<TrustStore> trustStores = port.getTrustStores();
                for (TrustStore store : trustStores) {
                    if (!storeName.equals(store.getAttribute("name"))) continue;
                    throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by a port: " + port.getName());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void authoriseSetDesiredState(State currentState, State desiredState) throws AccessControlException {
        if (desiredState == State.DELETED && !this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), TrustStore.class, Operation.DELETE)) {
            throw new AccessControlException("Deletion of key store is denied");
        }
    }

    @Override
    protected void authoriseSetAttribute(String name, Object expected, Object desired) throws AccessControlException {
        this.authoriseSetAttribute();
    }

    @Override
    protected void authoriseSetAttributes(Map<String, Object> attributes) throws AccessControlException {
        this.authoriseSetAttribute();
    }

    private void authoriseSetAttribute() {
        if (!this._broker.getSecurityManager().authoriseConfiguringBroker(this.getName(), TrustStore.class, Operation.UPDATE)) {
            throw new AccessControlException("Setting key store attributes is denied");
        }
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        Map<String, Object> changedValues = MapValueConverter.convert(attributes, ATTRIBUTE_TYPES);
        if (changedValues.containsKey("name")) {
            String newName = (String)changedValues.get("name");
            if (!this.getName().equals(newName)) {
                throw new IllegalConfigurationException("Changing the trust store name is not allowed");
            }
        }
        Map<String, Object> merged = this.generateEffectiveAttributes(changedValues);
        String trustStorePath = (String)merged.get("path");
        String trustStorePassword = (String)merged.get("password");
        String trustStoreType = (String)merged.get("type");
        String trustManagerFactoryAlgorithm = (String)merged.get("trustManagerFactoryAlgorithm");
        this.validateTrustStoreAttributes(trustStoreType, trustStorePath, trustStorePassword, trustManagerFactoryAlgorithm);
        super.changeAttributes(changedValues);
    }

    private void validateTrustStoreAttributes(String type, String trustStorePath, String password, String trustManagerFactoryAlgorithm) {
        try {
            SSLUtil.getInitializedKeyStore((String)trustStorePath, (String)password, (String)type);
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Cannot instantiate trust store at " + trustStorePath, e);
        }
        try {
            TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Unknown trustManagerFactoryAlgorithm: " + trustManagerFactoryAlgorithm);
        }
    }
}

