/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQChannelException;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.codec.AMQCodecFactory;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQProtocolHeaderException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.configuration.BrokerProperties;
import org.apache.qpid.server.handler.ServerMethodDispatcherImpl;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.AMQPConnectionActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.logging.subjects.ConnectionLogSubject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.output.ProtocolOutputConverterRegistry;
import org.apache.qpid.server.protocol.AMQNoMethodHandlerException;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionImpl;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.util.BytesDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQProtocolEngine
implements ServerProtocolEngine,
AMQProtocolSession {
    private static final Logger _logger = Logger.getLogger(AMQProtocolEngine.class);
    private static final int CHANNEL_CACHE_SIZE = 255;
    private static final int REUSABLE_BYTE_BUFFER_CAPACITY = 66560;
    private AMQShortString _contextKey;
    private String _clientVersion = null;
    private VirtualHost _virtualHost;
    private final Map<Integer, AMQChannel> _channelMap = new HashMap<Integer, AMQChannel>();
    private final AMQChannel[] _cachedChannels = new AMQChannel[256];
    private final CopyOnWriteArraySet<AMQMethodListener> _frameListeners = new CopyOnWriteArraySet();
    private final AMQStateManager _stateManager;
    private AMQCodecFactory _codecFactory;
    private SaslServer _saslServer;
    private Object _lastReceived;
    private Object _lastSent;
    private volatile boolean _closed;
    private long _maxNoOfChannels;
    private ProtocolVersion _protocolVersion = ProtocolVersion.getLatestSupportedVersion();
    private MethodRegistry _methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)this._protocolVersion);
    private FieldTable _clientProperties;
    private final List<AMQProtocolSession.Task> _taskList = new CopyOnWriteArrayList<AMQProtocolSession.Task>();
    private Map<Integer, Long> _closingChannelsList = new ConcurrentHashMap<Integer, Long>();
    private ProtocolOutputConverter _protocolOutputConverter;
    private Subject _authorizedSubject;
    private MethodDispatcher _dispatcher;
    private final long _connectionID;
    private Object _reference = new Object();
    private AMQPConnectionActor _actor;
    private LogSubject _logSubject;
    private long _lastIoTime;
    private long _writtenBytes;
    private long _readBytes;
    private long _maxFrameSize;
    private final AtomicBoolean _closing = new AtomicBoolean(false);
    private long _createTime = System.currentTimeMillis();
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private NetworkConnection _network;
    private Sender<ByteBuffer> _sender;
    private volatile boolean _deferFlush;
    private long _lastReceivedTime;
    private boolean _blocking;
    private final Lock _receivedLock;
    private AtomicLong _lastWriteTime = new AtomicLong(System.currentTimeMillis());
    private final Broker _broker;
    private final byte[] _reusableBytes = new byte[66560];
    private final ByteBuffer _reusableByteBuffer = ByteBuffer.wrap(this._reusableBytes);
    private final BytesDataOutput _reusableDataOutput = new BytesDataOutput(this._reusableBytes);

    public AMQProtocolEngine(Broker broker, NetworkConnection network, long connectionId) {
        this._broker = broker;
        this._maxNoOfChannels = ((Integer)broker.getAttribute("connection.sessionCountLimit")).intValue();
        this._receivedLock = new ReentrantLock();
        this._stateManager = new AMQStateManager(broker, this);
        this._codecFactory = new AMQCodecFactory(true, (AMQVersionAwareProtocolSession)this);
        this.setNetworkConnection(network);
        this._connectionID = connectionId;
        this._actor = new AMQPConnectionActor(this, this._broker.getRootMessageLogger());
        this._logSubject = new ConnectionLogSubject(this);
        this._actor.message(ConnectionMessages.OPEN(null, null, null, false, false, false));
        this.initialiseStatistics();
    }

    public void setNetworkConnection(NetworkConnection network) {
        this.setNetworkConnection(network, (Sender<ByteBuffer>)network.getSender());
    }

    public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        this._network = network;
        this._sender = sender;
    }

    @Override
    public long getSessionID() {
        return this._connectionID;
    }

    @Override
    public LogActor getLogActor() {
        return this._actor;
    }

    @Override
    public void setMaxFrameSize(long frameMax) {
        this._maxFrameSize = frameMax;
    }

    @Override
    public long getMaxFrameSize() {
        return this._maxFrameSize;
    }

    @Override
    public boolean isClosing() {
        return this._closing.get();
    }

    @Override
    public synchronized void flushBatched() {
        this._sender.flush();
    }

    @Override
    public ClientDeliveryMethod createDeliveryMethod(int channelId) {
        return new WriteDeliverMethod(channelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(ByteBuffer msg) {
        long arrivalTime;
        this._lastReceivedTime = arrivalTime = System.currentTimeMillis();
        this._lastIoTime = arrivalTime;
        this._receivedLock.lock();
        try {
            ArrayList dataBlocks = this._codecFactory.getDecoder().decodeBuffer(msg);
            int len = dataBlocks.size();
            for (int i = 0; i < len; ++i) {
                AMQDataBlock dataBlock = (AMQDataBlock)dataBlocks.get(i);
                try {
                    this.dataBlockReceived(dataBlock);
                    continue;
                }
                catch (Exception e) {
                    _logger.error((Object)"Unexpected exception when processing datablock", (Throwable)e);
                    this.closeProtocolSession();
                }
            }
            this.receiveComplete();
        }
        catch (Exception e) {
            _logger.error((Object)"Unexpected exception when processing datablock", (Throwable)e);
            this.closeProtocolSession();
        }
        finally {
            this._receivedLock.unlock();
        }
    }

    private void receiveComplete() {
        for (AMQChannel channel : this._channelMap.values()) {
            channel.receivedComplete();
        }
    }

    public void dataBlockReceived(AMQDataBlock message) throws Exception {
        this._lastReceived = message;
        if (message instanceof ProtocolInitiation) {
            this.protocolInitiationReceived((ProtocolInitiation)message);
        } else if (message instanceof AMQFrame) {
            AMQFrame frame = (AMQFrame)message;
            this.frameReceived(frame);
        } else {
            throw new AMQException("Unknown message type: " + message.getClass().getName() + ": " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frameReceived(AMQFrame frame) throws AMQException {
        int channelId = frame.getChannel();
        AMQBody body = frame.getBodyFrame();
        LogActor channelActor = null;
        if (this._channelMap.get(channelId) != null) {
            channelActor = this._channelMap.get(channelId).getLogActor();
        }
        CurrentActor.set(channelActor == null ? this._actor : channelActor);
        try {
            long startTime = 0L;
            String frameToString = null;
            if (_logger.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                frameToString = frame.toString();
                _logger.debug((Object)("RECV: " + frame));
            }
            if (this.channelAwaitingClosure(channelId)) {
                if (frame.getBodyFrame() instanceof ChannelCloseOkBody) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Channel[" + channelId + "] awaiting closure - processing close-ok"));
                    }
                } else {
                    return;
                }
            }
            try {
                body.handle(channelId, (AMQVersionAwareProtocolSession)this);
            }
            catch (AMQException e) {
                this.closeChannel(channelId);
                throw e;
            }
            catch (TransportException e) {
                this.closeChannel(channelId);
                throw e;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Frame handled in " + (System.currentTimeMillis() - startTime) + " ms. Frame: " + frameToString));
            }
        }
        finally {
            CurrentActor.remove();
        }
    }

    private synchronized void protocolInitiationReceived(ProtocolInitiation pi) {
        this._codecFactory.getDecoder().setExpectProtocolInitiation(false);
        try {
            this._actor.message(ConnectionMessages.OPEN(null, pi.getProtocolMajor() + "-" + pi.getProtocolMinor(), null, false, true, false));
            ProtocolVersion pv = pi.checkVersion();
            this.setProtocolVersion(pv);
            String mechanisms = this._broker.getSubjectCreator(this.getLocalAddress()).getMechanisms();
            String locales = "en_US";
            ConnectionStartBody responseBody = this.getMethodRegistry().createConnectionStartBody((short)this.getProtocolMajorVersion(), (short)pv.getActualMinorVersion(), null, mechanisms.getBytes(), locales.getBytes());
            this._sender.send((Object)this.asByteBuffer((AMQDataBlock)responseBody.generateFrame(0)));
            this._sender.flush();
        }
        catch (AMQException e) {
            _logger.info((Object)("Received unsupported protocol initiation for protocol version: " + this.getProtocolVersion()));
            this._sender.send((Object)this.asByteBuffer((AMQDataBlock)new ProtocolInitiation(ProtocolVersion.getLatestSupportedVersion())));
            this._sender.flush();
        }
    }

    private ByteBuffer asByteBuffer(AMQDataBlock block) {
        ByteBuffer buf;
        int size = (int)block.getSize();
        byte[] data = size > 66560 ? new byte[size] : this._reusableBytes;
        this._reusableDataOutput.setBuffer(data);
        try {
            block.writePayload((DataOutput)this._reusableDataOutput);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (size <= 66560) {
            buf = this._reusableByteBuffer;
            buf.position(0);
        } else {
            buf = ByteBuffer.wrap(data);
        }
        buf.limit(this._reusableDataOutput.length());
        return buf;
    }

    public void methodFrameReceived(int channelId, AMQMethodBody methodBody) {
        block14: {
            AMQMethodEvent evt = new AMQMethodEvent(channelId, methodBody);
            try {
                try {
                    boolean wasAnyoneInterested = this._stateManager.methodReceived(evt);
                    if (!this._frameListeners.isEmpty()) {
                        for (AMQMethodListener listener : this._frameListeners) {
                            wasAnyoneInterested = listener.methodReceived(evt) || wasAnyoneInterested;
                        }
                    }
                    if (!wasAnyoneInterested) {
                        throw new AMQNoMethodHandlerException((AMQMethodEvent<AMQMethodBody>)evt);
                    }
                }
                catch (AMQChannelException e) {
                    if (this.getChannel(channelId) != null) {
                        if (_logger.isInfoEnabled()) {
                            _logger.info((Object)("Closing channel due to: " + e.getMessage()));
                        }
                        this.writeFrame((AMQDataBlock)e.getCloseFrame(channelId));
                        this.closeChannel(channelId);
                        break block14;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("ChannelException occured on non-existent channel:" + e.getMessage()));
                    }
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Closing connection due to: " + e.getMessage()));
                    }
                    AMQConnectionException ce = evt.getMethod().getConnectionException(AMQConstant.CHANNEL_ERROR, AMQConstant.CHANNEL_ERROR.getName().toString());
                    _logger.info((Object)(e.getMessage() + " whilst processing:" + methodBody));
                    this.closeConnection(channelId, ce);
                }
                catch (AMQConnectionException e) {
                    _logger.info((Object)(e.getMessage() + " whilst processing:" + methodBody));
                    this.closeConnection(channelId, e);
                }
                catch (AMQSecurityException e) {
                    AMQConnectionException ce = evt.getMethod().getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
                    _logger.info((Object)(e.getMessage() + " whilst processing:" + methodBody));
                    this.closeConnection(channelId, ce);
                }
            }
            catch (Exception e) {
                for (AMQMethodListener listener : this._frameListeners) {
                    listener.error(e);
                }
                _logger.error((Object)"Unexpected exception while processing frame.  Closing connection.", (Throwable)e);
                this.closeProtocolSession();
            }
        }
    }

    public void contentHeaderReceived(int channelId, ContentHeaderBody body) throws AMQException {
        AMQChannel channel = this.getAndAssertChannel(channelId);
        channel.publishContentHeader(body);
    }

    public void contentBodyReceived(int channelId, ContentBody body) throws AMQException {
        AMQChannel channel = this.getAndAssertChannel(channelId);
        channel.publishContentBody(body);
    }

    public void heartbeatBodyReceived(int channelId, HeartbeatBody body) {
    }

    public synchronized void writeFrame(AMQDataBlock frame) {
        long time;
        ByteBuffer buf = this.asByteBuffer(frame);
        this._writtenBytes += (long)buf.remaining();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("SEND: " + frame));
        }
        this._sender.send((Object)buf);
        this._lastIoTime = time = System.currentTimeMillis();
        this._lastWriteTime.set(time);
        if (!this._deferFlush) {
            this._sender.flush();
        }
    }

    @Override
    public AMQShortString getContextKey() {
        return this._contextKey;
    }

    @Override
    public void setContextKey(AMQShortString contextKey) {
        this._contextKey = contextKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AMQChannel> getChannels() {
        Map<Integer, AMQChannel> map = this._channelMap;
        synchronized (map) {
            return new ArrayList<AMQChannel>(this._channelMap.values());
        }
    }

    public AMQChannel getAndAssertChannel(int channelId) throws AMQException {
        AMQChannel channel = this.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Channel not found with id:" + channelId);
        }
        return channel;
    }

    @Override
    public AMQChannel getChannel(int channelId) {
        AMQChannel channel;
        AMQChannel aMQChannel = channel = (channelId & 0xFF) == channelId ? this._cachedChannels[channelId] : this._channelMap.get(channelId);
        if (channel == null || channel.isClosing()) {
            return null;
        }
        return channel;
    }

    @Override
    public boolean channelAwaitingClosure(int channelId) {
        return !this._closingChannelsList.isEmpty() && this._closingChannelsList.containsKey(channelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannel(AMQChannel channel) throws AMQException {
        if (this._closed) {
            throw new AMQException("Session is closed");
        }
        int channelId = channel.getChannelId();
        if (this._closingChannelsList.containsKey(channelId)) {
            throw new AMQException("Session is marked awaiting channel close");
        }
        if ((long)this._channelMap.size() == this._maxNoOfChannels) {
            String errorMessage = this.toString() + ": maximum number of channels has been reached (" + this._maxNoOfChannels + "); can't create channel";
            _logger.error((Object)errorMessage);
            throw new AMQException(AMQConstant.NOT_ALLOWED, errorMessage);
        }
        Map<Integer, AMQChannel> map = this._channelMap;
        synchronized (map) {
            this._channelMap.put(channel.getChannelId(), channel);
            if (this._blocking) {
                channel.block();
            }
        }
        if ((channelId & 0xFF) == channelId) {
            this._cachedChannels[channelId] = channel;
        }
    }

    @Override
    public Long getMaximumNumberOfChannels() {
        return this._maxNoOfChannels;
    }

    @Override
    public void setMaximumNumberOfChannels(Long value) {
        this._maxNoOfChannels = value;
    }

    @Override
    public void commitTransactions(AMQChannel channel) throws AMQException {
        if (channel != null && channel.isTransactional()) {
            channel.commit();
        }
    }

    @Override
    public void rollbackTransactions(AMQChannel channel) throws AMQException {
        if (channel != null && channel.isTransactional()) {
            channel.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeChannel(int channelId) throws AMQException {
        AMQChannel channel = this.getChannel(channelId);
        if (channel == null) {
            throw new IllegalArgumentException("Unknown channel id");
        }
        try {
            channel.close();
            this.markChannelAwaitingCloseOk(channelId);
        }
        finally {
            this.removeChannel(channelId);
        }
    }

    @Override
    public void closeChannelOk(int channelId) {
        this._closingChannelsList.remove(channelId);
    }

    private void markChannelAwaitingCloseOk(int channelId) {
        this._closingChannelsList.put(channelId, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChannel(int channelId) {
        Map<Integer, AMQChannel> map = this._channelMap;
        synchronized (map) {
            this._channelMap.remove(channelId);
            if ((channelId & 0xFF) == channelId) {
                this._cachedChannels[channelId] = null;
            }
        }
    }

    @Override
    public void initHeartbeats(int delay) {
        if (delay > 0) {
            this._network.setMaxWriteIdle(delay);
            this._network.setMaxReadIdle(BrokerProperties.HEARTBEAT_TIMEOUT_FACTOR * delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllChannels() throws AMQException {
        for (AMQChannel channel : this.getChannels()) {
            channel.close();
        }
        Map<Integer, AMQChannel> i$ = this._channelMap;
        synchronized (i$) {
            this._channelMap.clear();
        }
        for (int i = 0; i <= 255; ++i) {
            this._cachedChannels[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession() throws AMQException {
        if (this._closing.compareAndSet(false, true)) {
            this.receiveComplete();
            if (CurrentActor.get() == null) {
                CurrentActor.set(this._actor);
            }
            if (!this._closed) {
                if (this._virtualHost != null) {
                    this._virtualHost.getConnectionRegistry().deregisterConnection(this);
                }
                this.closeAllChannels();
                for (AMQProtocolSession.Task task : this._taskList) {
                    task.doTask(this);
                }
                AMQProtocolEngine aMQProtocolEngine = this;
                synchronized (aMQProtocolEngine) {
                    this._closed = true;
                    this.notifyAll();
                }
                CurrentActor.get().message(this._logSubject, ConnectionMessages.CLOSE());
            }
        } else {
            AMQProtocolEngine aMQProtocolEngine = this;
            synchronized (aMQProtocolEngine) {
                while (!this._closed) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(int channelId, AMQConnectionException e) throws AMQException {
        try {
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("Closing connection due to: " + (Object)((Object)e)));
            }
            this.markChannelAwaitingCloseOk(channelId);
            this.closeSession();
        }
        finally {
            try {
                this._stateManager.changeState(AMQState.CONNECTION_CLOSING);
                this.writeFrame((AMQDataBlock)e.getCloseFrame(channelId));
            }
            finally {
                this.closeProtocolSession();
            }
        }
    }

    @Override
    public void closeProtocolSession() {
        this._network.close();
        try {
            this._stateManager.changeState(AMQState.CONNECTION_CLOSED);
        }
        catch (AMQException e) {
            _logger.info((Object)e.getMessage());
        }
        catch (TransportException e) {
            _logger.info((Object)e.getMessage());
        }
    }

    public String toString() {
        return this.getRemoteAddress() + "(" + (this.getAuthorizedPrincipal() == null ? "?" : this.getAuthorizedPrincipal().getName() + ")");
    }

    public String dump() {
        return this + " last_sent=" + this._lastSent + " last_received=" + this._lastReceived;
    }

    @Override
    public Object getKey() {
        return this.getRemoteAddress();
    }

    @Override
    public String getLocalFQDN() {
        SocketAddress address = this._network.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostName();
        }
        throw new IllegalArgumentException("Unsupported socket address class: " + address);
    }

    @Override
    public SaslServer getSaslServer() {
        return this._saslServer;
    }

    @Override
    public void setSaslServer(SaslServer saslServer) {
        this._saslServer = saslServer;
    }

    @Override
    public void setClientProperties(FieldTable clientProperties) {
        this._clientProperties = clientProperties;
        if (this._clientProperties != null) {
            this._clientVersion = this._clientProperties.getString("version");
            if (this._clientProperties.getString("instance") != null) {
                String clientID = this._clientProperties.getString("instance");
                this.setContextKey(new AMQShortString(clientID));
                this._actor.message(ConnectionMessages.OPEN(clientID, this._protocolVersion.toString(), this._clientVersion, true, true, true));
            }
        }
    }

    private void setProtocolVersion(ProtocolVersion pv) {
        this._protocolVersion = pv;
        this._methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)this._protocolVersion);
        this._protocolOutputConverter = ProtocolOutputConverterRegistry.getConverter(this);
        this._dispatcher = ServerMethodDispatcherImpl.createMethodDispatcher(this._stateManager, this._protocolVersion);
    }

    public byte getProtocolMajorVersion() {
        return this._protocolVersion.getMajorVersion();
    }

    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    public byte getProtocolMinorVersion() {
        return this._protocolVersion.getMinorVersion();
    }

    public boolean isProtocolVersion(byte major, byte minor) {
        return this.getProtocolMajorVersion() == major && this.getProtocolMinorVersion() == minor;
    }

    public MethodRegistry getRegistry() {
        return this.getMethodRegistry();
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void setVirtualHost(VirtualHost virtualHost) throws AMQException {
        this._virtualHost = virtualHost;
        this._virtualHost.getConnectionRegistry().registerConnection(this);
    }

    @Override
    public void addSessionCloseTask(AMQProtocolSession.Task task) {
        this._taskList.add(task);
    }

    @Override
    public void removeSessionCloseTask(AMQProtocolSession.Task task) {
        this._taskList.remove(task);
    }

    @Override
    public ProtocolOutputConverter getProtocolOutputConverter() {
        return this._protocolOutputConverter;
    }

    @Override
    public void setAuthorizedSubject(Subject authorizedSubject) {
        if (authorizedSubject == null) {
            throw new IllegalArgumentException("authorizedSubject cannot be null");
        }
        this._authorizedSubject = authorizedSubject;
    }

    @Override
    public Subject getAuthorizedSubject() {
        return this._authorizedSubject;
    }

    @Override
    public Principal getAuthorizedPrincipal() {
        return this._authorizedSubject == null ? null : AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(this._authorizedSubject);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._network.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._network.getLocalAddress();
    }

    @Override
    public Principal getPeerPrincipal() {
        return this._network.getPeerPrincipal();
    }

    @Override
    public MethodRegistry getMethodRegistry() {
        return this._methodRegistry;
    }

    @Override
    public MethodDispatcher getMethodDispatcher() {
        return this._dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        try {
            try {
                this.closeSession();
            }
            finally {
                this.closeProtocolSession();
            }
        }
        catch (AMQException e) {
            _logger.error((Object)"Could not close protocol engine", (Throwable)e);
        }
        catch (TransportException e) {
            _logger.error((Object)"Could not close protocol engine", (Throwable)e);
        }
    }

    public void readerIdle() {
    }

    public synchronized void writerIdle() {
        this.writeFrame((AMQDataBlock)HeartbeatBody.FRAME);
    }

    public void exception(Throwable throwable) {
        if (throwable instanceof AMQProtocolHeaderException) {
            this.writeFrame((AMQDataBlock)new ProtocolInitiation(ProtocolVersion.getLatestSupportedVersion()));
            this._sender.close();
            _logger.error((Object)("Error in protocol initiation " + this + ":" + this.getRemoteAddress() + " :" + throwable.getMessage()), throwable);
        } else if (throwable instanceof IOException) {
            _logger.error((Object)("IOException caught in" + this + ", session closed implictly: " + throwable));
        } else {
            _logger.error((Object)("Exception caught in" + this + ", closing session explictly: " + throwable), throwable);
            MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)this.getProtocolVersion());
            ConnectionCloseBody closeBody = methodRegistry.createConnectionCloseBody(200, new AMQShortString(throwable.getMessage()), 0, 0);
            this.writeFrame((AMQDataBlock)closeBody.generateFrame(0));
            this._sender.close();
        }
    }

    public void init() {
    }

    public void setSender(Sender<ByteBuffer> sender) {
    }

    public long getReadBytes() {
        return this._readBytes;
    }

    @Override
    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    @Override
    public long getLastIoTime() {
        return this._lastIoTime;
    }

    @Override
    public long getLastReceivedTime() {
        return this._lastReceivedTime;
    }

    @Override
    public String getClientVersion() {
        return this._clientVersion;
    }

    @Override
    public String getPrincipalAsString() {
        return this.getAuthId();
    }

    @Override
    public long getSessionCountLimit() {
        return this.getMaximumNumberOfChannels();
    }

    public Boolean isIncoming() {
        return true;
    }

    public Boolean isSystemConnection() {
        return false;
    }

    public Boolean isFederationLink() {
        return false;
    }

    public String getAuthId() {
        return this.getAuthorizedPrincipal().getName();
    }

    public Integer getRemotePID() {
        return null;
    }

    public String getRemoteProcessName() {
        return null;
    }

    public Integer getRemoteParentPID() {
        return null;
    }

    public boolean isDurable() {
        return false;
    }

    @Override
    public long getConnectionId() {
        return this.getSessionID();
    }

    public String getAddress() {
        return String.valueOf(this.getRemoteAddress());
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public Boolean isShadow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mgmtClose() {
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ConnectionCloseBody responseBody = methodRegistry.createConnectionCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), new AMQShortString("The connection was closed using the broker's management interface."), 0, 0);
        boolean removeActor = false;
        if (CurrentActor.get() == null) {
            removeActor = true;
            CurrentActor.set(new ManagementActor(this._actor.getRootMessageLogger()));
        }
        try {
            this.writeFrame((AMQDataBlock)responseBody.generateFrame(0));
            try {
                this.closeSession();
            }
            catch (AMQException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (removeActor) {
                CurrentActor.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mgmtCloseChannel(int channelId) {
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ChannelCloseBody responseBody = methodRegistry.createChannelCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), new AMQShortString("The channel was closed using the broker's management interface."), 0, 0);
        boolean removeActor = false;
        if (CurrentActor.get() == null) {
            removeActor = true;
            CurrentActor.set(new ManagementActor(this._actor.getRootMessageLogger()));
        }
        try {
            this.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            try {
                this.closeChannel(channelId);
            }
            catch (AMQException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (removeActor) {
                CurrentActor.remove();
            }
        }
    }

    public String getClientID() {
        return this.getContextKey().toString();
    }

    @Override
    public void closeSession(AMQSessionModel session, AMQConstant cause, String message) throws AMQException {
        int channelId = ((AMQChannel)session).getChannelId();
        this.closeChannel(channelId);
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ChannelCloseBody responseBody = methodRegistry.createChannelCloseBody(cause.getCode(), new AMQShortString(message), 0, 0);
        this.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }

    @Override
    public void close(AMQConstant cause, String message) throws AMQException {
        this.closeConnection(0, new AMQConnectionException(cause, message, 0, 0, this.getProtocolOutputConverter().getProtocolMajorVersion(), this.getProtocolOutputConverter().getProtocolMinorVersion(), (Throwable)null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block() {
        Map<Integer, AMQChannel> map = this._channelMap;
        synchronized (map) {
            if (!this._blocking) {
                this._blocking = true;
                for (AMQChannel channel : this._channelMap.values()) {
                    channel.block();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblock() {
        Map<Integer, AMQChannel> map = this._channelMap;
        synchronized (map) {
            if (this._blocking) {
                this._blocking = false;
                for (AMQChannel channel : this._channelMap.values()) {
                    channel.unblock();
                }
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public List<AMQSessionModel> getSessionModels() {
        return new ArrayList<AMQSessionModel>(this.getChannels());
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
        this._virtualHost.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
        this._virtualHost.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
    }

    @Override
    public void initialiseStatistics() {
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getSessionID());
        this._dataDelivered = new StatisticsCounter("data-delivered-" + this.getSessionID());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getSessionID());
        this._dataReceived = new StatisticsCounter("data-received-" + this.getSessionID());
    }

    @Override
    public boolean isSessionNameUnique(byte[] name) {
        return true;
    }

    @Override
    public String getRemoteAddressString() {
        return String.valueOf(this.getRemoteAddress());
    }

    @Override
    public String getClientId() {
        return String.valueOf(this.getContextKey());
    }

    @Override
    public void setDeferFlush(boolean deferFlush) {
        this._deferFlush = deferFlush;
    }

    @Override
    public String getUserName() {
        return this.getAuthorizedPrincipal().getName();
    }

    @Override
    public Object getReference() {
        return this._reference;
    }

    @Override
    public Lock getReceivedLock() {
        return this._receivedLock;
    }

    public long getLastReadTime() {
        return this._lastReceivedTime;
    }

    public long getLastWriteTime() {
        return this._lastWriteTime.get();
    }

    public final class WriteDeliverMethod
    implements ClientDeliveryMethod {
        private final int _channelId;

        public WriteDeliverMethod(int channelId) {
            this._channelId = channelId;
        }

        public void deliverToClient(Subscription sub, QueueEntry entry, long deliveryTag) throws AMQException {
            AMQProtocolEngine.this.registerMessageDelivered(entry.getMessage().getSize());
            AMQProtocolEngine.this._protocolOutputConverter.writeDeliver(entry, this._channelId, deliveryTag, ((SubscriptionImpl)sub).getConsumerTag());
            entry.incrementDeliveryCount();
        }
    }
}

