/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolEngine_0_10
extends InputHandler
implements ServerProtocolEngine {
    public static final int MAX_FRAME_SIZE = 65535;
    private NetworkConnection _network;
    private long _readBytes;
    private long _writtenBytes;
    private ServerConnection _connection;
    private long _createTime = System.currentTimeMillis();
    private long _lastReadTime;
    private long _lastWriteTime;

    public ProtocolEngine_0_10(ServerConnection conn, NetworkConnection network) {
        super((Receiver)new Assembler((Receiver)conn));
        this._connection = conn;
        if (network != null) {
            this.setNetworkConnection(network);
        }
    }

    public void setNetworkConnection(NetworkConnection network) {
        this.setNetworkConnection(network, (Sender<ByteBuffer>)network.getSender());
    }

    public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        this._network = network;
        this._connection.setNetworkConnection(network);
        this._connection.setSender((Sender)new Disassembler(this.wrapSender(sender), 65535));
        this._connection.setPeerPrincipal(this._network.getPeerPrincipal());
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, null, null, false, false, false));
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, "0-10", null, false, true, false));
    }

    private Sender<ByteBuffer> wrapSender(final Sender<ByteBuffer> sender) {
        return new Sender<ByteBuffer>(){

            public void setIdleTimeout(int i) {
                sender.setIdleTimeout(i);
            }

            public void send(ByteBuffer msg) {
                ProtocolEngine_0_10.this._lastWriteTime = System.currentTimeMillis();
                sender.send((Object)msg);
            }

            public void flush() {
                sender.flush();
            }

            public void close() {
                sender.close();
            }
        };
    }

    public long getLastReadTime() {
        return this._lastReadTime;
    }

    public long getLastWriteTime() {
        return this._lastWriteTime;
    }

    public SocketAddress getRemoteAddress() {
        return this._network.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._network.getLocalAddress();
    }

    public void received(ByteBuffer buf) {
        this._lastReadTime = System.currentTimeMillis();
        super.received(buf);
        this._connection.receivedComplete();
    }

    public long getReadBytes() {
        return this._readBytes;
    }

    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    public void writerIdle() {
        this._connection.doHeartbeat();
    }

    public void readerIdle() {
    }

    public String getAddress() {
        return this.getRemoteAddress().toString();
    }

    public String getAuthId() {
        return this._connection.getAuthorizedPrincipal() == null ? null : this._connection.getAuthorizedPrincipal().getName();
    }

    public boolean isDurable() {
        return false;
    }

    public void closed() {
        super.closed();
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public long getConnectionId() {
        return this._connection.getConnectionId();
    }
}

