/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.ConnectionEventListener;
import org.apache.qpid.amqp_1_0.transport.SessionEndpoint;
import org.apache.qpid.amqp_1_0.transport.SessionEventListener;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class Connection_1_0
implements ConnectionEventListener {
    private VirtualHost _vhost;
    private final ConnectionEndpoint _conn;
    private final long _connectionId;
    private final Collection<Session_1_0> _sessions = Collections.synchronizedCollection(new ArrayList());
    private List<Task> _closeTasks = Collections.synchronizedList(new ArrayList());
    private final AMQConnectionModel _model = new AMQConnectionModel(){
        private StatisticsCounter _messageDeliveryStatistics = new StatisticsCounter();
        private StatisticsCounter _messageReceiptStatistics = new StatisticsCounter();
        private StatisticsCounter _dataDeliveryStatistics = new StatisticsCounter();
        private StatisticsCounter _dataReceiptStatistics = new StatisticsCounter();
        private final LogSubject _logSubject = new LogSubject(){

            public String toLogString() {
                return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})", this.getConnectionId(), this.getClientId(), this.getRemoteAddressString(), Connection_1_0.this._vhost.getName()) + "] ";
            }
        };

        @Override
        public void close(AMQConstant cause, String message) throws AMQException {
            Connection_1_0.this._conn.close();
        }

        @Override
        public void block() {
        }

        @Override
        public void unblock() {
        }

        @Override
        public void closeSession(AMQSessionModel session, AMQConstant cause, String message) throws AMQException {
        }

        @Override
        public long getConnectionId() {
            return Connection_1_0.this._connectionId;
        }

        @Override
        public List<AMQSessionModel> getSessionModels() {
            return new ArrayList<AMQSessionModel>(Connection_1_0.this._sessions);
        }

        @Override
        public LogSubject getLogSubject() {
            return this._logSubject;
        }

        @Override
        public String getUserName() {
            return this.getPrincipalAsString();
        }

        @Override
        public boolean isSessionNameUnique(byte[] name) {
            return true;
        }

        @Override
        public String getRemoteAddressString() {
            return String.valueOf(Connection_1_0.this._conn.getRemoteAddress());
        }

        @Override
        public String getClientId() {
            return Connection_1_0.this._conn.getRemoteContainerId();
        }

        @Override
        public String getClientVersion() {
            return "";
        }

        @Override
        public String getPrincipalAsString() {
            return String.valueOf(Connection_1_0.this._conn.getUser());
        }

        @Override
        public long getSessionCountLimit() {
            return 0L;
        }

        @Override
        public long getLastIoTime() {
            return 0L;
        }

        @Override
        public void initialiseStatistics() {
            this._messageDeliveryStatistics = new StatisticsCounter("messages-delivered-" + this.getConnectionId());
            this._dataDeliveryStatistics = new StatisticsCounter("data-delivered-" + this.getConnectionId());
            this._messageReceiptStatistics = new StatisticsCounter("messages-received-" + this.getConnectionId());
            this._dataReceiptStatistics = new StatisticsCounter("data-received-" + this.getConnectionId());
        }

        @Override
        public void registerMessageReceived(long messageSize, long timestamp) {
            this._messageReceiptStatistics.registerEvent(1L, timestamp);
            this._dataReceiptStatistics.registerEvent(messageSize, timestamp);
            Connection_1_0.this._vhost.registerMessageReceived(messageSize, timestamp);
        }

        @Override
        public void registerMessageDelivered(long messageSize) {
            this._messageDeliveryStatistics.registerEvent(1L);
            this._dataDeliveryStatistics.registerEvent(messageSize);
            Connection_1_0.this._vhost.registerMessageDelivered(messageSize);
        }

        @Override
        public StatisticsCounter getMessageDeliveryStatistics() {
            return this._messageDeliveryStatistics;
        }

        @Override
        public StatisticsCounter getMessageReceiptStatistics() {
            return this._messageReceiptStatistics;
        }

        @Override
        public StatisticsCounter getDataDeliveryStatistics() {
            return this._dataDeliveryStatistics;
        }

        @Override
        public StatisticsCounter getDataReceiptStatistics() {
            return this._dataReceiptStatistics;
        }

        @Override
        public void resetStatistics() {
            this._dataDeliveryStatistics.reset();
            this._dataReceiptStatistics.reset();
            this._messageDeliveryStatistics.reset();
            this._messageReceiptStatistics.reset();
        }
    };

    public Connection_1_0(VirtualHost virtualHost, ConnectionEndpoint conn, long connectionId) {
        this._vhost = virtualHost;
        this._conn = conn;
        this._connectionId = connectionId;
        this._vhost.getConnectionRegistry().registerConnection(this._model);
    }

    public void remoteSessionCreation(SessionEndpoint endpoint) {
        Session_1_0 session = new Session_1_0(this._vhost, this);
        this._sessions.add(session);
        endpoint.setSessionEventListener((SessionEventListener)session);
    }

    void sessionEnded(Session_1_0 session) {
        this._sessions.remove(session);
    }

    void removeConnectionCloseTask(Task task) {
        this._closeTasks.remove(task);
    }

    void addConnectionCloseTask(Task task) {
        this._closeTasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReceived() {
        ArrayList<Task> taskCopy;
        List<Task> list = this._closeTasks;
        synchronized (list) {
            taskCopy = new ArrayList<Task>(this._closeTasks);
        }
        for (Task task : taskCopy) {
            task.doTask(this);
        }
        list = this._closeTasks;
        synchronized (list) {
            this._closeTasks.clear();
        }
        this._vhost.getConnectionRegistry().deregisterConnection(this._model);
    }

    public void closed() {
        this.closeReceived();
    }

    AMQConnectionModel getModel() {
        return this._model;
    }

    public static interface Task {
        public void doTask(Connection_1_0 var1);
    }
}

