/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.message.MessageMetaData_1_0;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.store.StoredMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message_1_0
implements ServerMessage,
InboundMessage {
    private static final AtomicIntegerFieldUpdater<Message_1_0> _refCountUpdater = AtomicIntegerFieldUpdater.newUpdater(Message_1_0.class, "_referenceCount");
    private volatile int _referenceCount = 0;
    private final StoredMessage<MessageMetaData_1_0> _storedMessage;
    private List<ByteBuffer> _fragments;
    private WeakReference<Session_1_0> _session;
    private long _arrivalTime;

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage) {
        this._storedMessage = storedMessage;
        this._session = null;
        this._fragments = Message_1_0.restoreFragments(storedMessage);
    }

    private static List<ByteBuffer> restoreFragments(StoredMessage<MessageMetaData_1_0> storedMessage) {
        ByteBuffer b;
        ArrayList<ByteBuffer> fragments = new ArrayList<ByteBuffer>();
        int FRAGMENT_SIZE = 2048;
        int offset = 0;
        do {
            if (!(b = storedMessage.getContent(offset, 2048)).hasRemaining()) continue;
            fragments.add(b);
            offset += b.remaining();
        } while (b.hasRemaining());
        return fragments;
    }

    public Message_1_0(StoredMessage<MessageMetaData_1_0> storedMessage, List<ByteBuffer> fragments, Session_1_0 session) {
        this._storedMessage = storedMessage;
        this._fragments = fragments;
        this._session = new WeakReference<Session_1_0>(session);
        this._arrivalTime = System.currentTimeMillis();
    }

    @Override
    public String getRoutingKey() {
        Object routingKey = this.getMessageHeader().getHeader("routing-key");
        if (routingKey != null) {
            return routingKey.toString();
        }
        return this.getMessageHeader().getSubject();
    }

    @Override
    public AMQShortString getRoutingKeyShortString() {
        return AMQShortString.valueOf((String)this.getRoutingKey());
    }

    private MessageMetaData_1_0 getMessageMetaData() {
        return this._storedMessage.getMetaData();
    }

    @Override
    public MessageMetaData_1_0.MessageHeader_1_0 getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    @Override
    public StoredMessage getStoredMessage() {
        return this._storedMessage;
    }

    @Override
    public boolean isPersistent() {
        return this.getMessageMetaData().isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        long size = 0L;
        if (this._fragments != null) {
            for (ByteBuffer buf : this._fragments) {
                size += (long)buf.remaining();
            }
        }
        return size;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public long getExpiration() {
        return this.getMessageHeader().getExpiration();
    }

    @Override
    public MessageReference<Message_1_0> newReference() {
        return new Reference(this);
    }

    @Override
    public long getMessageNumber() {
        return this._storedMessage.getMessageNumber();
    }

    @Override
    public long getArrivalTime() {
        return this._arrivalTime;
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        return this._storedMessage.getContent(offset, buf);
    }

    @Override
    public ByteBuffer getContent(int offset, int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.limit(this.getContent(buf, offset));
        return buf;
    }

    public List<ByteBuffer> getFragments() {
        return this._fragments;
    }

    public Session_1_0 getSession() {
        return this._session == null ? null : (Session_1_0)this._session.get();
    }

    public boolean incrementReference() {
        if (_refCountUpdater.incrementAndGet(this) <= 0) {
            _refCountUpdater.decrementAndGet(this);
            return false;
        }
        return true;
    }

    public void decrementReference() {
        int count = _refCountUpdater.decrementAndGet(this);
        if (count == 0) {
            _refCountUpdater.set(this, -1073741824);
            if (this._storedMessage != null) {
                this._storedMessage.remove();
            }
        } else if (count < 0) {
            throw new RuntimeException("Reference count for message id " + this.getMessageNumber() + " has gone below 0.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference
    extends MessageReference<Message_1_0> {
        public Reference(Message_1_0 message) {
            super(message);
        }

        @Override
        protected void onReference(Message_1_0 message) {
            message.incrementReference();
        }

        @Override
        protected void onRelease(Message_1_0 message) {
            message.decrementReference();
        }
    }
}

