/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.txn.ServerTransaction;

public class QueueDestination
implements SendingDestination,
ReceivingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED};
    private AMQQueue _queue;

    public QueueDestination(AMQQueue queue) {
        this._queue = queue;
    }

    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    public Outcome send(final Message_1_0 message, ServerTransaction txn) {
        try {
            txn.enqueue(this._queue, (EnqueableMessage)message, new ServerTransaction.Action(){

                public void postCommit() {
                    try {
                        QueueDestination.this._queue.enqueue(message);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onRollback() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return ACCEPTED;
    }

    public int getCredit() {
        return 100;
    }

    public AMQQueue getQueue() {
        return this._queue;
    }
}

