/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoder;
import org.apache.qpid.amqp_1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkListener;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.transaction.TransactionalState;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;
import org.apache.qpid.server.message.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class ReceivingLink_1_0
implements ReceivingLinkListener,
Link_1_0,
DeliveryStateHandler {
    private VirtualHost _vhost;
    private ReceivingDestination _destination;
    private SectionDecoderImpl _sectionDecoder;
    private volatile ReceivingLinkAttachment _attachment;
    private ArrayList<Transfer> _incompleteMessage;
    private TerminusDurability _durability;
    private Map<Binary, Outcome> _unsettledMap = Collections.synchronizedMap(new HashMap());
    private boolean _resumedMessage;
    private Binary _messageDeliveryTag;
    private ReceiverSettleMode _receivingSettlementMode;

    public ReceivingLink_1_0(ReceivingLinkAttachment receivingLinkAttachment, VirtualHost vhost, ReceivingDestination destination) {
        this._vhost = vhost;
        this._destination = destination;
        this._attachment = receivingLinkAttachment;
        receivingLinkAttachment.setDeliveryStateHandler(this);
        this._durability = ((Target)receivingLinkAttachment.getTarget()).getDurable();
        this._sectionDecoder = new SectionDecoderImpl(receivingLinkAttachment.getEndpoint().getSession().getConnection().getDescribedTypeRegistry());
    }

    public void messageTransfer(Transfer xfr) {
        List<ByteBuffer> fragments = null;
        if (Boolean.TRUE.equals(xfr.getMore()) && this._incompleteMessage == null) {
            this._incompleteMessage = new ArrayList();
            this._incompleteMessage.add(xfr);
            this._resumedMessage = Boolean.TRUE.equals(xfr.getResume());
            this._messageDeliveryTag = xfr.getDeliveryTag();
            return;
        }
        if (this._incompleteMessage != null) {
            this._incompleteMessage.add(xfr);
            if (Boolean.TRUE.equals(xfr.getMore())) {
                return;
            }
            fragments = new ArrayList<ByteBuffer>(this._incompleteMessage.size());
            for (Transfer t : this._incompleteMessage) {
                fragments.add(t.getPayload());
            }
            this._incompleteMessage = null;
        } else {
            this._resumedMessage = Boolean.TRUE.equals(xfr.getResume());
            this._messageDeliveryTag = xfr.getDeliveryTag();
            fragments = Collections.singletonList(xfr.getPayload());
        }
        if (this._resumedMessage) {
            if (this._unsettledMap.containsKey(this._messageDeliveryTag)) {
                Outcome outcome = this._unsettledMap.get(this._messageDeliveryTag);
                boolean settled = ReceiverSettleMode.FIRST.equals(this.getReceivingSettlementMode());
                this.getEndpoint().updateDisposition(this._messageDeliveryTag, (DeliveryState)outcome, settled);
                if (settled) {
                    this._unsettledMap.remove(this._messageDeliveryTag);
                }
            } else {
                System.err.println("UNEXPECTED!!");
                System.err.println("Delivery Tag: " + this._messageDeliveryTag);
                System.err.println("_unsettledMap: " + this._unsettledMap);
            }
        } else {
            DeliveryState resultantState;
            Session_1_0 session;
            MessageMetaData_1_0 mmd = null;
            ArrayList<ByteBuffer> immutableSections = new ArrayList<ByteBuffer>(3);
            mmd = new MessageMetaData_1_0(fragments.toArray(new ByteBuffer[fragments.size()]), (SectionDecoder)this._sectionDecoder, immutableSections);
            StoredMessage<MessageMetaData_1_0> storedMessage = this._vhost.getMessageStore().addMessage(mmd);
            boolean skipping = true;
            int offset = 0;
            for (ByteBuffer bareMessageBuf : immutableSections) {
                storedMessage.addContent(offset, bareMessageBuf.duplicate());
                offset += bareMessageBuf.remaining();
            }
            storedMessage.flushToStore();
            Message_1_0 message = new Message_1_0(storedMessage, fragments, this.getSession());
            Binary transactionId = null;
            DeliveryState xfrState = xfr.getState();
            if (xfrState != null && xfrState instanceof TransactionalState) {
                transactionId = ((TransactionalState)xfrState).getTxnId();
            }
            ServerTransaction transaction = null;
            transaction = transactionId != null ? this.getSession().getTransaction(transactionId) : ((session = this.getSession()) != null ? session.getTransaction(null) : new AutoCommitTransaction(this._vhost.getMessageStore()));
            Outcome outcome = this._destination.send(message, transaction);
            if (transactionId == null) {
                resultantState = (DeliveryState)outcome;
            } else {
                TransactionalState transactionalState = new TransactionalState();
                transactionalState.setOutcome(outcome);
                transactionalState.setTxnId(transactionId);
                resultantState = transactionalState;
            }
            boolean settled = transaction instanceof AutoCommitTransaction && ReceiverSettleMode.FIRST.equals(this.getReceivingSettlementMode());
            final Binary deliveryTag = xfr.getDeliveryTag();
            if (!settled) {
                this._unsettledMap.put(deliveryTag, outcome);
            }
            this.getEndpoint().updateDisposition(deliveryTag, resultantState, settled);
            this.getSession().getConnectionModel().registerMessageReceived(message.getSize(), message.getArrivalTime());
            if (!(transaction instanceof AutoCommitTransaction)) {
                transaction.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        ReceivingLink_1_0.this.getEndpoint().updateDisposition(deliveryTag, null, true);
                    }

                    public void onRollback() {
                        ReceivingLink_1_0.this.getEndpoint().updateDisposition(deliveryTag, null, true);
                    }
                });
            }
        }
    }

    private ReceiverSettleMode getReceivingSettlementMode() {
        return this._receivingSettlementMode;
    }

    public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
        if (!TerminusDurability.UNSETTLED_STATE.equals(this._durability) || detach != null && Boolean.TRUE.equals(detach.getClosed())) {
            endpoint.close();
        } else if (detach == null || detach.getError() != null) {
            this._attachment = null;
        }
    }

    public void start() {
        this.getEndpoint().setLinkCredit(UnsignedInteger.valueOf((int)this._destination.getCredit()));
        this.getEndpoint().setCreditWindow();
    }

    public ReceivingLinkEndpoint getEndpoint() {
        return this._attachment.getEndpoint();
    }

    public Session_1_0 getSession() {
        ReceivingLinkAttachment attachment = this._attachment;
        return attachment == null ? null : attachment.getSession();
    }

    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        if (Boolean.TRUE.equals(settled)) {
            this._unsettledMap.remove(deliveryTag);
        }
    }

    public void setLinkAttachment(ReceivingLinkAttachment linkAttachment) {
        this._attachment = linkAttachment;
        this._receivingSettlementMode = linkAttachment.getEndpoint().getReceivingSettlementMode();
        ReceivingLinkEndpoint endpoint = linkAttachment.getEndpoint();
        Map initialUnsettledMap = endpoint.getInitialUnsettledMap();
        HashMap<Binary, Outcome> unsettledCopy = new HashMap<Binary, Outcome>(this._unsettledMap);
        for (Map.Entry entry : unsettledCopy.entrySet()) {
            Binary deliveryTag = (Binary)entry.getKey();
            if (initialUnsettledMap.containsKey(deliveryTag)) continue;
            this._unsettledMap.remove(deliveryTag);
        }
    }

    public Map getUnsettledOutcomeMap() {
        return this._unsettledMap;
    }
}

