/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.AMQException;
import org.apache.qpid.amqp_1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.Modified;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;
import org.apache.qpid.amqp_1_0.type.messaging.Released;
import org.apache.qpid.amqp_1_0.type.messaging.Source;
import org.apache.qpid.amqp_1_0.type.messaging.StdDistMode;
import org.apache.qpid.amqp_1_0.type.transaction.TransactionalState;
import org.apache.qpid.amqp_1_0.type.transport.SenderSettleMode;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.message.AMQMessage;
import org.apache.qpid.server.message.MessageMetaData_1_0;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.QueueDestination;
import org.apache.qpid.server.protocol.v1_0.SendingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.UnsettledAction;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.typedmessage.TypedBytesContentReader;
import org.apache.qpid.typedmessage.TypedBytesFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Subscription_1_0
implements Subscription {
    private SendingLink_1_0 _link;
    private AMQQueue _queue;
    private final AtomicReference<Subscription.State> _state = new AtomicReference<Subscription.State>(Subscription.State.SUSPENDED);
    private final QueueEntry.SubscriptionAcquiredState _owningState = new QueueEntry.SubscriptionAcquiredState(this);
    private final long _id;
    private final boolean _acquires;
    private volatile AMQQueue.Context _queueContext;
    private Map<String, Object> _properties = new ConcurrentHashMap<String, Object>();
    private ReentrantLock _stateChangeLock = new ReentrantLock();
    private boolean _noLocal;
    private FilterManager _filters;
    private long _deliveryTag = 0L;
    private Subscription.StateListener _stateListener;
    private Binary _transactionId;
    private final AMQPDescribedTypeRegistry _typeRegistry = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();
    private SectionEncoder _sectionEncoder = new SectionEncoderImpl(this._typeRegistry);

    public Subscription_1_0(SendingLink_1_0 link, QueueDestination destination) {
        this(link, destination, ((Source)link.getEndpoint().getSource()).getDistributionMode() != StdDistMode.COPY);
    }

    public Subscription_1_0(SendingLink_1_0 link, QueueDestination destination, boolean acquires) {
        this._link = link;
        this._queue = destination.getQueue();
        this._id = this.getEndpoint().getLocalHandle().longValue();
        this._acquires = acquires;
    }

    private SendingLinkEndpoint getEndpoint() {
        return this._link.getEndpoint();
    }

    @Override
    public LogActor getLogActor() {
        return null;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    @Override
    public QueueEntry.SubscriptionAcquiredState getOwningState() {
        return this._owningState;
    }

    @Override
    public void setQueue(AMQQueue queue, boolean exclusive) {
    }

    @Override
    public void setNoLocal(boolean noLocal) {
        this._noLocal = noLocal;
    }

    @Override
    public long getSubscriptionID() {
        return this._id;
    }

    @Override
    public boolean isSuspended() {
        return !this.isActive();
    }

    @Override
    public boolean hasInterest(QueueEntry entry) {
        return (!this._noLocal || !(entry.getMessage() instanceof Message_1_0) || ((Message_1_0)entry.getMessage()).getSession() != this.getSession()) && this.checkFilters(entry);
    }

    private boolean checkFilters(QueueEntry entry) {
        return this._filters == null || this._filters.allAllow(entry);
    }

    @Override
    public boolean isClosed() {
        return !this.getEndpoint().isAttached();
    }

    @Override
    public boolean acquires() {
        return this._acquires;
    }

    @Override
    public boolean seesRequeues() {
        return this.acquires();
    }

    @Override
    public void close() {
        this.getEndpoint().detach();
    }

    @Override
    public void send(QueueEntry entry, boolean batch) throws AMQException {
        this.send(entry);
    }

    @Override
    public void flushBatched() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final QueueEntry queueEntry) throws AMQException {
        ByteBuffer payload;
        Message_1_0 message;
        ServerMessage serverMessage = queueEntry.getMessage();
        if (serverMessage instanceof Message_1_0) {
            message = (Message_1_0)serverMessage;
        } else if (serverMessage instanceof AMQMessage) {
            message = new Message_1_0(this.convert08Message((AMQMessage)serverMessage));
        } else if (serverMessage instanceof MessageTransferMessage) {
            message = new Message_1_0(this.convert010Message((MessageTransferMessage)serverMessage));
        } else {
            return;
        }
        Transfer transfer = new Transfer();
        List<ByteBuffer> fragments = message.getFragments();
        if (fragments.size() == 1) {
            payload = fragments.get(0);
        } else {
            int size = 0;
            for (ByteBuffer fragment : fragments) {
                size += fragment.remaining();
            }
            payload = ByteBuffer.allocate(size);
            for (ByteBuffer fragment : fragments) {
                payload.put(fragment.duplicate());
            }
            payload.flip();
        }
        if (queueEntry.getDeliveryCount() != 0) {
            payload = payload.duplicate();
            ValueHandler valueHandler = new ValueHandler((DescribedTypeConstructorRegistry)this._typeRegistry);
            Header oldHeader = null;
            try {
                ByteBuffer encodedBuf = payload.duplicate();
                Object value = valueHandler.parse(payload);
                if (value instanceof Header) {
                    oldHeader = (Header)value;
                } else {
                    payload.position(0);
                }
            }
            catch (AmqpErrorException e) {
                throw new RuntimeException(e);
            }
            Header header = new Header();
            if (oldHeader != null) {
                header.setDurable(oldHeader.getDurable());
                header.setPriority(oldHeader.getPriority());
                header.setTtl(oldHeader.getTtl());
            }
            header.setDeliveryCount(UnsignedInteger.valueOf((int)queueEntry.getDeliveryCount()));
            this._sectionEncoder.reset();
            this._sectionEncoder.encodeObject((Object)header);
            Binary encodedHeader = this._sectionEncoder.getEncoding();
            ByteBuffer oldPayload = payload;
            payload = ByteBuffer.allocate(oldPayload.remaining() + encodedHeader.getLength());
            payload.put(encodedHeader.getArray(), encodedHeader.getArrayOffset(), encodedHeader.getLength());
            payload.put(oldPayload);
            payload.flip();
        }
        transfer.setPayload(payload);
        byte[] data = new byte[8];
        ByteBuffer.wrap(data).putLong(this._deliveryTag++);
        final Binary tag = new Binary(data);
        transfer.setDeliveryTag(tag);
        Object object = this._link.getLock();
        synchronized (object) {
            if (this._link.isAttached()) {
                ServerTransaction txn;
                if (SenderSettleMode.SETTLED.equals(this.getEndpoint().getSendingSettlementMode())) {
                    transfer.setSettled(Boolean.valueOf(true));
                } else {
                    UnsettledAction action = this._acquires ? new DispositionAction(tag, queueEntry) : new DoNothingAction(tag, queueEntry);
                    this._link.addUnsettled(tag, action, queueEntry);
                }
                if (this._transactionId != null) {
                    TransactionalState state = new TransactionalState();
                    state.setTxnId(this._transactionId);
                    transfer.setState((DeliveryState)state);
                }
                if (this._acquires && this._transactionId != null && (txn = this._link.getTransaction(this._transactionId)) != null) {
                    txn.addPostTransactionAction(new ServerTransaction.Action(){

                        public void postCommit() {
                        }

                        public void onRollback() {
                            if (queueEntry.isAcquiredBy(Subscription_1_0.this)) {
                                queueEntry.release();
                                Subscription_1_0.this._link.getEndpoint().updateDisposition(tag, (DeliveryState)null, true);
                            }
                        }
                    });
                }
                this.getSession().getConnectionModel().registerMessageDelivered(message.getSize());
                this.getEndpoint().transfer(transfer);
            } else {
                queueEntry.release();
            }
        }
    }

    private StoredMessage<MessageMetaData_1_0> convert010Message(MessageTransferMessage serverMessage) {
        MessageMetaData_1_0 metaData = this.convertMetaData(serverMessage);
        return this.convertServerMessage(metaData, serverMessage);
    }

    private MessageMetaData_1_0 convertMetaData(MessageTransferMessage serverMessage) {
        ArrayList<Section> sections = new ArrayList<Section>(3);
        MessageProperties msgProps = serverMessage.getHeader().getMessageProperties();
        DeliveryProperties deliveryProps = serverMessage.getHeader().getDeliveryProperties();
        Header header = new Header();
        if (deliveryProps != null) {
            header.setDurable(Boolean.valueOf(deliveryProps.hasDeliveryMode() && deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT));
            if (deliveryProps.hasPriority()) {
                header.setPriority(UnsignedByte.valueOf((byte)((byte)deliveryProps.getPriority().getValue())));
            }
            if (deliveryProps.hasTtl()) {
                header.setTtl(UnsignedInteger.valueOf((long)deliveryProps.getTtl()));
            }
            sections.add((Section)header);
        }
        Properties props = new Properties();
        if (msgProps != null) {
            if (msgProps.hasContentEncoding()) {
                props.setContentEncoding(Symbol.valueOf((String)msgProps.getContentEncoding()));
            }
            if (msgProps.hasCorrelationId()) {
                props.setCorrelationId((Object)msgProps.getCorrelationId());
            }
            if (msgProps.hasMessageId()) {
                props.setMessageId((Object)msgProps.getMessageId());
            }
            if (msgProps.hasReplyTo()) {
                props.setReplyTo(msgProps.getReplyTo().getExchange() + "/" + msgProps.getReplyTo().getRoutingKey());
            }
            if (msgProps.hasContentType()) {
                props.setContentType(Symbol.valueOf((String)msgProps.getContentType()));
                if (props.getContentType() == Symbol.valueOf((String)"application/java-object-stream")) {
                    props.setContentType(Symbol.valueOf((String)"application/x-java-serialized-object"));
                }
            }
            props.setSubject(serverMessage.getRoutingKey());
            if (msgProps.hasUserId()) {
                props.setUserId(new Binary(msgProps.getUserId()));
            }
            sections.add((Section)props);
            if (msgProps.getApplicationHeaders() != null) {
                sections.add((Section)new ApplicationProperties(msgProps.getApplicationHeaders()));
            }
        }
        return new MessageMetaData_1_0(sections, this._sectionEncoder);
    }

    private StoredMessage<MessageMetaData_1_0> convert08Message(AMQMessage serverMessage) {
        MessageMetaData_1_0 metaData = this.convertMetaData(serverMessage);
        return this.convertServerMessage(metaData, serverMessage);
    }

    private StoredMessage<MessageMetaData_1_0> convertServerMessage(final MessageMetaData_1_0 metaData, final ServerMessage serverMessage) {
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        serverMessage.getContent(ByteBuffer.wrap(data), 0);
        Section bodySection = Subscription_1_0.convertMessageBody(mimeType, data);
        final ByteBuffer allData = this.encodeConvertedMessage(metaData, bodySection);
        return new StoredMessage<MessageMetaData_1_0>(){

            @Override
            public MessageMetaData_1_0 getMetaData() {
                return metaData;
            }

            @Override
            public long getMessageNumber() {
                return serverMessage.getMessageNumber();
            }

            @Override
            public void addContent(int offsetInMessage, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getContent(int offsetInMessage, ByteBuffer dst) {
                int size;
                ByteBuffer buf = allData.duplicate();
                buf.position(offsetInMessage);
                buf = buf.slice();
                if (dst.remaining() < buf.remaining()) {
                    buf.limit(dst.remaining());
                    size = dst.remaining();
                } else {
                    size = buf.remaining();
                }
                dst.put(buf);
                return size;
            }

            @Override
            public ByteBuffer getContent(int offsetInMessage, int size) {
                ByteBuffer buf = allData.duplicate();
                buf.position(offsetInMessage);
                buf = buf.slice();
                if (size < buf.remaining()) {
                    buf.limit(size);
                }
                return buf;
            }

            @Override
            public StoreFuture flushToStore() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                serverMessage.getStoredMessage().remove();
            }
        };
    }

    private ByteBuffer encodeConvertedMessage(MessageMetaData_1_0 metaData, Section bodySection) {
        int headerSize = metaData.getStorableSize();
        this._sectionEncoder.reset();
        this._sectionEncoder.encodeObject((Object)bodySection);
        Binary dataEncoding = this._sectionEncoder.getEncoding();
        ByteBuffer allData = ByteBuffer.allocate(headerSize + dataEncoding.getLength());
        metaData.writeToBuffer(0, allData);
        allData.put(dataEncoding.getArray(), dataEncoding.getArrayOffset(), dataEncoding.getLength());
        return allData;
    }

    private static Section convertMessageBody(String mimeType, byte[] data) {
        if ("text/plain".equals(mimeType) || "text/xml".equals(mimeType)) {
            String text = new String(data);
            return new AmqpValue((Object)text);
        }
        if ("jms/map-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int entries = reader.readIntImpl();
            for (int i = 0; i < entries; ++i) {
                try {
                    String propName = reader.readStringImpl();
                    Object value = reader.readObject();
                    map.put(propName, value);
                    continue;
                }
                catch (EOFException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (TypedBytesFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return new AmqpValue(map);
        }
        if ("amqp/map".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return new AmqpValue((Object)decoder.readMap());
        }
        if ("amqp/list".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return new AmqpValue((Object)decoder.readList());
        }
        if ("jms/stream-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            ArrayList<Object> list = new ArrayList<Object>();
            while (reader.remaining() != 0) {
                try {
                    list.add(reader.readObject());
                }
                catch (TypedBytesFormatException e) {
                    throw new RuntimeException(e);
                }
                catch (EOFException e) {
                    throw new RuntimeException(e);
                }
            }
            return new AmqpValue(list);
        }
        return new Data(new Binary(data));
    }

    private MessageMetaData_1_0 convertMetaData(AMQMessage serverMessage) {
        AMQShortString messageId;
        AMQShortString correlationId;
        ArrayList<Section> sections = new ArrayList<Section>(3);
        Header header = new Header();
        header.setDurable(Boolean.valueOf(serverMessage.isPersistent()));
        BasicContentHeaderProperties contentHeader = (BasicContentHeaderProperties)serverMessage.getContentHeaderBody().getProperties();
        header.setPriority(UnsignedByte.valueOf((byte)contentHeader.getPriority()));
        long expiration = serverMessage.getExpiration();
        long arrivalTime = serverMessage.getArrivalTime();
        if (expiration > arrivalTime) {
            header.setTtl(UnsignedInteger.valueOf((long)(expiration - arrivalTime)));
        }
        sections.add((Section)header);
        Properties props = new Properties();
        props.setContentEncoding(Symbol.valueOf((String)contentHeader.getEncodingAsString()));
        props.setContentType(Symbol.valueOf((String)contentHeader.getContentTypeAsString()));
        if (props.getContentType() == Symbol.valueOf((String)"application/java-object-stream")) {
            props.setContentType(Symbol.valueOf((String)"application/x-java-serialized-object"));
        }
        if ((correlationId = contentHeader.getCorrelationId()) != null) {
            props.setCorrelationId((Object)new Binary(correlationId.getBytes()));
        }
        if ((messageId = contentHeader.getMessageId()) != null) {
            props.setMessageId((Object)new Binary(messageId.getBytes()));
        }
        props.setReplyTo(String.valueOf(contentHeader.getReplyTo()));
        props.setSubject(serverMessage.getRoutingKey());
        if (contentHeader.getUserId() != null) {
            props.setUserId(new Binary(contentHeader.getUserId().getBytes()));
        }
        sections.add((Section)props);
        sections.add((Section)new ApplicationProperties(FieldTable.convertToMap((FieldTable)contentHeader.getHeaders())));
        return new MessageMetaData_1_0(sections, this._sectionEncoder);
    }

    @Override
    public void queueDeleted(AMQQueue queue) {
        this.getEndpoint().setSource(null);
        this.getEndpoint().detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wouldSuspend(QueueEntry msg) {
        Object object = this._link.getLock();
        synchronized (object) {
            boolean hasCredit;
            boolean bl = hasCredit = this._link.isAttached() && this.getEndpoint().hasCreditToSend();
            if (!hasCredit && this.getState() == Subscription.State.ACTIVE) {
                this.suspend();
            }
            return !hasCredit;
        }
    }

    @Override
    public boolean trySendLock() {
        return this._stateChangeLock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this._link.getLock();
        synchronized (object) {
            if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
                this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
            }
        }
    }

    @Override
    public void getSendLock() {
        this._stateChangeLock.lock();
    }

    @Override
    public void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    @Override
    public void releaseQueueEntry(QueueEntry queueEntryImpl) {
    }

    @Override
    public void onDequeue(QueueEntry queueEntry) {
    }

    @Override
    public void restoreCredit(QueueEntry queueEntry) {
    }

    @Override
    public void setStateListener(Subscription.StateListener listener) {
        this._stateListener = listener;
    }

    @Override
    public Subscription.State getState() {
        return this._state.get();
    }

    @Override
    public AMQQueue.Context getQueueContext() {
        return this._queueContext;
    }

    @Override
    public void setQueueContext(AMQQueue.Context queueContext) {
        this._queueContext = queueContext;
    }

    @Override
    public boolean isActive() {
        return this.getState() == Subscription.State.ACTIVE;
    }

    @Override
    public void set(String key, Object value) {
        this._properties.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this._properties.get(key);
    }

    @Override
    public boolean isSessionTransactional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueEmpty() {
        Object object = this._link.getLock();
        synchronized (object) {
            if (this._link.drained() && this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
                this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flowStateChanged() {
        Object object = this._link.getLock();
        synchronized (object) {
            if (this.isSuspended() && this.getEndpoint() != null) {
                if (this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
                    this._stateListener.stateChange(this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
                }
                this._transactionId = this._link.getTransactionId();
            }
        }
    }

    public Session_1_0 getSession() {
        return this._link.getSession();
    }

    public FilterManager getFilters() {
        return this._filters;
    }

    public void setFilters(FilterManager filters) {
        this._filters = filters;
    }

    @Override
    public AMQSessionModel getSessionModel() {
        return this.getSession();
    }

    @Override
    public long getBytesOut() {
        return 0L;
    }

    @Override
    public long getMessagesOut() {
        return 0L;
    }

    @Override
    public long getUnacknowledgedBytes() {
        return 0L;
    }

    @Override
    public long getUnacknowledgedMessages() {
        return 0L;
    }

    @Override
    public String getConsumerName() {
        return "TODO";
    }

    private class DoNothingAction
    implements UnsettledAction {
        public DoNothingAction(Binary tag, QueueEntry queueEntry) {
        }

        public boolean process(DeliveryState state, Boolean settled) {
            Binary transactionId = null;
            Outcome outcome = null;
            if (state instanceof TransactionalState) {
                transactionId = ((TransactionalState)state).getTxnId();
                outcome = ((TransactionalState)state).getOutcome();
            } else if (state instanceof Outcome) {
                outcome = (Outcome)state;
            }
            return true;
        }
    }

    private class DispositionAction
    implements UnsettledAction {
        private final QueueEntry _queueEntry;
        private final Binary _deliveryTag;

        public DispositionAction(Binary tag, QueueEntry queueEntry) {
            this._deliveryTag = tag;
            this._queueEntry = queueEntry;
        }

        public boolean process(DeliveryState state, final Boolean settled) {
            Outcome outcome;
            Binary transactionId = null;
            if (state instanceof TransactionalState) {
                transactionId = ((TransactionalState)state).getTxnId();
                outcome = ((TransactionalState)state).getOutcome();
            } else {
                outcome = state instanceof Outcome ? (Outcome)state : null;
            }
            ServerTransaction txn = Subscription_1_0.this._link.getTransaction(transactionId);
            if (outcome instanceof Accepted) {
                txn.dequeue(this._queueEntry.getQueue(), this._queueEntry.getMessage(), new ServerTransaction.Action(){

                    public void postCommit() {
                        if (DispositionAction.this._queueEntry.isAcquiredBy(Subscription_1_0.this)) {
                            DispositionAction.this._queueEntry.discard();
                        }
                    }

                    public void onRollback() {
                    }
                });
                txn.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        Subscription_1_0.this._link.getEndpoint().updateDisposition(DispositionAction.this._deliveryTag, (DeliveryState)outcome, true);
                        Subscription_1_0.this._link.getEndpoint().sendFlowConditional();
                    }

                    public void onRollback() {
                        if (Boolean.TRUE.equals(settled)) {
                            Modified modified = new Modified();
                            modified.setDeliveryFailed(Boolean.valueOf(true));
                            Subscription_1_0.this._link.getEndpoint().updateDisposition(DispositionAction.this._deliveryTag, (DeliveryState)modified, true);
                            Subscription_1_0.this._link.getEndpoint().sendFlowConditional();
                        }
                    }
                });
            } else if (outcome instanceof Released) {
                txn.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        DispositionAction.this._queueEntry.release();
                        Subscription_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                    }

                    public void onRollback() {
                        Subscription_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                    }
                });
            } else if (outcome instanceof Modified) {
                txn.addPostTransactionAction(new ServerTransaction.Action(){

                    public void postCommit() {
                        DispositionAction.this._queueEntry.release();
                        if (Boolean.TRUE.equals(((Modified)outcome).getDeliveryFailed())) {
                            DispositionAction.this._queueEntry.incrementDeliveryCount();
                        }
                        Subscription_1_0.this._link.getEndpoint().settle(DispositionAction.this._deliveryTag);
                    }

                    public void onRollback() {
                        if (Boolean.TRUE.equals(settled)) {
                            Modified modified = new Modified();
                            modified.setDeliveryFailed(Boolean.valueOf(true));
                            Subscription_1_0.this._link.getEndpoint().updateDisposition(DispositionAction.this._deliveryTag, (DeliveryState)modified, true);
                            Subscription_1_0.this._link.getEndpoint().sendFlowConditional();
                        }
                    }
                });
            }
            return transactionId == null && outcome != null;
        }
    }
}

