/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.InboundMessageAdapter;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueEntryImpl
implements QueueEntry {
    private static final Logger _log = Logger.getLogger(QueueEntryImpl.class);
    private final QueueEntryList _queueEntryList;
    private MessageReference _message;
    private Set<Long> _rejectedBy = null;
    private volatile QueueEntry.EntryState _state = AVAILABLE_STATE;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, QueueEntry.EntryState> _stateUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, QueueEntry.EntryState.class, "_state");
    private volatile Set<QueueEntry.StateChangeListener> _stateChangeListeners;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, Set> _listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, Set.class, "_stateChangeListeners");
    private static final AtomicLongFieldUpdater<QueueEntryImpl> _entryIdUpdater = AtomicLongFieldUpdater.newUpdater(QueueEntryImpl.class, "_entryId");
    private volatile long _entryId;
    private static final int DELIVERED_TO_CONSUMER = 1;
    private static final int REDELIVERED = 2;
    private volatile int _deliveryState;
    private volatile int _deliveryCount = 0;
    private static final AtomicIntegerFieldUpdater<QueueEntryImpl> _deliveryCountUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueEntryImpl.class, "_deliveryCount");

    public QueueEntryImpl(QueueEntryList<?> queueEntryList) {
        this(queueEntryList, null, Long.MIN_VALUE);
        this._state = DELETED_STATE;
    }

    public QueueEntryImpl(QueueEntryList<?> queueEntryList, ServerMessage message, long entryId) {
        this._queueEntryList = queueEntryList;
        this._message = message == null ? null : message.newReference();
        _entryIdUpdater.set(this, entryId);
    }

    public QueueEntryImpl(QueueEntryList<?> queueEntryList, ServerMessage message) {
        this._queueEntryList = queueEntryList;
        this._message = message == null ? null : message.newReference();
    }

    protected void setEntryId(long entryId) {
        _entryIdUpdater.set(this, entryId);
    }

    protected long getEntryId() {
        return this._entryId;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queueEntryList.getQueue();
    }

    @Override
    public ServerMessage getMessage() {
        return this._message == null ? null : (ServerMessage)this._message.getMessage();
    }

    @Override
    public long getSize() {
        return this.getMessage() == null ? 0L : this.getMessage().getSize();
    }

    @Override
    public boolean getDeliveredToConsumer() {
        return (this._deliveryState & 1) != 0;
    }

    @Override
    public boolean expired() throws AMQException {
        long expiration;
        ServerMessage message = this.getMessage();
        if (message != null && (expiration = message.getExpiration()) != 0L) {
            long now = System.currentTimeMillis();
            return now > expiration;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this._state == AVAILABLE_STATE;
    }

    @Override
    public boolean isAcquired() {
        return this._state.getState() == QueueEntry.State.ACQUIRED;
    }

    @Override
    public boolean acquire() {
        return this.acquire(NON_SUBSCRIPTION_ACQUIRED_STATE);
    }

    private boolean acquire(QueueEntry.EntryState state) {
        boolean acquired = _stateUpdater.compareAndSet(this, AVAILABLE_STATE, state);
        if (acquired && this._stateChangeListeners != null) {
            this.notifyStateChange(QueueEntry.State.AVAILABLE, QueueEntry.State.ACQUIRED);
        }
        return acquired;
    }

    @Override
    public boolean acquire(Subscription sub) {
        boolean acquired = this.acquire(sub.getOwningState());
        if (acquired) {
            this._deliveryState |= 1;
        }
        return acquired;
    }

    @Override
    public boolean acquiredBySubscription() {
        return this._state instanceof QueueEntry.SubscriptionAcquiredState;
    }

    @Override
    public boolean isAcquiredBy(Subscription subscription) {
        QueueEntry.EntryState state = this._state;
        return state instanceof QueueEntry.SubscriptionAcquiredState && ((QueueEntry.SubscriptionAcquiredState)state).getSubscription() == subscription;
    }

    @Override
    public void release() {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, AVAILABLE_STATE)) {
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                this.getQueue().decrementUnackedMsgCount(this);
                Subscription subscription = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
                if (subscription != null) {
                    subscription.releaseQueueEntry(this);
                }
            }
            if (!this.getQueue().isDeleted()) {
                this.getQueue().requeue(this);
                if (this._stateChangeListeners != null) {
                    this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
                }
            } else if (this.acquire()) {
                this.routeToAlternate();
            }
        }
    }

    @Override
    public void setRedelivered() {
        this._deliveryState |= 2;
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        ServerMessage message = this.getMessage();
        return message == null ? null : message.getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        ServerMessage message = this.getMessage();
        return message != null && message.isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return (this._deliveryState & 2) != 0;
    }

    @Override
    public Subscription getDeliveredSubscription() {
        QueueEntry.EntryState state = this._state;
        if (state instanceof QueueEntry.SubscriptionAcquiredState) {
            return ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
        }
        return null;
    }

    @Override
    public void reject() {
        Subscription subscription = this.getDeliveredSubscription();
        if (subscription != null) {
            if (this._rejectedBy == null) {
                this._rejectedBy = new HashSet<Long>();
            }
            this._rejectedBy.add(subscription.getSubscriptionID());
        } else {
            _log.warn((Object)("Requesting rejection by null subscriber:" + this));
        }
    }

    @Override
    public boolean isRejectedBy(long subscriptionId) {
        if (this._rejectedBy != null) {
            return this._rejectedBy.contains(subscriptionId);
        }
        return false;
    }

    @Override
    public void dequeue() {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, DEQUEUED_STATE)) {
            Subscription s = null;
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                this.getQueue().decrementUnackedMsgCount(this);
                s = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
                s.onDequeue(this);
            }
            this.getQueue().dequeue(this, s);
            if (this._stateChangeListeners != null) {
                this.notifyStateChange(state.getState(), QueueEntry.State.DEQUEUED);
            }
        }
    }

    private void notifyStateChange(QueueEntry.State oldState, QueueEntry.State newState) {
        for (QueueEntry.StateChangeListener l : this._stateChangeListeners) {
            l.stateChanged(this, oldState, newState);
        }
    }

    @Override
    public void dispose() {
        if (this.delete()) {
            this._message.release();
        }
    }

    @Override
    public void discard() {
        if (this.getQueue() != null) {
            this.dequeue();
        }
        this.dispose();
    }

    @Override
    public void routeToAlternate() {
        AMQQueue currentQueue = this.getQueue();
        Exchange alternateExchange = currentQueue.getAlternateExchange();
        if (alternateExchange != null) {
            InboundMessageAdapter inboundMessageAdapter = new InboundMessageAdapter(this);
            List<? extends BaseQueue> queues = alternateExchange.route(inboundMessageAdapter);
            final ServerMessage message = this.getMessage();
            if ((queues == null || queues.size() == 0) && alternateExchange.getAlternateExchange() != null) {
                queues = alternateExchange.getAlternateExchange().route(inboundMessageAdapter);
            }
            if (queues != null && queues.size() != 0) {
                final List<? extends BaseQueue> rerouteQueues = queues;
                LocalTransaction txn = new LocalTransaction(this.getQueue().getVirtualHost().getMessageStore());
                txn.enqueue(rerouteQueues, (EnqueableMessage)message, new ServerTransaction.Action(){

                    public void postCommit() {
                        try {
                            for (BaseQueue queue : rerouteQueues) {
                                queue.enqueue(message);
                            }
                        }
                        catch (AMQException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void onRollback() {
                    }
                });
                txn.dequeue(currentQueue, message, new ServerTransaction.Action(){

                    public void postCommit() {
                        QueueEntryImpl.this.discard();
                    }

                    public void onRollback() {
                    }
                });
                txn.commit();
            }
        }
    }

    @Override
    public boolean isQueueDeleted() {
        return this.getQueue().isDeleted();
    }

    @Override
    public void addStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners == null) {
            _listenersUpdater.compareAndSet(this, null, new CopyOnWriteArraySet());
            listeners = this._stateChangeListeners;
        }
        listeners.add(listener);
    }

    @Override
    public boolean removeStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    @Override
    public int compareTo(QueueEntry o) {
        QueueEntryImpl other = (QueueEntryImpl)o;
        return this.getEntryId() > other.getEntryId() ? 1 : (this.getEntryId() < other.getEntryId() ? -1 : 0);
    }

    @Override
    public boolean isDeleted() {
        return this._state == DELETED_STATE;
    }

    @Override
    public boolean delete() {
        QueueEntry.EntryState state = this._state;
        if (state != DELETED_STATE && _stateUpdater.compareAndSet(this, state, DELETED_STATE)) {
            this._queueEntryList.entryDeleted(this);
            return true;
        }
        return false;
    }

    public QueueEntryList getQueueEntryList() {
        return this._queueEntryList;
    }

    @Override
    public boolean isDequeued() {
        return this._state == DEQUEUED_STATE;
    }

    @Override
    public boolean isDispensed() {
        return this._state.isDispensed();
    }

    @Override
    public int getDeliveryCount() {
        return this._deliveryCount;
    }

    @Override
    public void incrementDeliveryCount() {
        _deliveryCountUpdater.incrementAndGet(this);
    }

    @Override
    public void decrementDeliveryCount() {
        _deliveryCountUpdater.decrementAndGet(this);
    }

    public String toString() {
        return "QueueEntryImpl{_entryId=" + this._entryId + ", _state=" + this._state + '}';
    }
}

