/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.ConfigurationEntryStore;
import org.apache.qpid.server.configuration.ConfiguredObjectRecoverer;
import org.apache.qpid.server.configuration.startup.DefaultRecovererProvider;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.logging.CompositeStartupMessageLogger;
import org.apache.qpid.server.logging.Log4jMessageLogger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.GenericActor;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

public class ApplicationRegistry
implements IApplicationRegistry {
    private static final Logger _logger = Logger.getLogger(ApplicationRegistry.class);
    private final VirtualHostRegistry _virtualHostRegistry = new VirtualHostRegistry();
    private volatile RootMessageLogger _rootMessageLogger;
    private Broker _broker;
    private Timer _reportingTimer;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private LogRecorder _logRecorder;
    private ConfigurationEntryStore _store;
    private TaskExecutor _taskExecutor;

    protected void setRootMessageLogger(RootMessageLogger rootMessageLogger) {
        this._rootMessageLogger = rootMessageLogger;
    }

    public ApplicationRegistry(ConfigurationEntryStore store) {
        this._store = store;
        this.initialiseStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise(BrokerOptions brokerOptions) throws Exception {
        boolean statusUpdatesEnabled = Boolean.parseBoolean(System.getProperty("qpid.broker_status_updates", "true"));
        this._rootMessageLogger = new Log4jMessageLogger(statusUpdatesEnabled);
        this._logRecorder = new LogRecorder();
        RootMessageLogger[] messageLoggers = new RootMessageLogger[]{new SystemOutMessageLogger(), this._rootMessageLogger};
        CompositeStartupMessageLogger startupMessageLogger = new CompositeStartupMessageLogger(messageLoggers);
        BrokerActor actor = new BrokerActor(startupMessageLogger);
        CurrentActor.set(actor);
        CurrentActor.setDefault(actor);
        GenericActor.setDefaultMessageLogger(this._rootMessageLogger);
        try {
            this.logStartupMessages(CurrentActor.get());
            this._taskExecutor = new TaskExecutor();
            this._taskExecutor.start();
            DefaultRecovererProvider provider = new DefaultRecovererProvider(this, this._virtualHostRegistry, this._logRecorder, this._rootMessageLogger, this._taskExecutor, brokerOptions);
            ConfiguredObjectRecoverer<? extends ConfiguredObject> brokerRecoverer = provider.getRecoverer(Broker.class.getSimpleName());
            this._broker = (Broker)brokerRecoverer.create(provider, this._store.getRootEntry(), new ConfiguredObject[0]);
            this._virtualHostRegistry.setDefaultVirtualHostName((String)this._broker.getAttribute("defaultVirtualHost"));
            this.initialiseStatisticsReporting();
            this._broker.setDesiredState(State.INITIALISING, State.ACTIVE);
            CurrentActor.get().message(BrokerMessages.READY());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            CurrentActor.remove();
            throw throwable;
        }
        CurrentActor.remove();
        CurrentActor.setDefault(new BrokerActor(this._rootMessageLogger));
    }

    private void initialiseStatisticsReporting() {
        long report = ((Number)this._broker.getAttribute("statisticsReportingPeriod")).intValue() * 1000;
        boolean reset = (Boolean)this._broker.getAttribute("statisticsReportingResetEnabled");
        if (report > 0L) {
            this._reportingTimer = new Timer("Statistics-Reporting", true);
            StatisticsReportingTask task = new StatisticsReportingTask(reset, this._rootMessageLogger);
            this._reportingTimer.scheduleAtFixedRate((TimerTask)task, report / 2L, report);
        }
    }

    private void close(Closeable close) {
        try {
            if (close != null) {
                close.close();
            }
        }
        catch (Throwable e) {
            _logger.error((Object)("Error thrown whilst closing " + close.getClass().getSimpleName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Shutting down ApplicationRegistry:" + this));
        }
        CurrentActor.set(new BrokerActor(this._rootMessageLogger));
        try {
            if (this._reportingTimer != null) {
                this._reportingTimer.cancel();
            }
            if (this._broker != null) {
                this._broker.setDesiredState(this._broker.getActualState(), State.STOPPED);
            }
            this.close(this._virtualHostRegistry);
            if (this._taskExecutor != null) {
                this._taskExecutor.stop();
            }
            CurrentActor.get().message(BrokerMessages.STOPPED());
            this._logRecorder.closeLogRecorder();
            Object var2_1 = null;
            if (this._taskExecutor != null) {
                this._taskExecutor.stopImmediately();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this._taskExecutor != null) {
                this._taskExecutor.stopImmediately();
            }
            CurrentActor.remove();
            throw throwable;
        }
        CurrentActor.remove();
        this._store = null;
        this._broker = null;
    }

    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
    }

    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
    }

    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (VirtualHost vhost : this._virtualHostRegistry.getVirtualHosts()) {
            vhost.resetStatistics();
        }
    }

    public void initialiseStatistics() {
        this._messagesDelivered = new StatisticsCounter("messages-delivered");
        this._dataDelivered = new StatisticsCounter("bytes-delivered");
        this._messagesReceived = new StatisticsCounter("messages-received");
        this._dataReceived = new StatisticsCounter("bytes-received");
    }

    private void logStartupMessages(LogActor logActor) {
        logActor.message(BrokerMessages.STARTUP(QpidProperties.getReleaseVersion(), QpidProperties.getBuildVersion()));
        logActor.message(BrokerMessages.PLATFORM(System.getProperty("java.vendor"), System.getProperty("java.runtime.version", System.getProperty("java.version")), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
        logActor.message(BrokerMessages.MAX_MEMORY(Runtime.getRuntime().maxMemory()));
    }

    public Broker getBroker() {
        return this._broker;
    }

    private class StatisticsReportingTask
    extends TimerTask {
        private final int DELIVERED = 0;
        private final int RECEIVED = 1;
        private final boolean _reset;
        private final RootMessageLogger _logger;

        public StatisticsReportingTask(boolean reset, RootMessageLogger logger) {
            this._reset = reset;
            this._logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CurrentActor.set(new AbstractActor(this._logger){

                public String getLogMessage() {
                    return "[" + Thread.currentThread().getName() + "] ";
                }
            });
            try {
                block6: {
                    try {
                        CurrentActor.get().message(BrokerMessages.STATS_DATA(0, ApplicationRegistry.this._dataDelivered.getPeak() / 1024.0, ApplicationRegistry.this._dataDelivered.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_MSGS(0, ApplicationRegistry.this._messagesDelivered.getPeak(), ApplicationRegistry.this._messagesDelivered.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_DATA(1, ApplicationRegistry.this._dataReceived.getPeak() / 1024.0, ApplicationRegistry.this._dataReceived.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_MSGS(1, ApplicationRegistry.this._messagesReceived.getPeak(), ApplicationRegistry.this._messagesReceived.getTotal()));
                        Collection<VirtualHost> hosts = ApplicationRegistry.this._virtualHostRegistry.getVirtualHosts();
                        if (hosts.size() > 1) {
                            for (VirtualHost vhost : hosts) {
                                String name = vhost.getName();
                                StatisticsCounter dataDelivered = vhost.getDataDeliveryStatistics();
                                StatisticsCounter messagesDelivered = vhost.getMessageDeliveryStatistics();
                                StatisticsCounter dataReceived = vhost.getDataReceiptStatistics();
                                StatisticsCounter messagesReceived = vhost.getMessageReceiptStatistics();
                                CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 0, dataDelivered.getPeak() / 1024.0, dataDelivered.getTotal()));
                                CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 0, messagesDelivered.getPeak(), messagesDelivered.getTotal()));
                                CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 1, dataReceived.getPeak() / 1024.0, dataReceived.getTotal()));
                                CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 1, messagesReceived.getPeak(), messagesReceived.getTotal()));
                            }
                        }
                        if (!this._reset) break block6;
                        ApplicationRegistry.this.resetStatistics();
                    }
                    catch (Exception e) {
                        _logger.warn((Object)"Unexpected exception occured while reporting the statistics", (Throwable)e);
                        Object var10_11 = null;
                        CurrentActor.remove();
                        return;
                    }
                }
                Object var10_10 = null;
                CurrentActor.remove();
                return;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                CurrentActor.remove();
                throw throwable;
            }
        }
    }
}

