/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.PlainUser;
import org.apache.qpid.server.security.auth.sasl.amqplain.AmqPlainInitialiser;
import org.apache.qpid.server.security.auth.sasl.amqplain.AmqPlainSaslServer;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5Initialiser;
import org.apache.qpid.server.security.auth.sasl.plain.PlainInitialiser;
import org.apache.qpid.server.security.auth.sasl.plain.PlainSaslServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainPasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<PlainUser> {
    private final Logger _logger = Logger.getLogger(PlainPasswordFilePrincipalDatabase.class);
    private final Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();
    private String _mechanismsString;

    public PlainPasswordFilePrincipalDatabase() {
        AmqPlainInitialiser amqPlainInitialiser = new AmqPlainInitialiser();
        amqPlainInitialiser.initialise(this);
        this._callbackHandlerMap.put("AMQPLAIN", amqPlainInitialiser.getCallbackHandler());
        PlainInitialiser plainInitialiser = new PlainInitialiser();
        plainInitialiser.initialise(this);
        this._callbackHandlerMap.put("PLAIN", plainInitialiser.getCallbackHandler());
        CRAMMD5Initialiser crammd5Initialiser = new CRAMMD5Initialiser();
        crammd5Initialiser.initialise(this);
        this._callbackHandlerMap.put("CRAM-MD5", crammd5Initialiser.getCallbackHandler());
        this._mechanismsString = "AMQPLAIN PLAIN CRAM-MD5";
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specfied users password");
        }
        return this.compareCharArray(pwd, password);
    }

    @Override
    protected PlainUser createUserFromPassword(Principal principal, char[] passwd) {
        return new PlainUser(principal.getName(), passwd);
    }

    @Override
    protected PlainUser createUserFromFileData(String[] result) {
        return new PlainUser(result);
    }

    @Override
    protected Logger getLogger() {
        return this._logger;
    }

    @Override
    public String getMechanisms() {
        return this._mechanismsString;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        CallbackHandler callbackHandler = this._callbackHandlerMap.get(mechanism);
        if (callbackHandler == null) {
            throw new SaslException("Unsupported mechanism: " + mechanism);
        }
        if ("CRAM-MD5".equals(mechanism)) {
            return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, null, callbackHandler);
        }
        if ("PLAIN".equals(mechanism)) {
            return new PlainSaslServer(callbackHandler);
        }
        if ("AMQPLAIN".equals(mechanism)) {
            return new AmqPlainSaslServer(callbackHandler);
        }
        throw new SaslException("Unsupported mechanism: " + mechanism);
    }
}

