/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrincipalDatabaseAuthManagerFactory
implements AuthenticationManagerFactory {
    public static final String RESOURCE_BUNDLE = "org.apache.qpid.server.security.auth.manager.PasswordFileAuthenticationProviderAttributeDescriptions";
    public static final String ATTRIBUTE_PATH = "path";
    private static final Logger LOGGER = Logger.getLogger(AbstractPrincipalDatabaseAuthManagerFactory.class);
    public static final Collection<String> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("type", "path"));

    @Override
    public AuthenticationManager createInstance(Map<String, Object> attributes) {
        if (attributes == null || !this.getType().equals(attributes.get("type"))) {
            return null;
        }
        String passwordFile = (String)attributes.get(ATTRIBUTE_PATH);
        if (passwordFile == null) {
            LOGGER.warn((Object)"Password file path must not be null");
            return null;
        }
        PrincipalDatabase principalDatabase = this.createPrincipalDatabase();
        return new PrincipalDatabaseAuthenticationManager(principalDatabase, passwordFile);
    }

    abstract PrincipalDatabase createPrincipalDatabase();

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTES;
    }
}

