/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;
import org.apache.qpid.server.util.ResourceBundleLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalAuthenticationManagerFactory
implements AuthenticationManagerFactory {
    public static final String RESOURCE_BUNDLE = "org.apache.qpid.server.security.auth.manager.ExternalAuthenticationProviderAttributeDescriptions";
    public static final String PROVIDER_TYPE = "External";
    public static final String ATTRIBUTE_USE_FULL_DN = "useFullDN";
    public static final Collection<String> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("type", "useFullDN"));

    @Override
    public AuthenticationManager createInstance(Map<String, Object> attributes) {
        if (attributes != null && PROVIDER_TYPE.equals(attributes.get("type"))) {
            boolean useFullDN = Boolean.valueOf(String.valueOf(attributes.get(ATTRIBUTE_USE_FULL_DN)));
            return new ExternalAuthenticationManager(useFullDN);
        }
        return null;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTES;
    }

    @Override
    public String getType() {
        return PROVIDER_TYPE;
    }

    @Override
    public Map<String, String> getAttributeDescriptions() {
        return ResourceBundleLoader.getResources(RESOURCE_BUNDLE);
    }
}

