/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;

public class PrincipalDatabaseAuthenticationManager
implements AuthenticationManager {
    private final PrincipalDatabase _principalDatabase;
    private final String _passwordFile;

    public PrincipalDatabaseAuthenticationManager(PrincipalDatabase pd, String passwordFile) {
        this._principalDatabase = pd;
        this._passwordFile = passwordFile;
    }

    public void initialise() {
        try {
            this._principalDatabase.open(new File(this._passwordFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalConfigurationException("Exception opening password database: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot use password database at :" + this._passwordFile, e);
        }
    }

    public String getMechanisms() {
        return this._principalDatabase.getMechanisms();
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        return this._principalDatabase.createSaslServer(mechanism, localFQDN, externalPrincipal);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                String userId = server.getAuthorizationID();
                return new AuthenticationResult(new UsernamePrincipal(userId));
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        try {
            if (this._principalDatabase.verifyPassword(username, password.toCharArray())) {
                return new AuthenticationResult(new UsernamePrincipal(username));
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (AccountNotFoundException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
    }

    public void close() {
    }

    public PrincipalDatabase getPrincipalDatabase() {
        return this._principalDatabase;
    }

    public void onCreate() {
        try {
            File passwordFile = new File(this._passwordFile);
            if (!passwordFile.exists()) {
                passwordFile.createNewFile();
            } else if (!passwordFile.canRead()) {
                throw new IllegalConfigurationException("Cannot read password file" + this._passwordFile + ". Check permissions.");
            }
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot use password database at :" + this._passwordFile, e);
        }
    }

    public void onDelete() {
        File file = new File(this._passwordFile);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }
}

