/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.plain.PlainPasswordCallback;
import org.apache.qpid.server.security.auth.sasl.plain.PlainSaslServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(SimpleAuthenticationManager.class);
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String CRAM_MD5_MECHANISM = "CRAM-MD5";
    private Map<String, String> _users;

    public SimpleAuthenticationManager(String userName, String userPassword) {
        this(Collections.singletonMap(userName, userPassword));
    }

    public SimpleAuthenticationManager(Map<String, String> users) {
        this._users = new HashMap<String, String>(users);
    }

    @Override
    public void initialise() {
    }

    @Override
    public String getMechanisms() {
        return "PLAIN CRAM-MD5";
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (PLAIN_MECHANISM.equals(mechanism)) {
            return new PlainSaslServer(new SimplePlainCallbackHandler());
        }
        if (CRAM_MD5_MECHANISM.equals(mechanism)) {
            return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, null, new SimpleCramMd5CallbackHandler());
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                String authorizationID = server.getAuthorizationID();
                _logger.debug((Object)("Authenticated as " + authorizationID));
                return new AuthenticationResult(new UsernamePrincipal(authorizationID));
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        String userPassword;
        if (this._users.containsKey(username) && (userPassword = this._users.get(username)).equals(password)) {
            return new AuthenticationResult(new UsernamePrincipal(username));
        }
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    public void close() {
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onDelete() {
    }

    private class SimplePlainCallbackHandler
    implements CallbackHandler {
        private SimplePlainCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PlainPasswordCallback) {
                    if (!SimpleAuthenticationManager.this._users.containsKey(username)) continue;
                    PlainPasswordCallback plainPasswordCallback = (PlainPasswordCallback)callback;
                    String password = plainPasswordCallback.getPlainPassword();
                    plainPasswordCallback.setAuthenticated(password.equals(SimpleAuthenticationManager.this._users.get(username)));
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    private class SimpleCramMd5CallbackHandler
    implements CallbackHandler {
        private SimpleCramMd5CallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (SimpleAuthenticationManager.this._users.containsKey(username)) {
                        String password = (String)SimpleAuthenticationManager.this._users.get(username);
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new SaslException("Authentication failed");
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

