/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.AuthorizeCallback;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.sasl.AuthenticationProviderInitialiser;

public abstract class UsernamePasswordInitialiser
implements AuthenticationProviderInitialiser {
    protected static final Logger _logger = Logger.getLogger(UsernamePasswordInitialiser.class);
    private ServerCallbackHandler _callbackHandler;

    public void initialise(PrincipalDatabase db) {
        if (db == null) {
            throw new NullPointerException("Cannot initialise with a null Principal database.");
        }
        this._callbackHandler = new ServerCallbackHandler(db);
    }

    public CallbackHandler getCallbackHandler() {
        return this._callbackHandler;
    }

    private static class ServerCallbackHandler
    implements CallbackHandler {
        private final PrincipalDatabase _principalDatabase;

        protected ServerCallbackHandler(PrincipalDatabase database) {
            this._principalDatabase = database;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            UsernamePrincipal username = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = new UsernamePrincipal(((NameCallback)callback).getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    try {
                        this._principalDatabase.setPassword(username, (PasswordCallback)callback);
                        continue;
                    }
                    catch (AccountNotFoundException e) {
                        IOException ioe = new IOException("Error looking up user " + e);
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

