/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.group.FileGroupDatabase;
import org.apache.qpid.server.security.group.GroupManager;
import org.apache.qpid.server.security.group.GroupPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroupManager
implements GroupManager {
    private final FileGroupDatabase _groupDatabase;
    private final String _groupFile;

    public FileGroupManager(String groupFile) {
        this._groupFile = groupFile;
        this._groupDatabase = new FileGroupDatabase();
    }

    @Override
    public Set<Principal> getGroupPrincipalsForUser(String userId) {
        Set<String> groups = this._groupDatabase.getGroupsForUser(userId);
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String groupName : groups) {
            principals.add((Principal)((Object)new GroupPrincipal(groupName)));
        }
        return principals;
    }

    @Override
    public Set<Principal> getUserPrincipalsForGroup(String group) {
        Set<String> users = this._groupDatabase.getUsersInGroup(group);
        if (users.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String user : users) {
            principals.add(new UsernamePrincipal(user));
        }
        return principals;
    }

    @Override
    public Set<Principal> getGroupPrincipals() {
        Set<String> groups = this._groupDatabase.getAllGroups();
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String groupName : groups) {
            principals.add((Principal)((Object)new GroupPrincipal(groupName)));
        }
        return principals;
    }

    @Override
    public void createGroup(String group) {
        this._groupDatabase.createGroup(group);
    }

    @Override
    public void removeGroup(String group) {
        this._groupDatabase.removeGroup(group);
    }

    @Override
    public void addUserToGroup(String user, String group) {
        this._groupDatabase.addUserToGroup(user, group);
    }

    @Override
    public void removeUserFromGroup(String user, String group) {
        this._groupDatabase.removeUserFromGroup(user, group);
    }

    @Override
    public void onDelete() {
        File file = new File(this._groupFile);
        if (file.exists() && !file.delete()) {
            throw new IllegalConfigurationException("Cannot delete group file");
        }
    }

    @Override
    public void onCreate() {
        File file = new File(this._groupFile);
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (parent.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    throw new IllegalConfigurationException("Cannot create group file");
                }
            } else {
                throw new IllegalConfigurationException("Cannot create group file");
            }
        }
    }

    @Override
    public void open() {
        try {
            this._groupDatabase.setGroupFile(this._groupFile);
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Unable to set group file " + this._groupFile, e);
        }
    }

    @Override
    public void close() {
    }

    public int hashCode() {
        return this._groupFile == null ? 0 : this._groupFile.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileGroupManager other = (FileGroupManager)obj;
        if (this._groupFile == null) {
            return other._groupFile == null;
        }
        return this._groupFile.equals(other._groupFile);
    }
}

