/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.plugin.GroupManagerFactory;
import org.apache.qpid.server.security.group.FileGroupManager;
import org.apache.qpid.server.security.group.GroupManager;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.util.ResourceBundleLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroupManagerFactory
implements GroupManagerFactory {
    public static final String RESOURCE_BUNDLE = "org.apache.qpid.server.security.group.FileGroupProviderAttributeDescriptions";
    public static final String GROUP_FILE_PROVIDER_TYPE = "GroupFile";
    public static final String PATH = "path";
    public static final Collection<String> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("type", "path"));

    @Override
    public GroupManager createInstance(Map<String, Object> attributes) {
        if (attributes == null || !GROUP_FILE_PROVIDER_TYPE.equals(attributes.get("type"))) {
            return null;
        }
        String groupFile = MapValueConverter.getStringAttribute(PATH, attributes, null);
        if (groupFile == null || "".equals(groupFile.trim())) {
            throw new IllegalConfigurationException("Path to file containing groups is not specified!");
        }
        return new FileGroupManager(groupFile);
    }

    @Override
    public String getType() {
        return GROUP_FILE_PROVIDER_TYPE;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTES;
    }

    @Override
    public Map<String, String> getAttributeDescriptions() {
        return ResourceBundleLoader.getResources(RESOURCE_BUNDLE);
    }
}

