/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.plugin.MessageStoreFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.store.MessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreCreator {
    private Map<String, MessageStoreFactory> _factories = new HashMap<String, MessageStoreFactory>();

    public MessageStoreCreator() {
        QpidServiceLoader<MessageStoreFactory> qpidServiceLoader = new QpidServiceLoader<MessageStoreFactory>();
        Iterable<MessageStoreFactory> factories = qpidServiceLoader.atLeastOneInstanceOf(MessageStoreFactory.class);
        for (MessageStoreFactory messageStoreFactory : factories) {
            String type = messageStoreFactory.getType();
            MessageStoreFactory factory = this._factories.put(type.toLowerCase(), messageStoreFactory);
            if (factory == null) continue;
            throw new IllegalStateException("MessageStoreFactory with type name '" + type + "' is already registered using class '" + factory.getClass().getName() + "', can not register class '" + messageStoreFactory.getClass().getName() + "'");
        }
    }

    public MessageStore createMessageStore(String storeType) {
        MessageStoreFactory factory = this._factories.get(storeType.toLowerCase());
        if (factory == null) {
            throw new IllegalConfigurationException("Unknown store type: " + storeType);
        }
        return factory.createMessageStore();
    }

    public Collection<MessageStoreFactory> getFactories() {
        return Collections.unmodifiableCollection(this._factories.values());
    }

    public Collection<String> getStoreTypes() {
        return Collections.unmodifiableCollection(this._factories.keySet());
    }
}

