/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.File;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.apache.qpid.server.store.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.util.FileUtils;

public class DerbyMessageStore
extends AbstractJDBCMessageStore
implements MessageStore {
    private static final Logger _logger = Logger.getLogger(DerbyMessageStore.class);
    private static final String SQL_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String MEMORY_STORE_LOCATION = ":memory:";
    private static final String TABLE_EXISTANCE_QUERY = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = ?";
    public static final String DERBY_SINGLE_DB_SHUTDOWN_CODE = "08006";
    public static final String TYPE = "DERBY";
    private long _totalStoreSize;
    private boolean _limitBusted;
    private long _persistentSizeLowThreshold;
    private long _persistentSizeHighThreshold;
    private String _storeLocation;
    private Class<Driver> _driverClass;

    protected Logger getLogger() {
        return _logger;
    }

    protected String getSqlBlobType() {
        return "blob";
    }

    protected String getSqlVarBinaryType(int size) {
        return "varchar(" + size + ") for bit data";
    }

    protected String getSqlBigIntType() {
        return "bigint";
    }

    protected void doClose() throws SQLException {
        block2: {
            try {
                Connection conn = DriverManager.getConnection(this._connectionURL + ";shutdown=true");
                conn.close();
                this.getLogger().error((Object)"Unable to shut down the store");
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase(DERBY_SINGLE_DB_SHUTDOWN_CODE)) break block2;
                this.getLogger().error((Object)("Exception whilst shutting down the store: " + e));
                throw e;
            }
        }
    }

    protected void implementationSpecificConfiguration(String name, Configuration storeConfiguration) throws ClassNotFoundException {
        File environmentPath;
        this._driverClass = Class.forName(SQL_DRIVER_NAME);
        String databasePath = storeConfiguration.getString("environment-path", System.getProperty("QPID_WORK") + File.separator + "derbyDB");
        if (!(MEMORY_STORE_LOCATION.equals(databasePath) || (environmentPath = new File(databasePath)).exists() || environmentPath.mkdirs())) {
            throw new IllegalArgumentException("Environment path " + environmentPath + " could not be read or created. " + "Ensure the path is correct and that the permissions are correct.");
        }
        this._storeLocation = databasePath;
        this._persistentSizeHighThreshold = storeConfiguration.getLong("overfull-size", -1L);
        this._persistentSizeLowThreshold = storeConfiguration.getLong("underfull-size", this._persistentSizeHighThreshold);
        if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
            this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
        }
        this._connectionURL = "jdbc:derby" + (databasePath.equals(MEMORY_STORE_LOCATION) ? databasePath : ":" + databasePath + "/") + name + ";create=true";
        this._eventManager.addEventListener(new EventListener(){

            public void event(Event event) {
                DerbyMessageStore.this.setInitialSize();
            }
        }, Event.BEFORE_ACTIVATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setInitialSize() {
        Connection conn = null;
        try {
            try {
                conn = this.newAutoCommitConnection();
                this._totalStoreSize = this.getSizeOnDisk(conn);
                Object var3_2 = null;
                if (conn == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            this.getLogger().error((Object)"Unable to set initial store size", (Throwable)e);
        }
    }

    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    protected byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean tableExists(String tableName, Connection conn) throws SQLException {
        boolean bl;
        PreparedStatement stmt = conn.prepareStatement(TABLE_EXISTANCE_QUERY);
        try {
            stmt.setString(1, tableName);
            ResultSet rs = stmt.executeQuery();
            try {
                bl = rs.next();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return bl;
    }

    public String getStoreLocation() {
        return this._storeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void storedSizeChange(int delta) {
        if (this.getPersistentSizeHighThreshold() > 0L) {
            DerbyMessageStore derbyMessageStore = this;
            synchronized (derbyMessageStore) {
                long newSize = this._totalStoreSize += (long)(3 * delta);
                Connection conn = null;
                try {
                    if (!this._limitBusted && newSize > this.getPersistentSizeHighThreshold()) {
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (this._totalStoreSize > this.getPersistentSizeHighThreshold()) {
                            this._limitBusted = true;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
                        }
                    } else if (this._limitBusted && newSize < this.getPersistentSizeLowThreshold()) {
                        long oldSize = this._totalStoreSize;
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (oldSize <= this._totalStoreSize) {
                            this.reduceSizeOnDisk(conn);
                            this._totalStoreSize = this.getSizeOnDisk(conn);
                        }
                        if (this._totalStoreSize < this.getPersistentSizeLowThreshold()) {
                            this._limitBusted = false;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
                        }
                    }
                }
                catch (SQLException e) {
                    this.closeConnection(conn);
                    throw new RuntimeException("Exception while processing store size change", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reduceSizeOnDisk(Connection conn) {
        CallableStatement cs = null;
        PreparedStatement stmt = null;
        try {
            try {
                ArrayList<String> tables;
                ArrayList<String> schemas;
                block9: {
                    String tableQuery = "SELECT S.SCHEMANAME, T.TABLENAME FROM SYS.SYSSCHEMAS S, SYS.SYSTABLES T WHERE S.SCHEMAID = T.SCHEMAID AND T.TABLETYPE='T'";
                    stmt = conn.prepareStatement(tableQuery);
                    ResultSet rs = null;
                    schemas = new ArrayList<String>();
                    tables = new ArrayList<String>();
                    try {
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            schemas.add(rs.getString(1));
                            tables.add(rs.getString(2));
                        }
                        Object var9_9 = null;
                        if (rs == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (rs == null) throw throwable;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                }
                cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
                for (int i = 0; i < schemas.size(); ++i) {
                    cs.setString(1, (String)schemas.get(i));
                    cs.setString(2, (String)tables.get(i));
                    cs.setShort(3, (short)0);
                    cs.execute();
                }
                Object var11_13 = null;
            }
            catch (SQLException e) {
                this.closeConnection(conn);
                throw new RuntimeException("Error reducing on disk size", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.closePreparedStatement(stmt);
            this.closePreparedStatement(cs);
            throw throwable;
        }
        this.closePreparedStatement(stmt);
        this.closePreparedStatement(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSizeOnDisk(Connection conn) {
        long l;
        PreparedStatement stmt = null;
        try {
            try {
                long size;
                block8: {
                    String sizeQuery = "SELECT SUM(T2.NUMALLOCATEDPAGES * T2.PAGESIZE) TOTALSIZE    FROM         SYS.SYSTABLES systabs,        TABLE (SYSCS_DIAG.SPACE_TABLE(systabs.tablename)) AS T2    WHERE systabs.tabletype = 'T'";
                    stmt = conn.prepareStatement(sizeQuery);
                    ResultSet rs = null;
                    size = 0L;
                    try {
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            size = rs.getLong(1);
                        }
                        Object var8_7 = null;
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (rs == null) throw throwable;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                }
                l = size;
                Object var10_11 = null;
            }
            catch (SQLException e) {
                this.closeConnection(conn);
                throw new RuntimeException("Error establishing on disk size", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closePreparedStatement(stmt);
            throw throwable;
        }
        this.closePreparedStatement(stmt);
        return l;
    }

    private long getPersistentSizeLowThreshold() {
        return this._persistentSizeLowThreshold;
    }

    private long getPersistentSizeHighThreshold() {
        return this._persistentSizeHighThreshold;
    }

    public String getStoreType() {
        return TYPE;
    }

    public void onDelete() {
        File location;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Deleting store " + this._storeLocation));
        }
        if (MEMORY_STORE_LOCATION.equals(this._storeLocation)) {
            return;
        }
        if (this._storeLocation != null && (location = new File(this._storeLocation)).exists() && !FileUtils.delete((File)location, (boolean)true)) {
            _logger.error((Object)("Cannot delete " + this._storeLocation));
        }
    }
}

