/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.server.store.AbstractJDBCMessageStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.Transaction;

public class JDBCMessageStore
extends AbstractJDBCMessageStore
implements MessageStore {
    private static final Logger _logger = Logger.getLogger(JDBCMessageStore.class);
    public static final String TYPE = "JDBC";
    private static JDBCDetails DERBY_DETAILS = new JDBCDetails("derby", "blob", "varchar(%d) for bit data", "bigint", false);
    private static JDBCDetails POSTGRESQL_DETAILS = new JDBCDetails("postgresql", "bytea", "bytea", "bigint", true);
    private static JDBCDetails MYSQL_DETAILS = new JDBCDetails("mysql", "blob", "varbinary(%d)", "bigint", false);
    private static JDBCDetails SYBASE_DETAILS = new JDBCDetails("sybase", "image", "varbinary(%d)", "bigint", false);
    private static JDBCDetails ORACLE_DETAILS = new JDBCDetails("oracle", "blob", "raw(%d)", "number", false);
    private static Map<String, JDBCDetails> VENDOR_DETAILS = new HashMap<String, JDBCDetails>();
    private String _blobType;
    private String _varBinaryType;
    private String _bigIntType;
    private boolean _useBytesMethodsForBlob;
    private List<RecordedJDBCTransaction> _transactions = new CopyOnWriteArrayList<RecordedJDBCTransaction>();

    private static void addDetails(JDBCDetails details) {
        VENDOR_DETAILS.put(details.getVendor(), details);
    }

    protected Logger getLogger() {
        return _logger;
    }

    protected String getSqlBlobType() {
        return this._blobType;
    }

    protected String getSqlVarBinaryType(int size) {
        return String.format(this._varBinaryType, size);
    }

    public String getSqlBigIntType() {
        return this._bigIntType;
    }

    protected void doClose() throws AMQStoreException {
        while (!this._transactions.isEmpty()) {
            RecordedJDBCTransaction txn = this._transactions.get(0);
            txn.abortTran();
        }
    }

    protected void implementationSpecificConfiguration(String name, Configuration storeConfiguration) throws ClassNotFoundException {
        this._connectionURL = storeConfiguration.getString("connectionUrl", storeConfiguration.getString("environment-path"));
        JDBCDetails details = null;
        String[] components = this._connectionURL.split(":", 3);
        if (components.length >= 2) {
            String vendor = components[1];
            details = VENDOR_DETAILS.get(vendor);
        }
        if (details == null) {
            this.getLogger().info((Object)("Do not recognize vendor from connection URL: " + this._connectionURL));
            details = DERBY_DETAILS;
        }
        this._blobType = storeConfiguration.getString("sqlBlobType", details.getBlobType());
        this._varBinaryType = storeConfiguration.getString("sqlVarbinaryType", details.getVarBinaryType());
        this._useBytesMethodsForBlob = storeConfiguration.getBoolean("useBytesForBlob", details.isUseBytesMethodsForBlob());
        this._bigIntType = storeConfiguration.getString("sqlBigIntType", details.getBigintType());
    }

    protected void storedSizeChange(int contentSize) {
    }

    public String getStoreLocation() {
        return "";
    }

    public String getStoreType() {
        return TYPE;
    }

    protected byte[] getBlobAsBytes(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            return rs.getBytes(col);
        }
        Blob dataAsBlob = rs.getBlob(col);
        return dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
    }

    protected String getBlobAsString(ResultSet rs, int col) throws SQLException {
        if (this._useBytesMethodsForBlob) {
            byte[] bytes = rs.getBytes(col);
            return new String(bytes, UTF8_CHARSET);
        }
        Blob blob = rs.getBlob(col);
        if (blob == null) {
            return null;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, UTF8_CHARSET);
    }

    public Transaction newTransaction() {
        return new RecordedJDBCTransaction();
    }

    static {
        JDBCMessageStore.addDetails(DERBY_DETAILS);
        JDBCMessageStore.addDetails(POSTGRESQL_DETAILS);
        JDBCMessageStore.addDetails(MYSQL_DETAILS);
        JDBCMessageStore.addDetails(SYBASE_DETAILS);
        JDBCMessageStore.addDetails(ORACLE_DETAILS);
    }

    private class RecordedJDBCTransaction
    extends AbstractJDBCMessageStore.JDBCTransaction {
        private RecordedJDBCTransaction() {
            JDBCMessageStore.this._transactions.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTran() throws AMQStoreException {
            try {
                super.commitTran();
                Object var2_1 = null;
                JDBCMessageStore.this._transactions.remove(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                JDBCMessageStore.this._transactions.remove(this);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StoreFuture commitTranAsync() throws AMQStoreException {
            StoreFuture storeFuture;
            try {
                storeFuture = super.commitTranAsync();
                Object var3_2 = null;
                JDBCMessageStore.this._transactions.remove(this);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                JDBCMessageStore.this._transactions.remove(this);
                throw throwable;
            }
            return storeFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortTran() throws AMQStoreException {
            try {
                super.abortTran();
                Object var2_1 = null;
                JDBCMessageStore.this._transactions.remove(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                JDBCMessageStore.this._transactions.remove(this);
                throw throwable;
            }
        }
    }

    private static class JDBCDetails {
        private final String _vendor;
        private String _blobType;
        private String _varBinaryType;
        private String _bigintType;
        private boolean _useBytesMethodsForBlob;

        private JDBCDetails(String vendor, String blobType, String varBinaryType, String bigIntType, boolean useBytesMethodsForBlob) {
            this._vendor = vendor;
            this.setBlobType(blobType);
            this.setVarBinaryType(varBinaryType);
            this.setBigintType(bigIntType);
            this.setUseBytesMethodsForBlob(useBytesMethodsForBlob);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JDBCDetails that = (JDBCDetails)o;
            return this.getVendor().equals(that.getVendor());
        }

        public int hashCode() {
            return this.getVendor().hashCode();
        }

        public String toString() {
            return "JDBCDetails{vendor='" + this.getVendor() + '\'' + ", blobType='" + this.getBlobType() + '\'' + ", varBinaryType='" + this.getVarBinaryType() + '\'' + ", bigIntType='" + this.getBigintType() + '\'' + ", useBytesMethodsForBlob=" + this.isUseBytesMethodsForBlob() + '}';
        }

        public String getVendor() {
            return this._vendor;
        }

        public String getBlobType() {
            return this._blobType;
        }

        public void setBlobType(String blobType) {
            this._blobType = blobType;
        }

        public String getVarBinaryType() {
            return this._varBinaryType;
        }

        public void setVarBinaryType(String varBinaryType) {
            this._varBinaryType = varBinaryType;
        }

        public boolean isUseBytesMethodsForBlob() {
            return this._useBytesMethodsForBlob;
        }

        public void setUseBytesMethodsForBlob(boolean useBytesMethodsForBlob) {
            this._useBytesMethodsForBlob = useBytesMethodsForBlob;
        }

        public String getBigintType() {
            return this._bigintType;
        }

        public void setBigintType(String bigintType) {
            this._bigintType = bigintType;
        }
    }
}

