/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.subscription.Subscription_0_10;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.transport.ServerSessionDelegate;
import org.apache.qpid.server.virtualhost.State;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionOpen;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionStartOk;
import org.apache.qpid.transport.ConnectionTuneOk;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ServerDelegate;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionAttach;
import org.apache.qpid.transport.SessionDetach;
import org.apache.qpid.transport.SessionDetachCode;
import org.apache.qpid.transport.SessionDetached;
import org.apache.qpid.transport.network.NetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnectionDelegate
extends ServerDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConnectionDelegate.class);
    private final Broker _broker;
    private final String _localFQDN;
    private int _maxNoOfChannels;
    private Map<String, Object> _clientProperties;
    private final SubjectCreator _subjectCreator;

    public ServerConnectionDelegate(Broker broker, String localFQDN, SubjectCreator subjectCreator) {
        this(ServerConnectionDelegate.createConnectionProperties(broker), Collections.singletonList("en_US"), broker, localFQDN, subjectCreator);
    }

    private ServerConnectionDelegate(Map<String, Object> properties, List<Object> locales, Broker broker, String localFQDN, SubjectCreator subjectCreator) {
        super(properties, ServerConnectionDelegate.parseToList(subjectCreator.getMechanisms()), locales);
        this._broker = broker;
        this._localFQDN = localFQDN;
        this._maxNoOfChannels = (Integer)broker.getAttribute("connection.sessionCountLimit");
        this._subjectCreator = subjectCreator;
    }

    private static List<String> getFeatures(Broker broker) {
        String brokerDisabledFeatures = System.getProperty("qpid.broker_disabled_features");
        ArrayList<String> features = new ArrayList<String>();
        if (brokerDisabledFeatures == null || !brokerDisabledFeatures.contains("qpid.jms-selector")) {
            features.add("qpid.jms-selector");
        }
        return Collections.unmodifiableList(features);
    }

    private static Map<String, Object> createConnectionProperties(Broker broker) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("qpid.federation_tag", broker.getId().toString());
        List<String> features = ServerConnectionDelegate.getFeatures(broker);
        if (features != null && features.size() > 0) {
            map.put("qpid.features", features);
        }
        return map;
    }

    private static List<Object> parseToList(String mechanisms) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(mechanisms, " ");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public ServerSession getSession(Connection conn, SessionAttach atc) {
        ServerSessionDelegate serverSessionDelegate = new ServerSessionDelegate();
        ServerSession ssn = new ServerSession(conn, serverSessionDelegate, new Binary(atc.getName()), 0L);
        return ssn;
    }

    protected SaslServer createSaslServer(Connection conn, String mechanism) throws SaslException {
        return this._subjectCreator.createSaslServer(mechanism, this._localFQDN, ((ServerConnection)conn).getPeerPrincipal());
    }

    protected void secure(SaslServer ss, Connection conn, byte[] response) {
        ServerConnection sconn = (ServerConnection)conn;
        SubjectAuthenticationResult authResult = this._subjectCreator.authenticate(ss, response);
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)authResult.getStatus())) {
            this.tuneAuthorizedConnection(sconn);
            sconn.setAuthorizedSubject(authResult.getSubject());
        } else if (AuthenticationResult.AuthenticationStatus.CONTINUE.equals((Object)authResult.getStatus())) {
            this.connectionAuthContinue(sconn, authResult.getChallenge());
        } else {
            this.connectionAuthFailed(sconn, authResult.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClose(Connection conn, ConnectionClose close) {
        ServerConnection sconn = (ServerConnection)conn;
        try {
            sconn.logClosed();
        }
        finally {
            sconn.closeCode(close);
            sconn.setState(Connection.State.CLOSE_RCVD);
            this.sendConnectionCloseOkAndCloseSender(conn);
        }
    }

    public void connectionOpen(Connection conn, ConnectionOpen open) {
        ServerConnection sconn = (ServerConnection)conn;
        String vhostName = open.hasVirtualHost() ? open.getVirtualHost() : "";
        VirtualHost vhost = this._broker.getVirtualHostRegistry().getVirtualHost(vhostName);
        SecurityManager.setThreadSubject(sconn.getAuthorizedSubject());
        if (vhost != null) {
            sconn.setVirtualHost(vhost);
            if (!vhost.getSecurityManager().accessVirtualhost(vhostName, sconn.getRemoteAddress())) {
                sconn.setState(Connection.State.CLOSING);
                sconn.invoke((Method)new ConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Permission denied '" + vhostName + "'", new Option[0]));
            } else if (vhost.getState() != State.ACTIVE) {
                sconn.setState(Connection.State.CLOSING);
                sconn.invoke((Method)new ConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Virtual host '" + vhostName + "' is not active", new Option[0]));
            } else {
                sconn.setState(Connection.State.OPEN);
                sconn.invoke((Method)new ConnectionOpenOk(Collections.emptyList(), new Option[0]));
            }
        } else {
            sconn.setState(Connection.State.CLOSING);
            sconn.invoke((Method)new ConnectionClose(ConnectionCloseCode.INVALID_PATH, "Unknown virtualhost '" + vhostName + "'", new Option[0]));
        }
    }

    public void connectionTuneOk(Connection conn, ConnectionTuneOk ok) {
        int heartbeat;
        ServerConnection sconn = (ServerConnection)conn;
        int okChannelMax = ok.getChannelMax();
        if (okChannelMax > this.getChannelMax()) {
            LOGGER.error("Connection '" + sconn.getConnectionId() + "' being severed, " + "client connectionTuneOk returned a channelMax (" + okChannelMax + ") above the server's offered limit (" + this.getChannelMax() + ")");
            sconn.getSender().close();
            return;
        }
        if (ok.hasHeartbeat() && (heartbeat = ok.getHeartbeat()) > 0) {
            NetworkConnection networkConnection = sconn.getNetworkConnection();
            networkConnection.setMaxReadIdle(2 * heartbeat);
            networkConnection.setMaxWriteIdle(heartbeat);
        }
        this.setConnectionTuneOkChannelMax(sconn, okChannelMax);
    }

    public int getChannelMax() {
        return this._maxNoOfChannels;
    }

    protected void setChannelMax(int channelMax) {
        this._maxNoOfChannels = channelMax;
    }

    public void sessionDetach(Connection conn, SessionDetach dtc) {
        this.stopAllSubscriptions(conn, dtc);
        Session ssn = conn.getSession(dtc.getChannel());
        ((ServerSession)ssn).setClose(true);
        super.sessionDetach(conn, dtc);
    }

    private void stopAllSubscriptions(Connection conn, SessionDetach dtc) {
        ServerSession ssn = (ServerSession)conn.getSession(dtc.getChannel());
        Collection<Subscription_0_10> subs = ssn.getSubscriptions();
        for (Subscription_0_10 subscription_0_10 : subs) {
            subscription_0_10.stop();
        }
    }

    public void sessionAttach(Connection conn, SessionAttach atc) {
        if (this.isSessionNameUnique(atc.getName(), conn)) {
            super.sessionAttach(conn, atc);
        } else {
            ServerSession ssn = this.getSession(conn, atc);
            ssn.invoke((Method)new SessionDetached(atc.getName(), SessionDetachCode.SESSION_BUSY, new Option[0]));
            ssn.closed();
        }
    }

    private boolean isSessionNameUnique(byte[] name, Connection conn) {
        ServerConnection sconn = (ServerConnection)conn;
        String userId = sconn.getUserName();
        for (AMQConnectionModel amqConnectionModel : ((ServerConnection)conn).getVirtualHost().getConnectionRegistry().getConnections()) {
            if (!userId.equals(amqConnectionModel.getUserName()) || amqConnectionModel.isSessionNameUnique(name)) continue;
            return false;
        }
        return true;
    }

    public void connectionStartOk(Connection conn, ConnectionStartOk ok) {
        this._clientProperties = ok.getClientProperties();
        super.connectionStartOk(conn, ok);
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public String getClientId() {
        return this._clientProperties == null ? null : (String)this._clientProperties.get("clientName");
    }

    public String getClientVersion() {
        return this._clientProperties == null ? null : (String)this._clientProperties.get("qpid.client_version");
    }
}

