/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.AMQUnknownExchangeType;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeInUseException;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.exchange.HeadersExchange;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterManagerFactory;
import org.apache.qpid.server.flow.WindowCreditManager;
import org.apache.qpid.server.logging.messages.ExchangeMessages;
import org.apache.qpid.server.message.MessageMetaData_0_10;
import org.apache.qpid.server.message.MessageTransferMessage;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.subscription.SubscriptionFactoryImpl;
import org.apache.qpid.server.subscription.Subscription_0_10;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.txn.AlreadyKnownDtxException;
import org.apache.qpid.server.txn.DtxNotSelectedException;
import org.apache.qpid.server.txn.IncorrectDtxStateException;
import org.apache.qpid.server.txn.JoinAndResumeDtxException;
import org.apache.qpid.server.txn.NotAssociatedDtxException;
import org.apache.qpid.server.txn.RollbackOnlyDtxException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.SuspendAndFailDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Acquired;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.DtxCommit;
import org.apache.qpid.transport.DtxEnd;
import org.apache.qpid.transport.DtxForget;
import org.apache.qpid.transport.DtxGetTimeout;
import org.apache.qpid.transport.DtxPrepare;
import org.apache.qpid.transport.DtxRecover;
import org.apache.qpid.transport.DtxRollback;
import org.apache.qpid.transport.DtxSelect;
import org.apache.qpid.transport.DtxSetTimeout;
import org.apache.qpid.transport.DtxStart;
import org.apache.qpid.transport.DtxXaStatus;
import org.apache.qpid.transport.ExchangeBind;
import org.apache.qpid.transport.ExchangeBound;
import org.apache.qpid.transport.ExchangeBoundResult;
import org.apache.qpid.transport.ExchangeDeclare;
import org.apache.qpid.transport.ExchangeDelete;
import org.apache.qpid.transport.ExchangeQuery;
import org.apache.qpid.transport.ExchangeQueryResult;
import org.apache.qpid.transport.ExchangeUnbind;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.ExecutionSync;
import org.apache.qpid.transport.GetTimeoutResult;
import org.apache.qpid.transport.MessageAccept;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquire;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageCancel;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageFlush;
import org.apache.qpid.transport.MessageReject;
import org.apache.qpid.transport.MessageRejectCode;
import org.apache.qpid.transport.MessageRelease;
import org.apache.qpid.transport.MessageResume;
import org.apache.qpid.transport.MessageSetFlowMode;
import org.apache.qpid.transport.MessageStop;
import org.apache.qpid.transport.MessageSubscribe;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.QueueDeclare;
import org.apache.qpid.transport.QueueDelete;
import org.apache.qpid.transport.QueuePurge;
import org.apache.qpid.transport.QueueQuery;
import org.apache.qpid.transport.QueueQueryResult;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RangeSetFactory;
import org.apache.qpid.transport.RecoverResult;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDelegate;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.TxCommit;
import org.apache.qpid.transport.TxRollback;
import org.apache.qpid.transport.TxSelect;
import org.apache.qpid.transport.XaResult;
import org.apache.qpid.transport.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSessionDelegate
extends SessionDelegate {
    private static final Logger LOGGER = Logger.getLogger(ServerSessionDelegate.class);
    private static final String QUEUE_ARGUMENT_NO_LOCAL = "no-local";

    public void command(Session session, Method method) {
        try {
            this.setThreadSubject(session);
            if (!session.isClosing()) {
                Object asyncCommandMark = ((ServerSession)session).getAsyncCommandMark();
                super.command(session, method, false);
                Object newOutstanding = ((ServerSession)session).getAsyncCommandMark();
                if (newOutstanding == null || newOutstanding == asyncCommandMark) {
                    session.processed(method);
                }
                if (newOutstanding != null) {
                    ((ServerSession)session).completeAsyncCommands();
                }
                if (method.isSync()) {
                    ((ServerSession)session).awaitCommandCompletion();
                    session.flushProcessed(new Option[0]);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Exception processing command", (Throwable)e);
            this.exception(session, method, ExecutionErrorCode.INTERNAL_ERROR, "Exception processing command: " + e);
        }
    }

    public void messageAccept(Session session, MessageAccept method) {
        ServerSession serverSession = (ServerSession)session;
        serverSession.accept(method.getTransfers());
        if (!serverSession.isTransactional()) {
            serverSession.recordFuture(StoreFuture.IMMEDIATE_FUTURE, new CommandProcessedAction(serverSession, (Method)method));
        }
    }

    public void messageReject(Session session, MessageReject method) {
        ((ServerSession)session).reject(method.getTransfers());
    }

    public void messageRelease(Session session, MessageRelease method) {
        ((ServerSession)session).release(method.getTransfers(), method.getSetRedelivered());
    }

    public void messageAcquire(Session session, MessageAcquire method) {
        RangeSet acquiredRanges = ((ServerSession)session).acquire(method.getTransfers());
        Acquired result = new Acquired(acquiredRanges);
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void messageResume(Session session, MessageResume method) {
        super.messageResume((Object)session, method);
    }

    public void messageSubscribe(Session session, MessageSubscribe method) {
        if (!method.hasAcceptMode()) {
            method.setAcceptMode(MessageAcceptMode.EXPLICIT);
        }
        if (!method.hasAcquireMode()) {
            method.setAcquireMode(MessageAcquireMode.PRE_ACQUIRED);
        }
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not supplied");
        } else {
            String destination = method.getDestination();
            if (((ServerSession)session).getSubscription(destination) != null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Subscription already exists with destination '" + destination + "'");
            } else {
                String queueName = method.getQueue();
                QueueRegistry queueRegistry = this.getQueueRegistry(session);
                final AMQQueue queue = queueRegistry.getQueue(queueName);
                if (queue == null) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: " + queueName + " not found");
                } else if (queue.getAuthorizationHolder() != null && queue.getAuthorizationHolder() != session) {
                    this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
                } else if (queue.isExclusive() && queue.getExclusiveOwningSession() != null && queue.getExclusiveOwningSession() != session) {
                    this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
                } else {
                    if (queue.isExclusive()) {
                        ServerSession s = (ServerSession)session;
                        queue.setExclusiveOwningSession(s);
                        if (queue.getAuthorizationHolder() == null) {
                            queue.setAuthorizationHolder(s);
                            queue.setExclusiveOwningSession(s);
                            ((ServerSession)session).addSessionCloseTask(new ServerSession.Task(){

                                public void doTask(ServerSession session) {
                                    if (queue.getAuthorizationHolder() == session) {
                                        queue.setAuthorizationHolder(null);
                                        queue.setExclusiveOwningSession(null);
                                    }
                                }
                            });
                        }
                    }
                    WindowCreditManager creditManager = new WindowCreditManager(0L, 0L);
                    FilterManager filterManager = null;
                    try {
                        filterManager = FilterManagerFactory.createManager(method.getArguments());
                    }
                    catch (AMQException amqe) {
                        this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Exception Creating FilterManager");
                        return;
                    }
                    Subscription_0_10 sub = SubscriptionFactoryImpl.INSTANCE.createSubscription((ServerSession)session, destination, method.getAcceptMode(), method.getAcquireMode(), MessageFlowMode.WINDOW, creditManager, filterManager, method.getArguments());
                    ((ServerSession)session).register(destination, sub);
                    try {
                        queue.registerSubscription(sub, method.getExclusive());
                    }
                    catch (AMQQueue.ExistingExclusiveSubscription existing) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an exclusive consumer");
                    }
                    catch (AMQQueue.ExistingSubscriptionPreventsExclusive exclusive) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an existing consumer - can't subscribe exclusively");
                    }
                    catch (AMQException e) {
                        this.exception(session, (Method)method, e, "Cannot subscribe to queue '" + queueName + "' with destination '" + destination);
                    }
                }
            }
        }
    }

    public void messageTransfer(Session ssn, MessageTransfer xfr) {
        Exchange alternateExchange;
        Exchange exchange = this.getExchangeForMessage(ssn, xfr);
        DeliveryProperties delvProps = null;
        if (xfr.getHeader() != null && (delvProps = xfr.getHeader().getDeliveryProperties()) != null && delvProps.hasTtl() && !delvProps.hasExpiration()) {
            delvProps.setExpiration(System.currentTimeMillis() + delvProps.getTtl());
        }
        MessageMetaData_0_10 messageMetaData = new MessageMetaData_0_10(xfr);
        messageMetaData.setConnectionReference(((ServerSession)ssn).getReference());
        if (!this.getVirtualHost(ssn).getSecurityManager().authorisePublish(messageMetaData.isImmediate(), messageMetaData.getRoutingKey(), exchange.getName())) {
            ExecutionErrorCode errorCode = ExecutionErrorCode.UNAUTHORIZED_ACCESS;
            String description = "Permission denied: exchange-name '" + exchange.getName() + "'";
            this.exception(ssn, (Method)xfr, errorCode, description);
            return;
        }
        List<? extends BaseQueue> queues = exchange.route(messageMetaData);
        Exchange exchangeInUse = queues.isEmpty() && exchange.getAlternateExchange() != null ? (!(queues = (alternateExchange = exchange.getAlternateExchange()).route(messageMetaData)).isEmpty() ? alternateExchange : exchange) : exchange;
        ServerSession serverSession = (ServerSession)ssn;
        if (!queues.isEmpty()) {
            MessageStore store = this.getVirtualHost(ssn).getMessageStore();
            StoredMessage<MessageMetaData_0_10> storeMessage = this.createStoreMessage(xfr, messageMetaData, store);
            MessageTransferMessage message = new MessageTransferMessage(storeMessage, serverSession.getReference());
            serverSession.enqueue(message, queues);
            storeMessage.flushToStore();
        } else if (!(delvProps != null && delvProps.getDiscardUnroutable() || xfr.getAcceptMode() != MessageAcceptMode.EXPLICIT)) {
            RangeSet rejects = RangeSetFactory.createRangeSet();
            rejects.add(xfr.getId());
            MessageReject reject = new MessageReject(rejects, MessageRejectCode.UNROUTABLE, "Unroutable", new Option[0]);
            ssn.invoke((Method)reject);
        } else {
            serverSession.getLogActor().message(ExchangeMessages.DISCARDMSG(exchangeInUse.getName(), messageMetaData.getRoutingKey()));
        }
        if (serverSession.isTransactional()) {
            serverSession.processed((Method)xfr);
        } else {
            serverSession.recordFuture(StoreFuture.IMMEDIATE_FUTURE, new CommandProcessedAction(serverSession, (Method)xfr));
        }
    }

    private StoredMessage<MessageMetaData_0_10> createStoreMessage(MessageTransfer xfr, MessageMetaData_0_10 messageMetaData, MessageStore store) {
        StoredMessage<MessageMetaData_0_10> storeMessage = store.addMessage(messageMetaData);
        ByteBuffer body = xfr.getBody();
        if (body != null) {
            storeMessage.addContent(0, body);
        }
        return storeMessage;
    }

    public void messageCancel(Session session, MessageCancel method) {
        String destination = method.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            AMQQueue queue = sub.getQueue();
            ((ServerSession)session).unregister(sub);
            if (!queue.isDeleted() && queue.isExclusive() && queue.getConsumerCount() == 0) {
                queue.setAuthorizationHolder(null);
            }
        }
    }

    public void messageFlush(Session session, MessageFlush method) {
        String destination = method.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            try {
                sub.flush();
            }
            catch (AMQException e) {
                this.exception(session, (Method)method, e, "Cannot flush subscription '" + destination);
            }
        }
    }

    public void txSelect(Session session, TxSelect method) {
        ((ServerSession)session).selectTx();
    }

    public void txCommit(Session session, TxCommit method) {
        ((ServerSession)session).commit();
    }

    public void txRollback(Session session, TxRollback method) {
        ((ServerSession)session).rollback();
    }

    public void dtxSelect(Session session, DtxSelect method) {
        ((ServerSession)session).selectDtx();
    }

    public void dtxStart(Session session, DtxStart method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            ((ServerSession)session).startDtx(method.getXid(), method.getJoin(), method.getResume());
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (JoinAndResumeDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Unknown xid " + method.getXid());
        }
        catch (AlreadyKnownDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Xid already started an neither join nor resume set" + method.getXid());
        }
        catch (DtxNotSelectedException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
    }

    public void dtxEnd(Session session, DtxEnd method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).endDtx(method.getXid(), method.getFail(), method.getSuspend());
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (NotAssociatedDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (DtxNotSelectedException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (SuspendAndFailDtxException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.COMMAND_INVALID, e.getMessage());
        }
    }

    public void dtxCommit(Session session, DtxCommit method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).commitDtx(method.getXid(), method.getOnePhase());
            }
            catch (RollbackOnlyDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBROLLBACK);
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (AMQStoreException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    public void dtxForget(Session session, DtxForget method) {
        try {
            ((ServerSession)session).forgetDtx(method.getXid());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
    }

    public void dtxGetTimeout(Session session, DtxGetTimeout method) {
        GetTimeoutResult result = new GetTimeoutResult();
        try {
            result.setTimeout(((ServerSession)session).getTimeoutDtx(method.getXid()));
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
    }

    public void dtxPrepare(Session session, DtxPrepare method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).prepareDtx(method.getXid());
            }
            catch (RollbackOnlyDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBROLLBACK);
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (AMQStoreException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    public void dtxRecover(Session session, DtxRecover method) {
        RecoverResult result = new RecoverResult();
        List<Xid> inDoubt = ((ServerSession)session).recoverDtx();
        result.setInDoubt(inDoubt);
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void dtxRollback(Session session, DtxRollback method) {
        XaResult result = new XaResult();
        result.setStatus(DtxXaStatus.XA_OK);
        try {
            try {
                ((ServerSession)session).rollbackDtx(method.getXid());
            }
            catch (TimeoutDtxException e) {
                result.setStatus(DtxXaStatus.XA_RBTIMEOUT);
            }
            session.executionResult(method.getId(), (Struct)result, new Option[0]);
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
        catch (IncorrectDtxStateException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_STATE, e.getMessage());
        }
        catch (AMQStoreException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    public void dtxSetTimeout(Session session, DtxSetTimeout method) {
        try {
            ((ServerSession)session).setTimeoutDtx(method.getXid(), method.getTimeout());
        }
        catch (UnknownDtxBranchException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, e.getMessage());
        }
    }

    public void executionSync(Session ssn, ExecutionSync sync) {
        ((ServerSession)ssn).awaitCommandCompletion();
        super.executionSync(ssn, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeDeclare(Session session, ExchangeDeclare method) {
        Map args;
        String exchangeName = method.getExchange();
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(session);
        if (method.hasArguments() && !(args = method.getArguments()).isEmpty()) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_IMPLEMENTED, "Unsupported exchange argument(s) found " + args.keySet().toString());
            return;
        }
        ExchangeRegistry exchangeRegistry2 = exchangeRegistry;
        synchronized (exchangeRegistry2) {
            block27: {
                Exchange exchange = this.getExchange(session, exchangeName);
                if (method.getPassive()) {
                    if (exchange == null) {
                        this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: exchange-name '" + exchangeName + "'");
                    } else if (!exchange.getTypeShortString().toString().equals(method.getType()) && method.getType() != null && method.getType().length() > 0) {
                        this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getTypeShortString() + " to " + method.getType() + ".");
                    }
                } else if (exchange == null) {
                    if (exchangeName.startsWith("amq.")) {
                        this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved prefix 'amq.'.");
                    } else if (exchangeName.startsWith("qpid.")) {
                        this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved prefix 'qpid.'.");
                    } else {
                        ExchangeFactory exchangeFactory = virtualHost.getExchangeFactory();
                        try {
                            boolean validAlternate;
                            exchange = exchangeFactory.createExchange(method.getExchange(), method.getType(), method.getDurable(), method.getAutoDelete());
                            String alternateExchangeName = method.getAlternateExchange();
                            if (alternateExchangeName != null && alternateExchangeName.length() != 0) {
                                Exchange alternate = this.getExchange(session, alternateExchangeName);
                                if (alternate == null) {
                                    validAlternate = false;
                                } else {
                                    exchange.setAlternateExchange(alternate);
                                    validAlternate = true;
                                }
                            } else {
                                validAlternate = true;
                            }
                            if (validAlternate) {
                                if (exchange.isDurable()) {
                                    MessageStore store = virtualHost.getMessageStore();
                                    store.createExchange(exchange);
                                }
                                exchangeRegistry.registerExchange(exchange);
                                break block27;
                            }
                            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Unknown alternate exchange " + alternateExchangeName);
                        }
                        catch (AMQUnknownExchangeType e) {
                            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Unknown Exchange Type: " + method.getType());
                        }
                        catch (AMQException e) {
                            this.exception(session, (Method)method, e, "Cannot declare exchange '" + exchangeName);
                        }
                    }
                } else if (!exchange.getTypeShortString().toString().equals(method.getType())) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getTypeShortString() + " to " + method.getType() + ".");
                } else if (method.hasAlternateExchange() && (exchange.getAlternateExchange() == null || !method.getAlternateExchange().equals(exchange.getAlternateExchange().getName()))) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Attempt to change alternate exchange of: " + exchangeName + " from " + exchange.getAlternateExchange() + " to " + method.getAlternateExchange() + ".");
                }
            }
        }
    }

    private void exception(Session session, Method method, AMQException exception, String message) {
        ExecutionErrorCode errorCode = ExecutionErrorCode.INTERNAL_ERROR;
        if (exception.getErrorCode() != null) {
            try {
                errorCode = ExecutionErrorCode.get((int)exception.getErrorCode().getCode());
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        String description = message + "': " + exception.getMessage();
        this.exception(session, method, errorCode, description);
    }

    private void exception(Session session, Method method, ExecutionErrorCode errorCode, String description) {
        ExecutionException ex = new ExecutionException();
        ex.setErrorCode(errorCode);
        ex.setCommandId(method.getId());
        ex.setDescription(description);
        session.invoke((Method)ex);
        session.close();
    }

    private Exchange getExchange(Session session, String exchangeName) {
        ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(session);
        return exchangeRegistry.getExchange(exchangeName);
    }

    private ExchangeRegistry getExchangeRegistry(Session session) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        return virtualHost.getExchangeRegistry();
    }

    private Exchange getExchangeForMessage(Session ssn, MessageTransfer xfr) {
        Exchange exchange;
        ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(ssn);
        if (xfr.hasDestination()) {
            exchange = exchangeRegistry.getExchange(xfr.getDestination());
            if (exchange == null) {
                exchange = exchangeRegistry.getDefaultExchange();
            }
        } else {
            exchange = exchangeRegistry.getDefaultExchange();
        }
        return exchange;
    }

    private VirtualHost getVirtualHost(Session session) {
        ServerConnection conn = this.getServerConnection(session);
        VirtualHost vhost = conn.getVirtualHost();
        return vhost;
    }

    private ServerConnection getServerConnection(Session session) {
        ServerConnection conn = (ServerConnection)session.getConnection();
        return conn;
    }

    public void exchangeDelete(Session session, ExchangeDelete method) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        try {
            if (this.nameNullOrEmpty(method.getExchange())) {
                this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Delete not allowed for default exchange");
                return;
            }
            Exchange exchange = this.getExchange(session, method.getExchange());
            if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No such exchange '" + method.getExchange() + "'");
            } else if (exchange.hasReferrers()) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Exchange in use as an alternate exchange");
            } else if (this.isStandardExchange(exchange, virtualHost.getExchangeFactory().getRegisteredTypes())) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Exchange '" + method.getExchange() + "' cannot be deleted");
            } else {
                exchangeRegistry.unregisterExchange(method.getExchange(), method.getIfUnused());
                if (exchange.isDurable() && !exchange.isAutoDelete()) {
                    MessageStore store = virtualHost.getMessageStore();
                    store.removeExchange(exchange);
                }
            }
        }
        catch (ExchangeInUseException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Exchange in use");
        }
        catch (AMQException e) {
            this.exception(session, (Method)method, e, "Cannot delete exchange '" + method.getExchange());
        }
    }

    private boolean nameNullOrEmpty(String name) {
        return name == null || name.length() == 0;
    }

    private boolean isStandardExchange(Exchange exchange, Collection<ExchangeType<? extends Exchange>> registeredTypes) {
        for (ExchangeType<? extends Exchange> type : registeredTypes) {
            if (!type.getDefaultExchangeName().toString().equals(exchange.getName())) continue;
            return true;
        }
        return false;
    }

    public void exchangeQuery(Session session, ExchangeQuery method) {
        ExchangeQueryResult result = new ExchangeQueryResult();
        Exchange exchange = this.getExchange(session, method.getName());
        if (exchange != null) {
            result.setDurable(exchange.isDurable());
            result.setType(exchange.getTypeShortString().toString());
            result.setNotFound(false);
        } else {
            result.setNotFound(true);
        }
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void exchangeBind(Session session, ExchangeBind method) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else if (this.nameNullOrEmpty(method.getExchange())) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Bind not allowed for default exchange");
        } else {
            if (!method.hasBindingKey()) {
                method.setBindingKey(method.getQueue());
            }
            AMQQueue queue = queueRegistry.getQueue(method.getQueue());
            Exchange exchange = exchangeRegistry.getExchange(method.getExchange());
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
            } else if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + method.getExchange() + "' not found");
            } else if (!(!exchange.getTypeShortString().equals(HeadersExchange.TYPE.getName()) || method.hasArguments() && method.getArguments() != null && method.getArguments().containsKey("x-match"))) {
                this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, "Bindings to an exchange of type " + HeadersExchange.TYPE.getName() + " require an x-match header");
            } else if (!exchange.isBound(method.getBindingKey(), method.getArguments(), queue)) {
                try {
                    virtualHost.getBindingFactory().addBinding(method.getBindingKey(), queue, exchange, method.getArguments());
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot add binding '" + method.getBindingKey());
                }
            }
        }
    }

    public void exchangeUnbind(Session session, ExchangeUnbind method) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else if (this.nameNullOrEmpty(method.getExchange())) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "Unbind not allowed for default exchange");
        } else if (!method.hasBindingKey()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "binding-key not set");
        } else {
            AMQQueue queue = queueRegistry.getQueue(method.getQueue());
            Exchange exchange = exchangeRegistry.getExchange(method.getExchange());
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
            } else if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + method.getExchange() + "' not found");
            } else {
                try {
                    virtualHost.getBindingFactory().removeBinding(method.getBindingKey(), queue, exchange, null);
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot remove binding '" + method.getBindingKey());
                }
            }
        }
    }

    public void exchangeBound(Session session, ExchangeBound method) {
        Exchange exchange;
        ExchangeBoundResult result = new ExchangeBoundResult();
        if (method.hasExchange()) {
            exchange = this.getExchange(session, method.getExchange());
            if (exchange == null) {
                result.setExchangeNotFound(true);
            }
        } else {
            exchange = this.getExchangeRegistry(session).getDefaultExchange();
        }
        if (method.hasQueue()) {
            AMQQueue queue = this.getQueue(session, method.getQueue());
            if (queue == null) {
                result.setQueueNotFound(true);
            }
            if (exchange != null && queue != null) {
                boolean queueMatched = exchange.isBound(queue);
                result.setQueueNotMatched(!queueMatched);
                if (method.hasBindingKey()) {
                    if (queueMatched) {
                        result.setKeyNotMatched(!exchange.isBound(method.getBindingKey(), queue));
                    } else {
                        result.setKeyNotMatched(!exchange.isBound(method.getBindingKey()));
                    }
                    if (method.hasArguments()) {
                        result.setArgsNotMatched(!exchange.isBound(result.getKeyNotMatched() ? null : method.getBindingKey(), method.getArguments(), queueMatched ? queue : null));
                    }
                } else if (method.hasArguments()) {
                    result.setArgsNotMatched(!exchange.isBound(null, method.getArguments(), queueMatched ? queue : null));
                }
            } else if (exchange != null && method.hasBindingKey()) {
                result.setKeyNotMatched(!exchange.isBound(method.getBindingKey()));
                if (method.hasArguments()) {
                    result.setArgsNotMatched(!exchange.isBound(result.getKeyNotMatched() ? null : method.getBindingKey(), method.getArguments(), queue));
                }
            }
        } else if (exchange != null && method.hasBindingKey()) {
            if (method.hasArguments()) {
                result.setArgsNotMatched(!exchange.isBound(method.getBindingKey(), method.getArguments(), null));
            }
            result.setKeyNotMatched(!exchange.isBound(method.getBindingKey()));
        } else if (exchange != null && method.hasArguments()) {
            result.setArgsNotMatched(!exchange.isBound(null, method.getArguments(), null));
        }
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    private AMQQueue getQueue(Session session, String queue) {
        QueueRegistry queueRegistry = this.getQueueRegistry(session);
        return queueRegistry.getQueue(queue);
    }

    private QueueRegistry getQueueRegistry(Session session) {
        return this.getVirtualHost(session).getQueueRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueDeclare(Session session, final QueueDeclare method) {
        QueueRegistry queueRegistry;
        VirtualHost virtualHost = this.getVirtualHost(session);
        MessageStore store = virtualHost.getMessageStore();
        String queueName = method.getQueue();
        QueueRegistry queueRegistry2 = queueRegistry = this.getQueueRegistry(session);
        synchronized (queueRegistry2) {
            AMQQueue queue = queueRegistry.getQueue(queueName);
            if (queue == null) {
                if (method.getPassive()) {
                    String description = "Queue: " + queueName + " not found on VirtualHost(" + virtualHost + ").";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.NOT_FOUND;
                    this.exception(session, (Method)method, errorCode, description);
                    return;
                }
                try {
                    ServerSession s;
                    AMQQueue q;
                    String alternateExchangeName;
                    queue = this.createQueue(queueName, method, virtualHost, (ServerSession)session);
                    if (!method.getExclusive() && method.getAutoDelete()) {
                        queue.setDeleteOnNoConsumers(true);
                    }
                    if ((alternateExchangeName = method.getAlternateExchange()) != null && alternateExchangeName.length() != 0) {
                        Exchange alternate = this.getExchange(session, alternateExchangeName);
                        queue.setAlternateExchange(alternate);
                    }
                    if (method.hasArguments() && method.getArguments() != null && method.getArguments().containsKey(QUEUE_ARGUMENT_NO_LOCAL)) {
                        Object noLocal = method.getArguments().get(QUEUE_ARGUMENT_NO_LOCAL);
                        queue.setNoLocal(this.convertBooleanValue(noLocal));
                    }
                    if (queue.isDurable() && !queue.isAutoDelete()) {
                        if (method.hasArguments() && method.getArguments() != null) {
                            Map args = method.getArguments();
                            FieldTable ftArgs = new FieldTable();
                            for (Map.Entry entry : args.entrySet()) {
                                ftArgs.put(new AMQShortString((String)entry.getKey()), entry.getValue());
                            }
                            store.createQueue(queue, ftArgs);
                        } else {
                            store.createQueue(queue);
                        }
                    }
                    queueRegistry.registerQueue(queue);
                    ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(session);
                    Exchange defaultExchange = exchangeRegistry.getDefaultExchange();
                    virtualHost.getBindingFactory().addBinding(queueName, queue, defaultExchange, null);
                    if (method.hasAutoDelete() && method.getAutoDelete() && method.hasExclusive() && method.getExclusive()) {
                        q = queue;
                        final ServerSession.Task deleteQueueTask = new ServerSession.Task(){

                            public void doTask(ServerSession session) {
                                try {
                                    q.delete();
                                }
                                catch (AMQException e) {
                                    ServerSessionDelegate.this.exception(session, (Method)method, e, "Cannot delete '" + method.getQueue());
                                }
                            }
                        };
                        s = (ServerSession)session;
                        s.addSessionCloseTask(deleteQueueTask);
                        queue.addQueueDeleteTask(new AMQQueue.Task(){

                            public void doTask(AMQQueue queue) throws AMQException {
                                s.removeSessionCloseTask(deleteQueueTask);
                            }
                        });
                    }
                    if (method.hasExclusive() && method.getExclusive()) {
                        q = queue;
                        final ServerSession.Task removeExclusive = new ServerSession.Task(){

                            public void doTask(ServerSession session) {
                                q.setAuthorizationHolder(null);
                                q.setExclusiveOwningSession(null);
                            }
                        };
                        s = (ServerSession)session;
                        q.setExclusiveOwningSession(s);
                        s.addSessionCloseTask(removeExclusive);
                        queue.addQueueDeleteTask(new AMQQueue.Task(){

                            public void doTask(AMQQueue queue) throws AMQException {
                                s.removeSessionCloseTask(removeExclusive);
                            }
                        });
                    }
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot declare queue '" + queueName);
                }
            } else if (method.getExclusive() && queue.getExclusiveOwningSession() != null && !queue.getExclusiveOwningSession().equals(session)) {
                String description = "Cannot declare queue('" + queueName + "')," + " as exclusive queue with same name " + "declared on another session";
                ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                this.exception(session, (Method)method, errorCode, description);
                return;
            }
        }
    }

    private boolean convertBooleanValue(Object argValue) {
        if (argValue instanceof Boolean && ((Boolean)argValue).booleanValue()) {
            return true;
        }
        if (argValue instanceof String && Boolean.parseBoolean((String)argValue)) {
            return true;
        }
        return argValue instanceof Number && ((Number)argValue).intValue() != 0;
    }

    protected AMQQueue createQueue(String queueName, QueueDeclare body, VirtualHost virtualHost, ServerSession session) throws AMQException {
        String owner = body.getExclusive() ? session.getClientID() : null;
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(UUIDGenerator.generateQueueUUID(queueName, virtualHost.getName()), queueName, body.getDurable(), owner, body.getAutoDelete(), body.getExclusive(), virtualHost, body.getArguments());
        return queue;
    }

    public void queueDelete(Session session, QueueDelete method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "No queue name supplied");
        } else {
            AMQQueue queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else if (queue.getAuthorizationHolder() != null && queue.getAuthorizationHolder() != session) {
                this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
            } else if (queue.isExclusive() && queue.getExclusiveOwningSession() != null && queue.getExclusiveOwningSession() != session) {
                this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
            } else if (method.getIfEmpty() && !queue.isEmpty()) {
                this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " not empty");
            } else if (method.getIfUnused() && !queue.isUnused()) {
                this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " in use");
            } else {
                VirtualHost virtualHost = this.getVirtualHost(session);
                try {
                    queue.delete();
                    if (queue.isDurable() && !queue.isAutoDelete()) {
                        MessageStore store = virtualHost.getMessageStore();
                        store.removeQueue(queue);
                    }
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot delete queue '" + queueName);
                }
            }
        }
    }

    public void queuePurge(Session session, QueuePurge method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "No queue name supplied");
        } else {
            AMQQueue queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else {
                try {
                    queue.clearQueue();
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot purge queue '" + queueName);
                }
            }
        }
    }

    public void queueQuery(Session session, QueueQuery method) {
        QueueQueryResult result = new QueueQueryResult();
        AMQQueue queue = this.getQueue(session, method.getQueue());
        if (queue != null) {
            result.setQueue(queue.getNameShortString().toString());
            result.setDurable(queue.isDurable());
            result.setExclusive(queue.isExclusive());
            result.setAutoDelete(queue.isAutoDelete());
            result.setArguments(queue.getArguments());
            result.setMessageCount((long)queue.getMessageCount());
            result.setSubscriberCount((long)queue.getConsumerCount());
        }
        session.executionResult(method.getId(), (Struct)result, new Option[0]);
    }

    public void messageSetFlowMode(Session session, MessageSetFlowMode sfm) {
        String destination = sfm.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)sfm, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else if (sub.isStopped()) {
            sub.setFlowMode(sfm.getFlowMode());
        }
    }

    public void messageStop(Session session, MessageStop stop) {
        String destination = stop.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)stop, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.stop();
        }
    }

    public void messageFlow(Session session, MessageFlow flow) {
        String destination = flow.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)flow, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.addCredit(flow.getUnit(), flow.getValue());
        }
    }

    public void closed(Session session) {
        this.setThreadSubject(session);
        ServerSession serverSession = (ServerSession)session;
        serverSession.stopSubscriptions();
        serverSession.onClose();
        serverSession.unregisterSubscriptions();
    }

    public void detached(Session session) {
        this.closed(session);
    }

    private void setThreadSubject(Session session) {
        ServerConnection scon = (ServerConnection)session.getConnection();
        SecurityManager.setThreadSubject(scon.getAuthorizedSubject());
    }

    private static class CommandProcessedAction
    implements ServerTransaction.Action {
        private final ServerSession _serverSession;
        private final Method _method;

        public CommandProcessedAction(ServerSession serverSession, Method xfr) {
            this._serverSession = serverSession;
            this._method = xfr;
        }

        public void postCommit() {
            this._serverSession.processed(this._method);
        }

        public void onRollback() {
        }
    }
}

