/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransaction
implements ServerTransaction {
    protected static final Logger _logger = LoggerFactory.getLogger(LocalTransaction.class);
    private final List<ServerTransaction.Action> _postTransactionActions = new ArrayList<ServerTransaction.Action>();
    private volatile Transaction _transaction;
    private final ActivityTimeAccessor _activityTime;
    private final MessageStore _transactionLog;
    private volatile long _txnStartTime = 0L;
    private volatile long _txnUpdateTime = 0L;
    private StoreFuture _asyncTran;

    public LocalTransaction(MessageStore transactionLog) {
        this(transactionLog, new ActivityTimeAccessor(){

            public long getActivityTime() {
                return System.currentTimeMillis();
            }
        });
    }

    public LocalTransaction(MessageStore transactionLog, ActivityTimeAccessor activityTime) {
        this._transactionLog = transactionLog;
        this._activityTime = activityTime;
    }

    @Override
    public long getTransactionStartTime() {
        return this._txnStartTime;
    }

    @Override
    public long getTransactionUpdateTime() {
        return this._txnUpdateTime;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._postTransactionActions.add(postTransactionAction);
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._postTransactionActions.add(postTransactionAction);
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        if (message.isPersistent() && queue.isDurable()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(queue, message);
            }
            catch (AMQException e) {
                _logger.error("Error during message dequeues", (Throwable)e);
                this.tidyUpOnError((Exception)((Object)e));
            }
        }
    }

    @Override
    public void dequeue(Collection<QueueEntry> queueEntries, ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._postTransactionActions.add(postTransactionAction);
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        try {
            for (QueueEntry entry : queueEntries) {
                ServerMessage message = entry.getMessage();
                AMQQueue queue = entry.getQueue();
                if (!message.isPersistent() || !queue.isDurable()) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(queue, message);
            }
        }
        catch (AMQException e) {
            _logger.error("Error during message dequeues", (Throwable)e);
            this.tidyUpOnError((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyUpOnError(Exception e) {
        try {
            this.doRollbackActions();
        }
        finally {
            try {
                if (this._transaction != null) {
                    this._transaction.abortTran();
                }
            }
            catch (Exception abortException) {
                _logger.error("Abort transaction failed while trying to handle previous error", (Throwable)abortException);
            }
            finally {
                this.resetDetails();
            }
        }
        throw new RuntimeException(e);
    }

    private void beginTranIfNecessary() {
        if (this._transaction == null) {
            try {
                this._transaction = this._transactionLog.newTransaction();
            }
            catch (Exception e) {
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._postTransactionActions.add(postTransactionAction);
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        if (message.isPersistent() && queue.isDurable()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.enqueueMessage(queue, message);
            }
            catch (Exception e) {
                _logger.error("Error during message enqueue", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._postTransactionActions.add(postTransactionAction);
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        if (message.isPersistent()) {
            try {
                for (BaseQueue baseQueue : queues) {
                    if (!baseQueue.isDurable()) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + baseQueue.getNameShortString());
                    }
                    this.beginTranIfNecessary();
                    this._transaction.enqueueMessage(baseQueue, message);
                }
            }
            catch (Exception e) {
                _logger.error("Error during message enqueue", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void commit() {
        this.sync();
        this.commit(null);
    }

    @Override
    public void commit(Runnable immediateAction) {
        this.sync();
        try {
            if (this._transaction != null) {
                this._transaction.commitTran();
            }
            if (immediateAction != null) {
                immediateAction.run();
            }
            this.doPostTransactionActions();
        }
        catch (Exception e) {
            _logger.error("Failed to commit transaction", (Throwable)e);
            this.doRollbackActions();
            throw new RuntimeException("Failed to commit transaction", e);
        }
        finally {
            this.resetDetails();
        }
    }

    private void doRollbackActions() {
        for (ServerTransaction.Action action : this._postTransactionActions) {
            action.onRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFuture commitAsync(final Runnable deferred) {
        this.sync();
        try {
            StoreFuture future = StoreFuture.IMMEDIATE_FUTURE;
            if (this._transaction != null) {
                this._asyncTran = future = new StoreFuture(){
                    private volatile boolean _completed = false;
                    private StoreFuture _underlying = LocalTransaction.access$000(LocalTransaction.this).commitTranAsync();

                    public boolean isComplete() {
                        return this._completed || this.checkUnderlyingCompletion();
                    }

                    public void waitForCompletion() {
                        if (!this._completed) {
                            this._underlying.waitForCompletion();
                            this.checkUnderlyingCompletion();
                        }
                    }

                    private synchronized boolean checkUnderlyingCompletion() {
                        if (!this._completed && this._underlying.isComplete()) {
                            this.completeDeferredWork();
                            this._completed = true;
                        }
                        return this._completed;
                    }

                    private void completeDeferredWork() {
                        try {
                            LocalTransaction.this.doPostTransactionActions();
                            deferred.run();
                        }
                        catch (Exception e) {
                            _logger.error("Failed to commit transaction", (Throwable)e);
                            LocalTransaction.this.doRollbackActions();
                            throw new RuntimeException("Failed to commit transaction", e);
                        }
                        finally {
                            LocalTransaction.this.resetDetails();
                        }
                    }
                };
            } else {
                try {
                    this.doPostTransactionActions();
                    deferred.run();
                }
                finally {
                    this.resetDetails();
                }
            }
            return future;
        }
        catch (Exception e) {
            _logger.error("Failed to commit transaction", (Throwable)e);
            try {
                this.doRollbackActions();
            }
            finally {
                this.resetDetails();
            }
            throw new RuntimeException("Failed to commit transaction", e);
        }
    }

    private void doPostTransactionActions() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Beginning " + this._postTransactionActions.size() + " post transaction actions");
        }
        for (int i = 0; i < this._postTransactionActions.size(); ++i) {
            this._postTransactionActions.get(i).postCommit();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Completed post transaction actions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.sync();
        try {
            if (this._transaction != null) {
                this._transaction.abortTran();
            }
        }
        catch (AMQException e) {
            _logger.error("Failed to rollback transaction", (Throwable)e);
            throw new RuntimeException("Failed to rollback transaction", e);
        }
        finally {
            try {
                this.doRollbackActions();
            }
            finally {
                this.resetDetails();
            }
        }
    }

    public void sync() {
        if (this._asyncTran != null) {
            this._asyncTran.waitForCompletion();
            this._asyncTran = null;
        }
    }

    private void initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime() {
        long currentTime = this._activityTime.getActivityTime();
        if (this._txnStartTime == 0L) {
            this._txnStartTime = currentTime;
        }
        this._txnUpdateTime = currentTime;
    }

    private void resetDetails() {
        this._asyncTran = null;
        this._transaction = null;
        this._postTransactionActions.clear();
        this._txnStartTime = 0L;
        this._txnUpdateTime = 0L;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    static /* synthetic */ Transaction access$000(LocalTransaction x0) {
        return x0._transaction;
    }

    public static interface ActivityTimeAccessor {
        public long getActivityTime();
    }
}

