/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.apache.qpid.configuration.CommonProperties;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.configuration.updater.TaskExecutorImpl;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LoggingMessageLogger;
import org.apache.qpid.server.logging.MessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.logback.QpidLoggerTurboFilter;
import org.apache.qpid.server.logging.logback.StartupAppender;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.plugin.PluggableFactoryLoader;
import org.apache.qpid.server.plugin.SystemConfigFactory;
import org.apache.qpid.server.security.auth.TaskPrincipal;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broker {
    private static final Logger LOGGER = LoggerFactory.getLogger(Broker.class);
    private EventLogger _eventLogger;
    private final TaskExecutor _taskExecutor = new TaskExecutorImpl();
    private volatile SystemConfig _systemConfig;
    private final Action<Integer> _shutdownAction;
    private final Principal _systemPrincipal = new SystemPrincipal();
    private final Subject _brokerTaskSubject;

    public Broker() {
        this(null);
    }

    public Broker(Action<Integer> shutdownAction) {
        this._shutdownAction = shutdownAction;
        this._brokerTaskSubject = new Subject(true, new HashSet<Principal>(Arrays.asList(this._systemPrincipal, new TaskPrincipal("Broker"))), Collections.emptySet(), Collections.emptySet());
    }

    public Principal getSystemPrincipal() {
        return this._systemPrincipal;
    }

    public void shutdown() {
        this.shutdown(0);
    }

    public void shutdown(int exitStatusCode) {
        try {
            if (this._systemConfig != null) {
                ListenableFuture closeResult = this._systemConfig.closeAsync();
                closeResult.get(30000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.warn("Attempting to cleanly shutdown took too long, exiting immediately");
        }
        finally {
            this.cleanUp(exitStatusCode);
        }
    }

    private void cleanUp(int exitStatusCode) {
        this._taskExecutor.stop();
        if (this._shutdownAction != null) {
            this._shutdownAction.performAction((Object)exitStatusCode);
        }
        this._systemConfig = null;
    }

    public void startup() throws Exception {
        this.startup(new BrokerOptions());
    }

    public void startup(final BrokerOptions options) throws Exception {
        this._eventLogger = new EventLogger((MessageLogger)new SystemOutMessageLogger());
        Subject.doAs(this._brokerTaskSubject, new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
                if (!logger.iteratorForAppenders().hasNext()) {
                    logger.setLevel(Level.ALL);
                    logger.setAdditive(true);
                }
                StartupAppender startupAppender = new StartupAppender();
                startupAppender.setContext((Context)logger.getLoggerContext());
                startupAppender.start();
                logger.addAppender((Appender)startupAppender);
                try {
                    Broker.this.startupImpl(options);
                }
                catch (RuntimeException e) {
                    LOGGER.error("Exception during startup", (Throwable)e);
                    startupAppender.logToConsole();
                    Broker.this.closeSystemConfigAndCleanUp();
                }
                finally {
                    logger.detachAppender((Appender)startupAppender);
                    startupAppender.stop();
                }
                return null;
            }
        });
    }

    private void startupImpl(BrokerOptions options) throws Exception {
        Broker.populateSystemPropertiesFromDefaults(options.getInitialSystemProperties());
        String storeType = options.getConfigurationStoreType();
        boolean statusUpdatesEnabled = Boolean.parseBoolean(System.getProperty("qpid.broker_status_updates", "true"));
        LoggingMessageLogger messageLogger = new LoggingMessageLogger(statusUpdatesEnabled);
        this._eventLogger.setMessageLogger((MessageLogger)messageLogger);
        PluggableFactoryLoader configFactoryLoader = new PluggableFactoryLoader(SystemConfigFactory.class);
        SystemConfigFactory configFactory = (SystemConfigFactory)configFactoryLoader.get(storeType);
        if (configFactory == null) {
            LOGGER.error("Unknown config store type '" + storeType + "', only the following types are supported: " + configFactoryLoader.getSupportedTypes());
            throw new IllegalArgumentException("Unknown config store type '" + storeType + "', only the following types are supported: " + configFactoryLoader.getSupportedTypes());
        }
        this._taskExecutor.start();
        this._systemConfig = configFactory.newInstance(this._taskExecutor, this._eventLogger, this._systemPrincipal, options.convertToSystemConfigAttributes());
        this._systemConfig.setOnContainerResolveTask(new Runnable(){

            @Override
            public void run() {
                ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
                StartupAppender startupAppender = (StartupAppender)rootLogger.getAppender(StartupAppender.class.getName());
                if (startupAppender != null) {
                    rootLogger.detachAppender((Appender)startupAppender);
                    startupAppender.stop();
                }
            }
        });
        this._systemConfig.setOnContainerCloseTask(new Runnable(){

            @Override
            public void run() {
                QpidLoggerTurboFilter.uninstallFromRootContext();
            }
        });
        this._systemConfig.open();
        if (this._systemConfig.getChild(org.apache.qpid.server.model.Broker.class).getState() == State.ERRORED) {
            throw new RuntimeException("Closing broker as it cannot operate due to errors");
        }
    }

    private void closeSystemConfigAndCleanUp() {
        try {
            if (this._systemConfig != null) {
                try {
                    this._systemConfig.close();
                }
                catch (Exception ce) {
                    LOGGER.debug("An error occurred when closing the system config following initialization failure", (Throwable)ce);
                }
            }
        }
        finally {
            this.cleanUp(1);
        }
    }

    public static void populateSystemPropertiesFromDefaults(String initialProperties) throws IOException {
        URL initialPropertiesLocation = initialProperties == null ? Broker.class.getClassLoader().getResource("system.properties") : new File(initialProperties).toURI().toURL();
        Properties props = new Properties(CommonProperties.asProperties());
        if (initialPropertiesLocation != null) {
            InputStream inStream = initialPropertiesLocation.openStream();
            Object object = null;
            try {
                props.load(inStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inStream != null) {
                    if (object != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inStream.close();
                    }
                }
            }
        }
        HashSet<String> propertyNames = new HashSet<String>(props.stringPropertyNames());
        propertyNames.removeAll(System.getProperties().stringPropertyNames());
        for (String propName : propertyNames) {
            System.setProperty(propName, props.getProperty(propName));
        }
    }

    private static final class SystemPrincipal
    implements Principal {
        private SystemPrincipal() {
        }

        @Override
        public String getName() {
            return "SYSTEM";
        }
    }
}

