/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.facade.JmsStreamMessageFacade;

public class JmsStreamMessage
extends JmsMessage
implements StreamMessage {
    private static final int NO_BYTES_IN_FLIGHT = -1;
    private final JmsStreamMessageFacade facade;
    private byte[] bytes;
    private int remainingBytes = -1;

    public JmsStreamMessage(JmsStreamMessageFacade facade) {
        super(facade);
        this.facade = facade;
    }

    @Override
    public JmsStreamMessage copy() throws JMSException {
        JmsStreamMessage other = new JmsStreamMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    @Override
    public void onSend(boolean disableMessageId, boolean disableTimestamp, long producerTtl) throws JMSException {
        super.onSend(disableMessageId, disableTimestamp, producerTtl);
        this.reset();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.bytes = null;
        this.remainingBytes = -1;
    }

    public boolean readBoolean() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Boolean result = null;
        Object value = this.facade.peek();
        if (value instanceof Boolean) {
            result = (Boolean)value;
        } else if (value instanceof String || value == null) {
            result = Boolean.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result;
    }

    public byte readByte() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Byte result = null;
        Object value = this.facade.peek();
        if (value instanceof Byte) {
            result = (Byte)value;
        } else if (value instanceof String || value == null) {
            result = Byte.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result;
    }

    public short readShort() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Short result = null;
        Object value = this.facade.peek();
        if (value instanceof Short) {
            result = (Short)value;
        } else if (value instanceof Byte) {
            result = ((Byte)value).shortValue();
        } else if (value instanceof String || value == null) {
            result = Short.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result;
    }

    public char readChar() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Character result = null;
        Object value = this.facade.peek();
        if (!(value instanceof Character)) {
            if (value == null) {
                throw new NullPointerException("Cannot convert NULL value to char.");
            }
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        result = (Character)value;
        this.facade.pop();
        return result.charValue();
    }

    public int readInt() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Integer result = null;
        Object value = this.facade.peek();
        if (value instanceof Integer) {
            result = (Integer)value;
        } else if (value instanceof Short) {
            result = ((Short)value).intValue();
        } else if (value instanceof Byte) {
            result = ((Byte)value).intValue();
        } else if (value instanceof String || value == null) {
            result = Integer.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result;
    }

    public long readLong() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Long result = null;
        Object value = this.facade.peek();
        if (value instanceof Long) {
            result = (Long)value;
        } else if (value instanceof Integer) {
            result = ((Integer)value).longValue();
        } else if (value instanceof Short) {
            result = ((Short)value).longValue();
        } else if (value instanceof Byte) {
            result = ((Byte)value).longValue();
        } else if (value instanceof String || value == null) {
            result = Long.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result;
    }

    public float readFloat() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Float result = null;
        Object value = this.facade.peek();
        if (value instanceof Float) {
            result = (Float)value;
        } else if (value instanceof String || value == null) {
            result = Float.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result.floatValue();
    }

    public double readDouble() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Double result = null;
        Object value = this.facade.peek();
        if (value instanceof Double) {
            result = (Double)value;
        } else if (value instanceof Float) {
            result = ((Float)value).doubleValue();
        } else if (value instanceof String || value == null) {
            result = Double.valueOf((String)value);
        } else {
            throw new MessageFormatException("stream value: " + value.getClass().getSimpleName() + " cannot be converted to a boolean.");
        }
        this.facade.pop();
        return result;
    }

    public String readString() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        String result = null;
        Object value = this.facade.peek();
        if (value == null) {
            result = null;
        } else if (value instanceof String) {
            result = (String)value;
        } else if (value instanceof Float) {
            result = value.toString();
        } else if (value instanceof Double) {
            result = value.toString();
        } else if (value instanceof Long) {
            result = value.toString();
        } else if (value instanceof Integer) {
            result = value.toString();
        } else if (value instanceof Short) {
            result = value.toString();
        } else if (value instanceof Byte) {
            result = value.toString();
        } else if (value instanceof Boolean) {
            result = value.toString();
        } else if (value instanceof Character) {
            result = value.toString();
        } else {
            throw new MessageFormatException("stream cannot convert byte array to String");
        }
        this.facade.pop();
        return result;
    }

    public int readBytes(byte[] target) throws JMSException {
        this.checkWriteOnlyBody();
        if (target == null) {
            throw new NullPointerException("target byte array was null");
        }
        if (this.remainingBytes == -1) {
            Object data = this.facade.peek();
            if (data == null) {
                this.facade.pop();
                return -1;
            }
            if (!(data instanceof byte[])) {
                throw new MessageFormatException("Next stream value is not a byte array");
            }
            this.bytes = (byte[])data;
            this.remainingBytes = this.bytes.length;
        } else if (this.remainingBytes == 0) {
            this.remainingBytes = -1;
            this.bytes = null;
            this.facade.pop();
            return -1;
        }
        int previouslyRead = this.bytes.length - this.remainingBytes;
        int lengthToCopy = Math.min(target.length, this.remainingBytes);
        if (lengthToCopy > 0) {
            System.arraycopy(this.bytes, previouslyRead, target, 0, lengthToCopy);
        }
        this.remainingBytes -= lengthToCopy;
        if (this.remainingBytes == 0 && lengthToCopy < target.length) {
            this.remainingBytes = -1;
            this.bytes = null;
            this.facade.pop();
        }
        return lengthToCopy;
    }

    public Object readObject() throws JMSException {
        this.checkWriteOnlyBody();
        this.checkBytesInFlight();
        Object result = null;
        Object value = this.facade.peek();
        if (value == null) {
            result = null;
        } else if (value instanceof String) {
            result = value;
        } else if (value instanceof Float) {
            result = value;
        } else if (value instanceof Double) {
            result = value;
        } else if (value instanceof Long) {
            result = value;
        } else if (value instanceof Integer) {
            result = value;
        } else if (value instanceof Short) {
            result = value;
        } else if (value instanceof Byte) {
            result = value;
        } else if (value instanceof Boolean) {
            result = value;
        } else if (value instanceof Character) {
            result = value;
        } else if (value instanceof byte[]) {
            byte[] original = (byte[])value;
            result = new byte[original.length];
            System.arraycopy(original, 0, result, 0, original.length);
        } else {
            throw new MessageFormatException("Unknown type found in stream");
        }
        this.facade.pop();
        return result;
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeShort(short value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeChar(char value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(Character.valueOf(value));
    }

    public void writeInt(int value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeLong(long value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(Float.valueOf(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeString(String value) throws JMSException {
        this.checkReadOnlyBody();
        this.facade.put(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkReadOnlyBody();
        byte[] copy = new byte[length];
        System.arraycopy(value, offset, copy, 0, length);
        this.facade.put(copy);
    }

    public void writeObject(Object value) throws JMSException {
        this.checkReadOnlyBody();
        if (value == null) {
            this.facade.put(null);
        } else if (value instanceof String) {
            this.facade.put(value);
        } else if (value instanceof Character) {
            this.facade.put(value);
        } else if (value instanceof Boolean) {
            this.facade.put(value);
        } else if (value instanceof Byte) {
            this.facade.put(value);
        } else if (value instanceof Short) {
            this.facade.put(value);
        } else if (value instanceof Integer) {
            this.facade.put(value);
        } else if (value instanceof Long) {
            this.facade.put(value);
        } else if (value instanceof Float) {
            this.facade.put(value);
        } else if (value instanceof Double) {
            this.facade.put(value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Unsupported Object type: " + value.getClass().getSimpleName());
        }
    }

    public void reset() throws JMSException {
        this.bytes = null;
        this.remainingBytes = -1;
        this.setReadOnlyBody(true);
        this.facade.reset();
    }

    @Override
    public String toString() {
        return "JmsStreamMessage { " + this.facade.toString() + " }";
    }

    private void checkBytesInFlight() throws MessageFormatException {
        if (this.remainingBytes != -1) {
            throw new MessageFormatException("Partially read byte[] entry still being retrieved using readBytes(byte[] dest)");
        }
    }
}

