/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.facade.JmsObjectMessageFacade;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.jms.provider.amqp.message.AmqpSerializedObjectDelegate;
import org.apache.qpid.jms.provider.amqp.message.AmqpTypedObjectDelegate;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsObjectMessageFacade
extends AmqpJmsMessageFacade
implements JmsObjectMessageFacade {
    private AmqpObjectTypeDelegate delegate;

    public AmqpJmsObjectMessageFacade(AmqpConnection connection, boolean isAmqpTypeEncoded) {
        super(connection);
        this.setMessageAnnotation("x-opt-jms-msg-type", (byte)1);
        this.initDelegate(isAmqpTypeEncoded);
    }

    public AmqpJmsObjectMessageFacade(AmqpConsumer consumer, Message message) {
        super(consumer, message);
        boolean javaSerialized = "application/x-java-serialized-object".equals(message.getContentType());
        this.initDelegate(!javaSerialized);
    }

    @Override
    public byte getJmsMsgType() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.getAmqpMessage().getBody() == null;
    }

    public boolean isAmqpTypedEncoding() {
        return this.delegate.isAmqpTypeEncoded();
    }

    @Override
    public AmqpJmsObjectMessageFacade copy() throws JMSException {
        AmqpJmsObjectMessageFacade copy = new AmqpJmsObjectMessageFacade(this.connection, this.isAmqpTypedEncoding());
        this.copyInto(copy);
        try {
            copy.setObject(this.getObject());
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create("Failed to copy object value", e);
        }
        return copy;
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        return this.delegate.getObject();
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        this.delegate.setObject(value);
    }

    @Override
    public void clearBody() {
        try {
            this.setObject(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onSend(boolean disableMsgId, boolean disableTimestamp, long producerTtl) throws JMSException {
        super.onSend(disableMsgId, disableTimestamp, producerTtl);
        this.delegate.onSend();
    }

    void setUseAmqpTypedEncoding(boolean useAmqpTypedEncoding) throws JMSException {
        if (useAmqpTypedEncoding != this.delegate.isAmqpTypeEncoded()) {
            try {
                Serializable existingObject = this.delegate.getObject();
                AmqpObjectTypeDelegate newDelegate = null;
                newDelegate = useAmqpTypedEncoding ? new AmqpTypedObjectDelegate(this.message) : new AmqpSerializedObjectDelegate(this.message);
                newDelegate.setObject(existingObject);
                this.delegate = newDelegate;
            }
            catch (IOException | ClassNotFoundException e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    private void initDelegate(boolean useAmqpTypes) {
        this.delegate = !useAmqpTypes ? new AmqpSerializedObjectDelegate(this.getAmqpMessage()) : new AmqpTypedObjectDelegate(this.getAmqpMessage());
    }

    AmqpObjectTypeDelegate getDelegate() {
        return this.delegate;
    }
}

