/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.jms.util.ClassLoadingAwareObjectInputStream;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpSerializedObjectDelegate
implements AmqpObjectTypeDelegate {
    public static final String CONTENT_TYPE = "application/x-java-serialized-object";
    private final Message message;

    public AmqpSerializedObjectDelegate(Message message) {
        this.message = message;
        this.message.setContentType(CONTENT_TYPE);
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        Binary bin = null;
        Section body = this.message.getBody();
        if (body == null) {
            return null;
        }
        if (!(body instanceof Data)) {
            throw new IllegalStateException("Unexpected body type: " + body.getClass().getSimpleName());
        }
        bin = ((Data)body).getValue();
        if (bin == null) {
            return null;
        }
        Serializable serialized = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bin.getArray(), bin.getArrayOffset(), bin.getLength());
             ClassLoadingAwareObjectInputStream objIn = new ClassLoadingAwareObjectInputStream(bais);){
            serialized = (Serializable)objIn.readObject();
        }
        return serialized;
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        if (value == null) {
            this.message.setBody(null);
        } else {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(value);
                oos.flush();
                oos.close();
                byte[] bytes = baos.toByteArray();
                this.message.setBody((Section)new Data(new Binary(bytes)));
            }
        }
    }

    @Override
    public void onSend() {
        this.message.setContentType(CONTENT_TYPE);
    }

    @Override
    public boolean isAmqpTypeEncoded() {
        return false;
    }
}

