/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpTypedObjectDelegate
implements AmqpObjectTypeDelegate {
    private final Message message;

    public AmqpTypedObjectDelegate(Message message) {
        this.message = message;
        this.message.setContentType(null);
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        Section body = this.message.getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof AmqpValue) {
            return (Serializable)((AmqpValue)body).getValue();
        }
        if (body instanceof Data) {
            throw new UnsupportedOperationException("Data support still to be added");
        }
        if (body instanceof AmqpSequence) {
            return (Serializable)((Object)((AmqpSequence)body).getValue());
        }
        throw new IllegalStateException("Unexpected body type: " + body.getClass().getSimpleName());
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        if (value == null) {
            this.message.setBody(null);
        } else if (this.isSupportedAmqpValueObjectType(value)) {
            this.message.setBody((Section)new AmqpValue((Object)value));
        } else {
            throw new IllegalArgumentException("Encoding this object type with the AMQP type system is not supported: " + value.getClass().getName());
        }
    }

    @Override
    public void onSend() {
        this.message.setContentType(null);
    }

    private boolean isSupportedAmqpValueObjectType(Serializable serializable) {
        return serializable instanceof String || serializable instanceof Map || serializable instanceof List || serializable.getClass().isArray();
    }

    @Override
    public boolean isAmqpTypeEncoded() {
        return true;
    }
}

