/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.failover;

import java.net.URI;
import java.util.Map;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.failover.FailoverProvider;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.URISupport;

public class FailoverProviderFactory
extends ProviderFactory {
    @Override
    public Provider createProvider(URI remoteURI) throws Exception {
        URISupport.CompositeData composite = URISupport.parseComposite(remoteURI);
        Map<String, String> options = composite.getParameters();
        Map<String, String> filtered = PropertyUtil.filterProperties(options, "failover.");
        Map<String, String> nested = PropertyUtil.filterProperties(filtered, "nested.");
        FailoverProvider provider = new FailoverProvider(composite.getComponents(), nested);
        Map<String, String> unused = PropertyUtil.setProperties((Object)provider, filtered);
        if (!unused.isEmpty()) {
            String msg = " Not all options could be set on the Failover provider. Check the options are spelled correctly. Unused parameters=[" + unused + "]." + " This Provider cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        return provider;
    }

    @Override
    public String getName() {
        return "Failover";
    }
}

