/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.failover;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.qpid.jms.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverUriPool {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverUriPool.class);
    public static final boolean DEFAULT_RANDOMIZE_ENABLED = false;
    private final LinkedList<URI> uris = new LinkedList();
    private final Map<String, String> nestedOptions;
    private boolean randomize = false;

    public FailoverUriPool() {
        this.nestedOptions = Collections.emptyMap();
    }

    public FailoverUriPool(List<URI> uris, Map<String, String> nestedOptions) {
        this.nestedOptions = nestedOptions != null ? nestedOptions : Collections.emptyMap();
        if (uris != null) {
            for (URI uri : uris) {
                this.add(uri);
            }
        }
    }

    public int size() {
        return this.uris.size();
    }

    public boolean isEmpty() {
        return this.uris.isEmpty();
    }

    public URI getNext() {
        URI next = null;
        if (!this.uris.isEmpty()) {
            next = this.uris.removeFirst();
            this.uris.addLast(next);
        }
        return next;
    }

    public void connected() {
        if (this.isRandomize()) {
            Collections.shuffle(this.uris);
        }
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
        if (randomize) {
            Collections.shuffle(this.uris);
        }
    }

    public void add(URI uri) {
        if (uri != null && !this.contains(uri)) {
            if (!this.nestedOptions.isEmpty()) {
                try {
                    uri = URISupport.applyParameters(uri, this.nestedOptions);
                }
                catch (URISyntaxException e) {
                    LOG.debug("Failed to add nested options to uri: {}", (Object)uri);
                }
            }
            this.uris.add(uri);
        }
    }

    public void remove(URI uri) {
        this.uris.remove(uri);
    }

    public Map<String, String> getNestedOptions() {
        return this.nestedOptions;
    }

    private boolean contains(URI newURI) {
        boolean result = false;
        for (URI uri : this.uris) {
            if (!this.compareURIs(newURI, uri)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean compareURIs(URI first, URI second) {
        boolean result;
        block7: {
            result = false;
            if (first == null || second == null) {
                return result;
            }
            if (first.getPort() == second.getPort()) {
                InetAddress firstAddr = null;
                InetAddress secondAddr = null;
                try {
                    firstAddr = InetAddress.getByName(first.getHost());
                    secondAddr = InetAddress.getByName(second.getHost());
                    if (firstAddr.equals(secondAddr)) {
                        result = true;
                    }
                }
                catch (IOException e) {
                    if (firstAddr == null) {
                        LOG.error("Failed to Lookup INetAddress for URI[ " + first + " ] : " + e);
                    } else {
                        LOG.error("Failed to Lookup INetAddress for URI[ " + second + " ] : " + e);
                    }
                    if (!first.getHost().equalsIgnoreCase(second.getHost())) break block7;
                    result = true;
                }
            }
        }
        return result;
    }
}

