/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

public class TransportOptions {
    public static final int DEFAULT_SEND_BUFFER_SIZE = 65536;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65536;
    public static final int DEFAULT_TRAFFIC_CLASS = 0;
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final int DEFAULT_SO_LINGER = Integer.MIN_VALUE;
    public static final int DEFAULT_SO_TIMEOUT = -1;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final TransportOptions INSTANCE = new TransportOptions();
    private int sendBufferSize = 65536;
    private int receiveBufferSize = 65536;
    private int trafficClass = 0;
    private int connectTimeout = 60000;
    private int soTimeout = -1;
    private int soLinger = Integer.MIN_VALUE;
    private boolean tcpKeepAlive = false;
    private boolean tcpNoDelay = true;

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        if (sendBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        if (trafficClass < 0 || trafficClass > 255) {
            throw new IllegalArgumentException("Traffic class must be in the range [0..255]");
        }
        this.trafficClass = trafficClass;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public void setTcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public TransportOptions clone() {
        return this.copyOptions(new TransportOptions());
    }

    protected TransportOptions copyOptions(TransportOptions copy) {
        copy.setConnectTimeout(this.getConnectTimeout());
        copy.setReceiveBufferSize(this.getReceiveBufferSize());
        copy.setSendBufferSize(this.getSendBufferSize());
        copy.setSoLinger(this.getSoLinger());
        copy.setSoTimeout(this.getSoTimeout());
        copy.setTcpKeepAlive(this.isTcpKeepAlive());
        copy.setTcpNoDelay(this.isTcpNoDelay());
        copy.setTrafficClass(this.getTrafficClass());
        return copy;
    }
}

