/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.TransportSslOptions;
import org.apache.qpid.jms.transports.TransportSupport;
import org.apache.qpid.jms.transports.netty.NettyTcpTransport;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySslTransport
extends NettyTcpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(NettySslTransport.class);

    public NettySslTransport(URI remoteLocation, TransportOptions options) {
        this(null, remoteLocation, options);
    }

    public NettySslTransport(TransportListener listener, URI remoteLocation, TransportOptions options) {
        super(listener, remoteLocation, options);
    }

    @Override
    protected void configureChannel(Channel channel) throws Exception {
        channel.pipeline().addLast(new ChannelHandler[]{TransportSupport.createSslHandler(this.getRemoteLocation(), this.getSslOptions())});
        super.configureChannel(channel);
    }

    @Override
    protected void handleConnected(final Channel channel) throws Exception {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        Future channelFuture = sslHandler.handshakeFuture();
        channelFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

            public void operationComplete(Future<Channel> future) throws Exception {
                if (future.isSuccess()) {
                    LOG.trace("SSL Handshake has completed: {}", (Object)channel);
                    NettySslTransport.this.connectionEstablished(channel);
                } else {
                    LOG.trace("SSL Handshake has failed: {}", (Object)channel);
                    NettySslTransport.this.connectionFailed(IOExceptionSupport.create(future.cause()));
                }
            }
        });
    }

    @Override
    public TransportOptions getTransportOptions() {
        if (this.options == null) {
            this.options = TransportSslOptions.INSTANCE;
        }
        return this.options;
    }

    private TransportSslOptions getSslOptions() {
        return (TransportSslOptions)this.getTransportOptions();
    }
}

