/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.JmsTransactionContext;
import org.apache.qpid.jms.JmsTransactionListener;
import org.apache.qpid.jms.JmsTxSynchronization;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsLocalTransactionContext
implements JmsTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(JmsLocalTransactionContext.class);
    private List<JmsTxSynchronization> synchronizations;
    private final JmsSession session;
    private final JmsConnection connection;
    private JmsTransactionId transactionId;
    private boolean failed;
    private JmsTransactionListener listener;

    public JmsLocalTransactionContext(JmsSession session) {
        this.session = session;
        this.connection = session.getConnection();
    }

    @Override
    public void send(JmsConnection connection, JmsOutboundMessageDispatch envelope) throws JMSException {
        if (!this.isFailed()) {
            this.begin();
            connection.send(envelope);
        }
    }

    @Override
    public void acknowledge(JmsConnection connection, JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        if (ackType == ProviderConstants.ACK_TYPE.CONSUMED || ackType == ProviderConstants.ACK_TYPE.DELIVERED) {
            this.begin();
        }
        connection.acknowledge(envelope, ackType);
    }

    @Override
    public void addSynchronization(JmsTxSynchronization sync) throws JMSException {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<JmsTxSynchronization>(10);
        }
        try {
            if (sync.validate(this)) {
                this.synchronizations.add(sync);
            }
        }
        catch (Exception e) {
            throw JmsExceptionSupport.create(e);
        }
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void begin() throws JMSException {
        if (!this.isInTransaction()) {
            this.synchronizations = null;
            this.failed = false;
            this.transactionId = this.connection.getNextTransactionId();
            JmsTransactionInfo transaction = new JmsTransactionInfo(this.session.getSessionId(), this.transactionId);
            this.connection.createResource(transaction);
            if (this.listener != null) {
                this.listener.onTransactionStarted();
            }
            LOG.debug("Begin: {}", (Object)this.transactionId);
        }
    }

    @Override
    public void rollback() throws JMSException {
        if (this.isFailed()) {
            LOG.debug("Rollback of already failed TX: {} syncCount: {}", (Object)this.transactionId, (Object)(this.synchronizations != null ? this.synchronizations.size() : 0));
            this.failed = false;
            this.transactionId = null;
        }
        if (this.isInTransaction()) {
            LOG.debug("Rollback: {} syncCount: {}", (Object)this.transactionId, (Object)(this.synchronizations != null ? this.synchronizations.size() : 0));
            this.failed = false;
            this.transactionId = null;
            this.connection.rollback(this.session.getSessionId());
            if (this.listener != null) {
                this.listener.onTransactionRolledBack();
            }
        }
        this.afterRollback();
    }

    @Override
    public void commit() throws JMSException {
        if (this.isFailed()) {
            this.failed = false;
            this.transactionId = null;
            try {
                this.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new TransactionRolledBackException("Transaction failed and has been rolled back.");
        }
        if (this.isInTransaction()) {
            LOG.debug("Commit: {} syncCount: {}", (Object)this.transactionId, (Object)(this.synchronizations != null ? this.synchronizations.size() : 0));
            JmsTransactionId oldTransactionId = this.transactionId;
            this.transactionId = null;
            try {
                this.connection.commit(this.session.getSessionId());
                if (this.listener != null) {
                    this.listener.onTransactionCommitted();
                }
                this.afterCommit();
            }
            catch (JMSException cause) {
                LOG.info("Commit failed for transaction: {}", (Object)oldTransactionId);
                if (this.listener != null) {
                    this.listener.onTransactionRolledBack();
                }
                this.afterRollback();
                throw cause;
            }
        }
    }

    @Override
    public void onConnectionInterrupted() {
        if (this.isInTransaction()) {
            this.failed = true;
        }
    }

    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        this.transactionId = this.connection.getNextTransactionId();
        JmsTransactionInfo transaction = new JmsTransactionInfo(this.session.getSessionId(), this.transactionId);
        ProviderFuture request = new ProviderFuture();
        provider.create(transaction, request);
        request.sync();
    }

    public String toString() {
        return "JmsLocalTransactionContext{ transactionId=" + this.transactionId + " }";
    }

    @Override
    public JmsTransactionId getTransactionId() {
        return this.transactionId;
    }

    @Override
    public JmsTransactionListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(JmsTransactionListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    private void afterRollback() throws JMSException {
        if (this.synchronizations == null) {
            return;
        }
        Throwable firstException = null;
        int size = this.synchronizations.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.synchronizations.get(i).afterRollback();
                continue;
            }
            catch (Throwable thrown) {
                LOG.debug("Exception from afterRollback on " + this.synchronizations.get(i), thrown);
                if (firstException != null) continue;
                firstException = thrown;
            }
        }
        this.synchronizations = null;
        if (firstException != null) {
            throw JmsExceptionSupport.create(firstException);
        }
    }

    private void afterCommit() throws JMSException {
        if (this.synchronizations == null) {
            return;
        }
        Throwable firstException = null;
        int size = this.synchronizations.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.synchronizations.get(i).afterCommit();
                continue;
            }
            catch (Throwable thrown) {
                LOG.debug("Exception from afterCommit on " + this.synchronizations.get(i), thrown);
                if (firstException != null) continue;
                firstException = thrown;
            }
        }
        this.synchronizations = null;
        if (firstException != null) {
            throw JmsExceptionSupport.create(firstException);
        }
    }
}

