/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.exceptions.IdConversionException;
import org.apache.qpid.jms.message.facade.JmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessagePropertyIntercepter;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageIdHelper;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsMessageFacade
implements JmsMessageFacade {
    private static final int DEFAULT_PRIORITY = 4;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    protected final Message message;
    protected final AmqpConnection connection;
    private Map<Symbol, Object> messageAnnotationsMap;
    private Map<String, Object> applicationPropertiesMap;
    private JmsDestination replyTo;
    private JmsDestination destination;
    private JmsDestination consumerDestination;
    private Long syntheticExpiration;
    private Long userSpecifiedTTL = null;

    public AmqpJmsMessageFacade(AmqpConnection connection) {
        this.message = Proton.message();
        this.message.setDurable(true);
        this.connection = connection;
        this.setMessageAnnotation("x-opt-jms-msg-type", (byte)0);
    }

    public AmqpJmsMessageFacade(AmqpConsumer consumer, Message message) {
        this.message = message;
        this.connection = consumer.getConnection();
        this.consumerDestination = consumer.getDestination();
        if (message.getMessageAnnotations() != null) {
            this.messageAnnotationsMap = message.getMessageAnnotations().getValue();
        }
        if (message.getApplicationProperties() != null) {
            this.applicationPropertiesMap = message.getApplicationProperties().getValue();
        }
        Long ttl = this.getTtl();
        Long absoluteExpiryTime = this.getAbsoluteExpiryTime();
        if (absoluteExpiryTime == null && ttl != null) {
            this.syntheticExpiration = System.currentTimeMillis() + ttl;
        }
    }

    public byte getJmsMsgType() {
        return 0;
    }

    public String getContentType() {
        return this.message.getContentType();
    }

    public void setContentType(String value) {
        this.message.setContentType(value);
    }

    @Override
    public boolean propertyExists(String key) throws JMSException {
        return AmqpJmsMessagePropertyIntercepter.propertyExists(this, key);
    }

    public boolean applicationPropertyExists(String key) throws JMSException {
        if (this.applicationPropertiesMap != null) {
            return this.applicationPropertiesMap.containsKey(key);
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNames() {
        return AmqpJmsMessagePropertyIntercepter.getPropertyNames(this);
    }

    public Set<String> getApplicationPropertyNames(Set<String> propertyNames) {
        if (this.applicationPropertiesMap != null) {
            propertyNames.addAll(this.applicationPropertiesMap.keySet());
        }
        return propertyNames;
    }

    @Override
    public Object getProperty(String key) throws JMSException {
        return AmqpJmsMessagePropertyIntercepter.getProperty(this, key);
    }

    public Object getApplicationProperty(String key) throws JMSException {
        if (this.applicationPropertiesMap != null) {
            return this.applicationPropertiesMap.get(key);
        }
        return null;
    }

    @Override
    public void setProperty(String key, Object value) throws JMSException {
        if (key == null) {
            throw new IllegalArgumentException("Property key must not be null");
        }
        AmqpJmsMessagePropertyIntercepter.setProperty(this, key, value);
    }

    public void setApplicationProperty(String key, Object value) throws JMSException {
        this.lazyCreateApplicationProperties();
        this.applicationPropertiesMap.put(key, value);
    }

    @Override
    public void onSend(boolean disableMsgId, boolean disableTimestamp, long producerTtl) throws JMSException {
        long ttl = 0L;
        ttl = this.hasAmqpTimeToLiveOverride() ? this.getAmqpTimeToLiveOverride() : producerTtl;
        if (ttl > 0L && ttl < 0xFFFFFFFFL) {
            this.message.setTtl(ttl);
        } else {
            Header hdr = this.message.getHeader();
            if (hdr != null) {
                hdr.setTtl(null);
            }
        }
        if (disableMsgId) {
            this.setMessageId(null);
        }
        if (disableTimestamp) {
            this.setTimestamp(0L);
        }
        this.setMessageAnnotation("x-opt-jms-msg-type", this.getJmsMsgType());
    }

    @Override
    public void onDispatch() throws JMSException {
    }

    @Override
    public void clearBody() {
        this.message.setBody(null);
    }

    @Override
    public void clearProperties() throws JMSException {
        AmqpJmsMessagePropertyIntercepter.clearProperties(this);
    }

    @Override
    public AmqpJmsMessageFacade copy() throws JMSException {
        AmqpJmsMessageFacade copy = new AmqpJmsMessageFacade(this.connection);
        this.copyInto(copy);
        return copy;
    }

    protected void copyInto(AmqpJmsMessageFacade target) {
        if (this.consumerDestination != null) {
            target.consumerDestination = this.consumerDestination;
        }
        if (this.destination != null) {
            target.setDestination(this.destination);
        }
        if (this.replyTo != null) {
            target.setReplyTo(this.replyTo);
        }
        if (this.syntheticExpiration != null) {
            target.syntheticExpiration = this.syntheticExpiration;
        }
        if (this.userSpecifiedTTL != null) {
            target.userSpecifiedTTL = this.userSpecifiedTTL;
        }
        Message targetMsg = target.getAmqpMessage();
        if (this.message.getHeader() != null) {
            Header headers = new Header();
            headers.setDurable(this.message.getHeader().getDurable());
            headers.setPriority(this.message.getHeader().getPriority());
            headers.setTtl(this.message.getHeader().getTtl());
            headers.setFirstAcquirer(this.message.getHeader().getFirstAcquirer());
            headers.setDeliveryCount(this.message.getHeader().getDeliveryCount());
            targetMsg.setHeader(headers);
        }
        if (this.message.getFooter() != null && this.message.getFooter().getValue() != null) {
            HashMap newFooterMap = new HashMap();
            newFooterMap.putAll(this.message.getFooter().getValue());
            targetMsg.setFooter(new Footer(newFooterMap));
        }
        if (this.message.getProperties() != null) {
            Properties properties = new Properties();
            properties.setMessageId(this.message.getProperties().getMessageId());
            properties.setUserId(this.message.getProperties().getUserId());
            properties.setTo(this.message.getProperties().getTo());
            properties.setSubject(this.message.getProperties().getSubject());
            properties.setReplyTo(this.message.getProperties().getReplyTo());
            properties.setCorrelationId(this.message.getProperties().getCorrelationId());
            properties.setContentType(this.message.getProperties().getContentType());
            properties.setContentEncoding(this.message.getProperties().getContentEncoding());
            properties.setAbsoluteExpiryTime(this.message.getProperties().getAbsoluteExpiryTime());
            properties.setCreationTime(this.message.getProperties().getCreationTime());
            properties.setGroupId(this.message.getProperties().getGroupId());
            properties.setGroupSequence(this.message.getProperties().getGroupSequence());
            properties.setReplyToGroupId(this.message.getProperties().getReplyToGroupId());
            targetMsg.setProperties(properties);
        }
        if (this.message.getDeliveryAnnotations() != null && this.message.getDeliveryAnnotations().getValue() != null) {
            HashMap newDeliveryAnnotations = new HashMap();
            newDeliveryAnnotations.putAll(this.message.getDeliveryAnnotations().getValue());
            targetMsg.setFooter(new Footer(newDeliveryAnnotations));
        }
        if (this.applicationPropertiesMap != null) {
            target.lazyCreateApplicationProperties();
            target.applicationPropertiesMap.putAll(this.applicationPropertiesMap);
        }
        if (this.messageAnnotationsMap != null) {
            target.lazyCreateMessageAnnotations();
            target.messageAnnotationsMap.putAll(this.messageAnnotationsMap);
        }
    }

    @Override
    public String getMessageId() {
        AmqpMessageIdHelper helper = AmqpMessageIdHelper.INSTANCE;
        Object underlying = this.message.getMessageId();
        String baseStringId = helper.toBaseMessageIdString(underlying);
        if (baseStringId != null && !helper.hasMessageIdPrefix(baseStringId)) {
            baseStringId = "ID:" + baseStringId;
        }
        return baseStringId;
    }

    @Override
    public Object getProviderMessageIdObject() {
        return this.message.getMessageId();
    }

    @Override
    public void setMessageId(String messageId) {
        if (messageId == null) {
            this.message.setMessageId(null);
        } else {
            String stripped = AmqpMessageIdHelper.INSTANCE.stripMessageIdPrefix(messageId);
            this.message.setMessageId((Object)stripped);
        }
    }

    @Override
    public long getTimestamp() {
        Date timestamp;
        if (this.message.getProperties() != null && (timestamp = this.message.getProperties().getCreationTime()) != null) {
            return timestamp.getTime();
        }
        return 0L;
    }

    @Override
    public void setTimestamp(long timestamp) {
        if (timestamp != 0L) {
            this.message.setCreationTime(timestamp);
        } else if (this.message.getProperties() != null) {
            this.message.getProperties().setCreationTime(null);
        }
    }

    @Override
    public String getCorrelationId() {
        AmqpMessageIdHelper messageIdHelper = AmqpMessageIdHelper.INSTANCE;
        String baseIdString = messageIdHelper.toBaseMessageIdString(this.message.getCorrelationId());
        if (baseIdString == null) {
            return null;
        }
        Object annotation = this.getMessageAnnotation("x-opt-app-correlation-id");
        boolean appSpecific = Boolean.TRUE.equals(annotation);
        if (appSpecific) {
            return baseIdString;
        }
        return "ID:" + baseIdString;
    }

    @Override
    public void setCorrelationId(String correlationId) throws IdConversionException {
        AmqpMessageIdHelper messageIdHelper = AmqpMessageIdHelper.INSTANCE;
        boolean appSpecific = false;
        if (correlationId == null) {
            this.message.setCorrelationId(null);
        } else {
            boolean hasMessageIdPrefix = messageIdHelper.hasMessageIdPrefix(correlationId);
            if (!hasMessageIdPrefix) {
                appSpecific = true;
            }
            String stripped = messageIdHelper.stripMessageIdPrefix(correlationId);
            if (hasMessageIdPrefix) {
                Object idObject = messageIdHelper.toIdObject(stripped);
                this.message.setCorrelationId(idObject);
            } else {
                this.message.setCorrelationId((Object)stripped);
            }
        }
        if (appSpecific) {
            this.setMessageAnnotation("x-opt-app-correlation-id", true);
        } else {
            this.removeMessageAnnotation("x-opt-app-correlation-id");
        }
    }

    @Override
    public byte[] getCorrelationIdBytes() throws JMSException {
        Object correlationId = this.message.getCorrelationId();
        if (correlationId == null) {
            return null;
        }
        if (correlationId instanceof Binary) {
            ByteBuffer dup = ((Binary)correlationId).asByteBuffer();
            byte[] bytes = new byte[dup.remaining()];
            dup.get(bytes);
            return bytes;
        }
        throw new JMSException("The underlying correlation-id is not binary and so can't be returned");
    }

    @Override
    public void setCorrelationIdBytes(byte[] correlationId) {
        Binary binaryIdValue = null;
        if (correlationId != null) {
            binaryIdValue = new Binary(Arrays.copyOf(correlationId, correlationId.length));
        }
        this.message.setCorrelationId(binaryIdValue);
    }

    @Override
    public boolean isPersistent() {
        return this.message.isDurable();
    }

    @Override
    public void setPersistent(boolean value) {
        this.message.setDurable(value);
    }

    @Override
    public int getDeliveryCount() {
        return this.getRedeliveryCount() + 1;
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.setRedeliveryCount(deliveryCount - 1);
    }

    @Override
    public int getRedeliveryCount() {
        UnsignedInteger count;
        if (this.message.getHeader() != null && (count = this.message.getHeader().getDeliveryCount()) != null) {
            return count.intValue();
        }
        return 0;
    }

    @Override
    public void setRedeliveryCount(int redeliveryCount) {
        if (redeliveryCount == 0) {
            if (this.message.getHeader() != null) {
                this.message.getHeader().setDeliveryCount(null);
            }
        } else {
            this.message.setDeliveryCount((long)redeliveryCount);
        }
    }

    @Override
    public boolean isRedelivered() {
        return this.getRedeliveryCount() > 0;
    }

    @Override
    public void setRedelivered(boolean redelivered) {
        if (redelivered) {
            if (!this.isRedelivered()) {
                this.setRedeliveryCount(1);
            }
        } else if (this.isRedelivered()) {
            this.setRedeliveryCount(0);
        }
    }

    @Override
    public String getType() {
        return this.message.getSubject();
    }

    @Override
    public void setType(String type) {
        if (type != null) {
            this.message.setSubject(type);
        } else if (this.message.getProperties() != null) {
            this.message.getProperties().setSubject(null);
        }
    }

    @Override
    public int getPriority() {
        UnsignedByte priority;
        if (this.message.getHeader() != null && (priority = this.message.getHeader().getPriority()) != null) {
            int scaled = priority.intValue();
            if (scaled > 9) {
                scaled = 9;
            }
            return scaled;
        }
        return 4;
    }

    @Override
    public void setPriority(int priority) {
        if (priority == 4) {
            if (this.message.getHeader() == null) {
                return;
            }
            this.message.getHeader().setPriority(null);
        } else {
            int scaled = priority;
            if (priority < 0) {
                scaled = 0;
            } else if (priority > 9) {
                scaled = 9;
            }
            this.message.setPriority((short)scaled);
        }
    }

    @Override
    public long getExpiration() {
        Long absoluteExpiry = this.getAbsoluteExpiryTime();
        if (absoluteExpiry != null) {
            return absoluteExpiry;
        }
        if (this.syntheticExpiration != null) {
            return this.syntheticExpiration;
        }
        return 0L;
    }

    @Override
    public void setExpiration(long expiration) {
        this.syntheticExpiration = null;
        if (expiration != 0L) {
            this.setAbsoluteExpiryTime(expiration);
        } else {
            this.setAbsoluteExpiryTime(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAmqpTimeToLiveOverride(Long ttl) throws MessageFormatException {
        if (ttl != null) {
            if (ttl < 0L || ttl > 0xFFFFFFFFL) throw new MessageFormatException("JMS_AMQP_TTL must be a long with value in range 0 to 2^32 - 1");
            this.userSpecifiedTTL = ttl;
            return;
        } else {
            this.userSpecifiedTTL = null;
        }
    }

    public boolean hasAmqpTimeToLiveOverride() {
        return this.userSpecifiedTTL != null;
    }

    public long getAmqpTimeToLiveOverride() {
        return this.userSpecifiedTTL != null ? this.userSpecifiedTTL : 0L;
    }

    @Override
    public JmsDestination getDestination() {
        if (this.destination == null) {
            this.destination = AmqpDestinationHelper.INSTANCE.getJmsDestination(this, this.consumerDestination);
        }
        return this.destination;
    }

    @Override
    public void setDestination(JmsDestination destination) {
        this.destination = destination;
        this.lazyCreateMessageAnnotations();
        AmqpDestinationHelper.INSTANCE.setToAddressFromDestination(this, destination);
    }

    @Override
    public JmsDestination getReplyTo() {
        if (this.replyTo == null) {
            this.replyTo = AmqpDestinationHelper.INSTANCE.getJmsReplyTo(this, this.consumerDestination);
        }
        return this.replyTo;
    }

    @Override
    public void setReplyTo(JmsDestination replyTo) {
        this.replyTo = replyTo;
        this.lazyCreateMessageAnnotations();
        AmqpDestinationHelper.INSTANCE.setReplyToAddressFromDestination(this, replyTo);
    }

    public void setReplyToGroupId(String replyToGroupId) {
        this.message.setReplyToGroupId(replyToGroupId);
    }

    public String getReplyToGroupId() {
        return this.message.getReplyToGroupId();
    }

    @Override
    public String getUserId() {
        String userId = null;
        byte[] userIdBytes = this.message.getUserId();
        if (userIdBytes != null) {
            userId = new String(userIdBytes, UTF8);
        }
        return userId;
    }

    @Override
    public void setUserId(String userId) {
        byte[] bytes = null;
        if (userId != null) {
            bytes = userId.getBytes(UTF8);
        }
        this.message.setUserId(bytes);
    }

    @Override
    public String getGroupId() {
        return this.message.getGroupId();
    }

    @Override
    public void setGroupId(String groupId) {
        this.message.setGroupId(groupId);
    }

    @Override
    public int getGroupSequence() {
        UnsignedInteger groupSeqUint;
        if (this.message.getProperties() != null && (groupSeqUint = this.message.getProperties().getGroupSequence()) != null) {
            return groupSeqUint.intValue();
        }
        return 0;
    }

    @Override
    public void setGroupSequence(int groupSequence) {
        if (groupSequence == 0) {
            if (this.message.getProperties() != null) {
                this.message.getProperties().setGroupSequence(null);
            }
        } else {
            this.message.setGroupSequence((long)groupSequence);
        }
    }

    public Message getAmqpMessage() {
        return this.message;
    }

    public AmqpConnection getConnection() {
        return this.connection;
    }

    boolean messageAnnotationExists(String key) {
        if (this.messageAnnotationsMap == null) {
            return false;
        }
        return this.messageAnnotationsMap.containsKey(AmqpMessageSupport.getSymbol(key));
    }

    Object getMessageAnnotation(String key) {
        if (this.messageAnnotationsMap == null) {
            return null;
        }
        return this.messageAnnotationsMap.get(AmqpMessageSupport.getSymbol(key));
    }

    void removeMessageAnnotation(String key) {
        if (this.messageAnnotationsMap == null) {
            return;
        }
        this.messageAnnotationsMap.remove(AmqpMessageSupport.getSymbol(key));
    }

    void setMessageAnnotation(String key, Object value) {
        this.lazyCreateMessageAnnotations();
        this.messageAnnotationsMap.put(AmqpMessageSupport.getSymbol(key), value);
    }

    void clearMessageAnnotations() {
        this.messageAnnotationsMap = null;
        this.message.setMessageAnnotations(null);
    }

    void clearAllApplicationProperties() {
        this.applicationPropertiesMap = null;
        this.message.setApplicationProperties(null);
    }

    String getToAddress() {
        return this.message.getAddress();
    }

    void setToAddress(String address) {
        this.message.setAddress(address);
    }

    String getReplyToAddress() {
        return this.message.getReplyTo();
    }

    void setReplyToAddress(String address) {
        this.message.setReplyTo(address);
    }

    private Long getAbsoluteExpiryTime() {
        Date date;
        Long result = null;
        if (this.message.getProperties() != null && (date = this.message.getProperties().getAbsoluteExpiryTime()) != null) {
            result = date.getTime();
        }
        return result;
    }

    private Long getTtl() {
        UnsignedInteger ttl;
        Long result = null;
        if (this.message.getHeader() != null && (ttl = this.message.getHeader().getTtl()) != null) {
            result = ttl.longValue();
        }
        return result;
    }

    private void setAbsoluteExpiryTime(Long expiration) {
        if (expiration == null) {
            if (this.message.getProperties() != null) {
                this.message.getProperties().setAbsoluteExpiryTime(null);
            }
        } else {
            this.message.setExpiryTime(expiration.longValue());
        }
    }

    private void lazyCreateMessageAnnotations() {
        if (this.messageAnnotationsMap == null) {
            this.messageAnnotationsMap = new HashMap<Symbol, Object>();
            this.message.setMessageAnnotations(new MessageAnnotations(this.messageAnnotationsMap));
        }
    }

    private void lazyCreateApplicationProperties() {
        if (this.applicationPropertiesMap == null) {
            this.applicationPropertiesMap = new HashMap<String, Object>();
            this.message.setApplicationProperties(new ApplicationProperties(this.applicationPropertiesMap));
        }
    }
}

