/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.NoOpAsyncResult;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpAbstractResource;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnectionSession
extends AmqpSession {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnectionSession.class);
    private final Map<String, AsyncResult> pendingUnsubs = new HashMap<String, AsyncResult>();

    public AmqpConnectionSession(AmqpConnection connection, JmsSessionInfo info) {
        super(connection, info);
    }

    public void unsubscribe(String subscriptionName, AsyncResult request) {
        DurableSubscriptionReattach subscriber = new DurableSubscriptionReattach((JmsSessionInfo)this.getJmsResource(), subscriptionName);
        DurableSubscriptionReattachRequest subscribeRequest = new DurableSubscriptionReattachRequest(subscriber, request);
        this.pendingUnsubs.put(subscriptionName, subscribeRequest);
        LOG.debug("Attempting remove of subscription: {}", (Object)subscriptionName);
        subscriber.open(subscribeRequest);
    }

    private class DurableSubscriptionReattachRequest
    extends WrappedAsyncResult {
        private final DurableSubscriptionReattach subscriber;

        public DurableSubscriptionReattachRequest(DurableSubscriptionReattach subscriber, AsyncResult originalRequest) {
            super(originalRequest);
            this.subscriber = subscriber;
        }

        @Override
        public void onSuccess() {
            LOG.trace("Reattached to subscription: {}", (Object)this.subscriber.getSubscriptionName());
            AmqpConnectionSession.this.pendingUnsubs.remove(this.subscriber.getSubscriptionName());
            if (((Receiver)this.subscriber.getEndpoint()).getRemoteSource() != null) {
                this.subscriber.close(this.getWrappedRequest());
            } else {
                this.subscriber.close(NoOpAsyncResult.INSTANCE);
                this.getWrappedRequest().onFailure((Throwable)new InvalidDestinationException("Cannot remove a subscription that does not exist"));
            }
        }

        @Override
        public void onFailure(Throwable result) {
            LOG.trace("Failed to reattach to subscription: {}", (Object)this.subscriber.getSubscriptionName());
            AmqpConnectionSession.this.pendingUnsubs.remove(this.subscriber.getSubscriptionName());
            this.subscriber.closed();
            super.onFailure(result);
        }
    }

    private class DurableSubscriptionReattach
    extends AmqpAbstractResource<JmsSessionInfo, Receiver> {
        private final String subscriptionName;

        public DurableSubscriptionReattach(JmsSessionInfo resource, String subscriptionName) {
            super(resource, AmqpConnectionSession.this.getProtonSession().receiver(subscriptionName));
            this.subscriptionName = subscriptionName;
        }

        @Override
        protected void doOpen() {
            Receiver receiver = (Receiver)this.getEndpoint();
            receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)new Target());
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            super.doOpen();
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }
    }
}

