/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.jms.transports.Transport;
import org.apache.qpid.jms.transports.TransportListener;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.netty.PartialPooledByteBufAllocator;
import org.apache.qpid.jms.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTcpTransport.class);
    private static final int QUIET_PERIOD = 20;
    private static final int SHUTDOWN_TIMEOUT = 100;
    protected Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected Channel channel;
    protected TransportListener listener;
    protected TransportOptions options;
    protected final URI remote;
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CountDownLatch connectLatch = new CountDownLatch(1);
    private IOException failureCause;

    public NettyTcpTransport(URI remoteLocation, TransportOptions options) {
        this(null, remoteLocation, options);
    }

    public NettyTcpTransport(TransportListener listener, URI remoteLocation, TransportOptions options) {
        this.options = options;
        this.listener = listener;
        this.remote = remoteLocation;
    }

    @Override
    public void connect() throws IOException {
        if (this.listener == null) {
            throw new IllegalStateException("A transport listener must be set before connection attempts.");
        }
        this.group = new NioEventLoopGroup(1);
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.group);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel connectedChannel) throws Exception {
                NettyTcpTransport.this.configureChannel(connectedChannel);
            }
        });
        this.configureNetty(this.bootstrap, this.getTransportOptions());
        ChannelFuture future = this.bootstrap.connect(this.getRemoteHost(), this.getRemotePort());
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NettyTcpTransport.this.handleConnected(future.channel());
                } else if (future.isCancelled()) {
                    NettyTcpTransport.this.connectionFailed(new IOException("Connection attempt was cancelled"));
                } else {
                    NettyTcpTransport.this.connectionFailed(IOExceptionSupport.create(future.cause()));
                }
            }
        });
        try {
            this.connectLatch.await();
        }
        catch (InterruptedException ex) {
            LOG.debug("Transport connection was interrupted.");
            Thread.interrupted();
            this.failureCause = IOExceptionSupport.create(ex);
        }
        if (this.failureCause != null) {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            if (this.group != null) {
                this.group.shutdownGracefully(20L, 100L, TimeUnit.MILLISECONDS);
                this.group = null;
            }
            throw this.failureCause;
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.connected.set(false);
            if (this.channel != null) {
                this.channel.close().syncUninterruptibly();
            }
            if (this.group != null) {
                this.group.shutdownGracefully(20L, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public ByteBuf allocateSendBuffer(int size) throws IOException {
        this.checkConnected();
        return this.channel.alloc().ioBuffer(size, size);
    }

    @Override
    public void send(ByteBuf output) throws IOException {
        this.checkConnected();
        int length = output.readableBytes();
        if (length == 0) {
            return;
        }
        LOG.trace("Attempted write of: {} bytes", (Object)length);
        this.channel.writeAndFlush((Object)output);
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public TransportOptions getTransportOptions() {
        if (this.options == null) {
            this.options = TransportOptions.INSTANCE;
        }
        return this.options;
    }

    @Override
    public URI getRemoteLocation() {
        return this.remote;
    }

    protected String getRemoteHost() {
        return this.remote.getHost();
    }

    protected int getRemotePort() {
        return this.remote.getPort() != -1 ? this.remote.getPort() : this.getTransportOptions().getDefaultTcpPort();
    }

    protected void configureNetty(Bootstrap bootstrap, TransportOptions options) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        if (options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        if (options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
        }
    }

    protected void configureChannel(Channel channel) throws Exception {
        channel.pipeline().addLast(new ChannelHandler[]{new NettyTcpTransportHandler()});
    }

    protected void handleConnected(Channel channel) throws Exception {
        this.connectionEstablished(channel);
    }

    protected void connectionEstablished(Channel connectedChannel) {
        this.channel = connectedChannel;
        this.connected.set(true);
        this.connectLatch.countDown();
    }

    protected void connectionFailed(IOException cause) {
        this.failureCause = IOExceptionSupport.create(cause);
        this.connected.set(false);
        this.connectLatch.countDown();
    }

    private void checkConnected() throws IOException {
        if (!this.connected.get()) {
            throw new IOException("Cannot send to a non-connected transport.");
        }
    }

    private class NettyTcpTransportHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private NettyTcpTransportHandler() {
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            LOG.trace("Channel has become active! Channel is {}", (Object)context.channel());
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            LOG.trace("Channel has gone inactive! Channel is {}", (Object)context.channel());
            if (!NettyTcpTransport.this.closed.get()) {
                NettyTcpTransport.this.connected.set(false);
                NettyTcpTransport.this.listener.onTransportClosed();
            }
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            LOG.trace("Exception on channel! Channel is {}", (Object)context.channel());
            if (!NettyTcpTransport.this.closed.get()) {
                NettyTcpTransport.this.connected.set(false);
                NettyTcpTransport.this.listener.onTransportError(cause);
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            LOG.trace("New data read: {} bytes incoming: {}", (Object)buffer.readableBytes(), (Object)buffer);
            NettyTcpTransport.this.listener.onData(buffer);
        }
    }
}

