/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.apache.qpid.jms.util.IOExceptionSupport;

public class ConservativeProviderFuture
extends ProviderFuture {
    public ConservativeProviderFuture() {
        this(null);
    }

    public ConservativeProviderFuture(ProviderSynchronization synchronization) {
        super(synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sync(long amount, TimeUnit unit) throws IOException {
        try {
            if (this.isComplete() || amount == 0L) {
                this.failOnError();
                return true;
            }
            long timeout = unit.toNanos(amount);
            long maxParkNanos = timeout / 8L;
            maxParkNanos = maxParkNanos > 0L ? maxParkNanos : timeout;
            long startTime = System.nanoTime();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (true) {
                long elapsed;
                long diff;
                if ((diff = (elapsed = System.nanoTime() - startTime) - timeout) >= 0L) {
                    this.failOnError();
                    return this.isComplete();
                }
                if (this.isComplete()) {
                    this.failOnError();
                    return true;
                }
                ConservativeProviderFuture conservativeProviderFuture = this;
                synchronized (conservativeProviderFuture) {
                    if (this.isComplete()) {
                        this.failOnError();
                        return true;
                    }
                    ++this.waiting;
                    try {
                        this.wait(-diff / 1000000L, (int)(-diff % 1000000L));
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sync() throws IOException {
        try {
            if (this.isComplete()) {
                this.failOnError();
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (true) {
                if (this.isComplete()) {
                    this.failOnError();
                    return;
                }
                ConservativeProviderFuture conservativeProviderFuture = this;
                synchronized (conservativeProviderFuture) {
                    if (this.isComplete()) {
                        this.failOnError();
                        return;
                    }
                    ++this.waiting;
                    try {
                        this.wait();
                    }
                    finally {
                        --this.waiting;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
    }
}

